package com.talpa.master.ui.mark

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import com.talpa.master.R
import com.talpa.master.databinding.ItemStarMarkBinding
import com.talpa.master.ui.main.MainViewModel

/**
 * Create by kgxl on 2021/4/13
 */
class MarkAdapter(private val viewModel: MarkViewModel) : RecyclerView.Adapter<MarkAdapter.MarkViewHolder>() {
    inner class MarkViewHolder(private val binding: ItemStarMarkBinding) : RecyclerView.ViewHolder(binding.root) {
        fun bind(position: Int) {

            val history = viewModel.marks.value?.get(position)
            history?.let {
                when (it.display_type) {
                    MainViewModel.HistoryItemViewType.SOURCE.value -> {
                        binding.markParent.setBackgroundResource(viewModel.sourceBackground[position % 4])
                    }
                    MainViewModel.HistoryItemViewType.TARGET.value -> {
                        binding.markParent.setBackgroundResource(viewModel.targetBackground[position % 4])
                    }
                }
                binding.tvMainResultSource.text = it.source_result
                binding.tvMainResultText.text = it.target_result
            }
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): MarkViewHolder {
        val inflater = LayoutInflater.from(parent.context)
        val bind = DataBindingUtil.inflate<ItemStarMarkBinding>(inflater, R.layout.item_star_mark, parent, false)
        return MarkViewHolder(bind)
    }

    override fun onBindViewHolder(holder: MarkViewHolder, position: Int) {
        holder.bind(position)
    }

    override fun getItemCount(): Int = viewModel.marks.value?.size ?: 0
}