package com.talpa.master.ui.mark

import android.app.Application
import android.content.ClipData
import android.content.ClipboardManager
import android.content.Context
import android.view.View
import androidx.lifecycle.AndroidViewModel
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import com.google.android.material.snackbar.BaseTransientBottomBar
import com.google.android.material.snackbar.Snackbar
import com.talpa.master.R
import com.talpa.master.ex.RxEx
import com.talpa.master.framework.RoomHelper
import com.talpa.master.repository.room.model.History
import com.talpa.master.repository.room.dao.HistoryDao
import com.talpa.master.ui.main.MainViewModel

/**
 * Create by kgxl on 2021/4/13
 */
class MarkViewModel(application: Application, val dao: HistoryDao) :
    AndroidViewModel(application) {
    val marks = MutableLiveData<List<History>>()
    //需要自定义view,防止多次加载xml
    val sourceBackground =
        arrayListOf(R.drawable.shape_bg_translate_source_blue, R.drawable.shape_bg_translate_source_green, R.drawable.shape_bg_translate_source_orange, R.drawable.shape_bg_translate_source_yellow)
    val targetBackground =
        arrayListOf(R.drawable.shape_bg_translate_target_blue, R.drawable.shape_bg_translate_target_green, R.drawable.shape_bg_translate_target_orange, R.drawable.shape_bg_translate_target_yellow)
    companion object {
        fun factory(application: Application) = object : ViewModelProvider.Factory {
            override fun <T : ViewModel?> create(modelClass: Class<T>): T {
                return MarkViewModel(application, RoomHelper.historyDao) as T
            }
        }
    }

    fun selectHistory() {
        dao.queryAllHistoryByMark().compose(RxEx.io4mainFlowable()).subscribe {
            marks.postValue(it)
        }
    }

    private fun copyText(history: History, view: View) {
        when (history.result_type) {
            MainViewModel.TransLateResultStatus.SUCCESS.value -> {
                when (history.display_type) {
                    MainViewModel.HistoryItemViewType.SOURCE.value -> {
                        copy(view, history.target_result)
                    }
                    MainViewModel.HistoryItemViewType.TARGET.value -> {
                        copy(view, history.source_result)
                    }
                }
            }
            else -> {
                val snackBar = Snackbar.make(view, R.string.main_status_net_error, Snackbar.LENGTH_SHORT)
                snackBar.animationMode = BaseTransientBottomBar.ANIMATION_MODE_FADE
                snackBar.show()
            }
        }
    }

    /**
     * 复制译文
     */
    fun copy(view: View, text: String) {

        val context = view.context

        val cm = context.getSystemService(Context.CLIPBOARD_SERVICE) as ClipboardManager
        // 创建普通字符型ClipData
        val mClipData = ClipData.newPlainText("Label", text)
        cm.setPrimaryClip(mClipData)

        //SnackBar
        val snackBar = Snackbar.make(view, R.string.text_copy_complete, Snackbar.LENGTH_SHORT)
        snackBar.animationMode = BaseTransientBottomBar.ANIMATION_MODE_FADE
        snackBar.show()
    }

}