package com.talpa.master.ui.mark

import androidx.lifecycle.ViewModelProviders
import androidx.recyclerview.widget.LinearLayoutManager
import com.talpa.master.R
import com.talpa.master.databinding.ActivityStarMarkBinding
import com.talpa.master.ui.history.HistoryAdapter
import com.talpa.master.ui.history.HistoryViewModel
import com.talpa.master.databinding.DataBindingActivity

class StarMarkActivity : DataBindingActivity<ActivityStarMarkBinding>() {
    private val viewModel: HistoryViewModel by lazy {
        ViewModelProviders.of(this, HistoryViewModel.factory(application))
            .get(HistoryViewModel::class.java)
    }

    override fun getContentView(): Int = R.layout.activity_star_mark
    override fun initView() {
        mBinding.rvHistory.layoutManager = LinearLayoutManager(this)
        mBinding.rvHistory.adapter = HistoryAdapter(viewModel)
    }

    override fun init() {
        viewModel.selectHistoryByMark()
        viewModel.historys.observe(this, {
            mBinding.rvHistory.adapter?.notifyDataSetChanged()
        })
    }

}