package com.talpa.master.widget

import android.content.Context
import android.util.AttributeSet
import android.view.GestureDetector
import android.view.MotionEvent
import android.view.View
import androidx.appcompat.widget.AppCompatTextView


/**
 * Create by kgxl on 2021/4/13
 * 长按与点击的处理
 */
class RecordTextView(context: Context, attrs: AttributeSet?) :
    AppCompatTextView(context, attrs), View.OnTouchListener {

    private var mDetector: GestureDetector
    private var mGesture: RecordGesture
    private lateinit var onRecordListener: OnRecordListener

    init {
        mGesture = RecordGesture()
        mDetector = GestureDetector(context, mGesture)
        setOnTouchListener(this)
    }

    fun setOnRecordListener(onRecordListener: OnRecordListener) {
        this.onRecordListener = onRecordListener
        mGesture?.setOnRecordListener(onRecordListener, this)
    }

    interface OnRecordListener {
        fun onRecordClick(v: View)
        fun onRecordLongClick(v: View)
        fun onEventUp(v: View)
    }

    class RecordGesture : GestureDetector.SimpleOnGestureListener() {
        private lateinit var mOnRecordListener: OnRecordListener
        private lateinit var v: View
        fun setOnRecordListener(onRecordListener: OnRecordListener, v: View) {
            this.mOnRecordListener = onRecordListener
            this.v = v
        }

        override fun onSingleTapUp(e: MotionEvent?): Boolean {
            println("onSingleTapUp->" + e?.action)
            mOnRecordListener.onRecordClick(v)
            return super.onSingleTapUp(e)
        }

        override fun onLongPress(e: MotionEvent?) {
            println("onShowPress->" + e?.action)
            mOnRecordListener.onRecordLongClick(v)
        }
    }

    override fun onTouch(v: View, event: MotionEvent): Boolean {
        if (onRecordListener != null) {
            if (event.action == MotionEvent.ACTION_UP) {
                onRecordListener.onEventUp(v)
            }
        }
        mDetector.onTouchEvent(event)
        return true
    }
}