package com.talpa.master.widget

import android.content.Context
import android.graphics.Canvas
import android.graphics.Paint
import android.graphics.RectF
import android.util.AttributeSet
import androidx.appcompat.widget.AppCompatTextView

/**
 * Create by kgxl on 2021/4/14
 */
class RoundTextView(context: Context, attrs: AttributeSet) : AppCompatTextView(context, attrs) {
    private var mPoint: Paint = Paint(Paint.ANTI_ALIAS_FLAG)
    var rectF: RectF = RectF()

    init {
        mPoint.isDither = true
        mPoint.style = Paint.Style.FILL_AND_STROKE
    }

    fun setRoundBackground(color: Int, topLeftRadius: Int, topRightRadius: Int, bottomLeftRadius: Int, bottomRightRadius: Int) {
        mPoint.color=color

        invalidate()
    }

    override fun onDraw(canvas: Canvas?) {
        super.onDraw(canvas)
//        canvas.drawRoundRect(,)
    }
}