/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.master.repository.room.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.talpa.master.repository.room.dao.HistoryDao;
import com.talpa.master.repository.room.model.History;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class HistoryDao_Impl
implements HistoryDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<History> __insertionAdapterOfHistory;
    private final EntityDeletionOrUpdateAdapter<History> __deletionAdapterOfHistory;
    private final EntityDeletionOrUpdateAdapter<History> __updateAdapterOfHistory;
    private final SharedSQLiteStatement __preparedStmtOfClearHistory;

    public HistoryDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfHistory = new EntityInsertionAdapter<History>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `history` (`id`,`source_result`,`target_result`,`display_type`,`mills`,`end_mills`,`sourcelanguage_tag`,`sourcelanguage_name`,`targetlanguage_tag`,`targetlanguage_name`,`start_marker`,`voice_play`,`_pid`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, History value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getSource_result() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getSource_result());
                }
                if (value.getTarget_result() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTarget_result());
                }
                stmt.bindLong(4, (long)value.getDisplay_type());
                stmt.bindLong(5, value.getMills());
                stmt.bindLong(6, value.getEnd_mills());
                if (value.getSourcelanguage_tag() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getSourcelanguage_tag());
                }
                if (value.getSourcelanguage_name() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getSourcelanguage_name());
                }
                if (value.getTargetlanguage_tag() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getTargetlanguage_tag());
                }
                if (value.getTargetlanguage_name() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getTargetlanguage_name());
                }
                int _tmp = value.isStartMarker() ? 1 : 0;
                stmt.bindLong(11, (long)_tmp);
                int _tmp_1 = value.isVoicePlay() ? 1 : 0;
                stmt.bindLong(12, (long)_tmp_1);
                stmt.bindLong(13, (long)value.getPid());
            }
        };
        this.__deletionAdapterOfHistory = new EntityDeletionOrUpdateAdapter<History>(__db){

            public String createQuery() {
                return "DELETE FROM `history` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, History value) {
                stmt.bindLong(1, (long)value.getId());
            }
        };
        this.__updateAdapterOfHistory = new EntityDeletionOrUpdateAdapter<History>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `history` SET `id` = ?,`source_result` = ?,`target_result` = ?,`display_type` = ?,`mills` = ?,`end_mills` = ?,`sourcelanguage_tag` = ?,`sourcelanguage_name` = ?,`targetlanguage_tag` = ?,`targetlanguage_name` = ?,`start_marker` = ?,`voice_play` = ?,`_pid` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, History value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getSource_result() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getSource_result());
                }
                if (value.getTarget_result() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTarget_result());
                }
                stmt.bindLong(4, (long)value.getDisplay_type());
                stmt.bindLong(5, value.getMills());
                stmt.bindLong(6, value.getEnd_mills());
                if (value.getSourcelanguage_tag() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getSourcelanguage_tag());
                }
                if (value.getSourcelanguage_name() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getSourcelanguage_name());
                }
                if (value.getTargetlanguage_tag() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getTargetlanguage_tag());
                }
                if (value.getTargetlanguage_name() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getTargetlanguage_name());
                }
                int _tmp = value.isStartMarker() ? 1 : 0;
                stmt.bindLong(11, (long)_tmp);
                int _tmp_1 = value.isVoicePlay() ? 1 : 0;
                stmt.bindLong(12, (long)_tmp_1);
                stmt.bindLong(13, (long)value.getPid());
                stmt.bindLong(14, (long)value.getId());
            }
        };
        this.__preparedStmtOfClearHistory = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM history WHERE start_marker = ? AND _pid != ? AND _pid != ? AND _pid != ? ";
                return "DELETE FROM history WHERE start_marker = ? AND _pid != ? AND _pid != ? AND _pid != ? ";
            }
        };
    }

    @Override
    public void insertHistory(List<History> historys2) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfHistory.insert(historys2);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(History history) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfHistory.insert((Object)history);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteHistory(History history) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfHistory.handle((Object)history);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateStarModel(History history) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfHistory.handle((Object)history);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearHistory(boolean isStartMarker, int pid, int leftGuidePid, int GuidePid) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClearHistory.acquire();
        int _argIndex = 1;
        int _tmp = isStartMarker ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, (long)pid);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, (long)leftGuidePid);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, (long)GuidePid);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClearHistory.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public History queryHistory(String id2) {
        String _sql = "SELECT * FROM history WHERE id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM history WHERE id = ?", (int)1);
        int _argIndex = 1;
        if (id2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id2);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            History _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfSourceResult = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"source_result");
            int _cursorIndexOfTargetResult = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"target_result");
            int _cursorIndexOfDisplayType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"display_type");
            int _cursorIndexOfMills = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mills");
            int _cursorIndexOfEndMills = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"end_mills");
            int _cursorIndexOfSourcelanguageTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcelanguage_tag");
            int _cursorIndexOfSourcelanguageName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcelanguage_name");
            int _cursorIndexOfTargetlanguageTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetlanguage_tag");
            int _cursorIndexOfTargetlanguageName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetlanguage_name");
            int _cursorIndexOfIsStartMarker = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"start_marker");
            int _cursorIndexOfIsVoicePlay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"voice_play");
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_pid");
            if (_cursor.moveToFirst()) {
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                String _tmpSource_result = _cursor.isNull(_cursorIndexOfSourceResult) ? null : _cursor.getString(_cursorIndexOfSourceResult);
                String _tmpTarget_result = _cursor.isNull(_cursorIndexOfTargetResult) ? null : _cursor.getString(_cursorIndexOfTargetResult);
                int _tmpDisplay_type = _cursor.getInt(_cursorIndexOfDisplayType);
                long _tmpMills = _cursor.getLong(_cursorIndexOfMills);
                long _tmpEnd_mills = _cursor.getLong(_cursorIndexOfEndMills);
                String _tmpSourcelanguage_tag = _cursor.isNull(_cursorIndexOfSourcelanguageTag) ? null : _cursor.getString(_cursorIndexOfSourcelanguageTag);
                String _tmpSourcelanguage_name = _cursor.isNull(_cursorIndexOfSourcelanguageName) ? null : _cursor.getString(_cursorIndexOfSourcelanguageName);
                String _tmpTargetlanguage_tag = _cursor.isNull(_cursorIndexOfTargetlanguageTag) ? null : _cursor.getString(_cursorIndexOfTargetlanguageTag);
                String _tmpTargetlanguage_name = _cursor.isNull(_cursorIndexOfTargetlanguageName) ? null : _cursor.getString(_cursorIndexOfTargetlanguageName);
                int _tmp = _cursor.getInt(_cursorIndexOfIsStartMarker);
                boolean _tmpIsStartMarker = _tmp != 0;
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsVoicePlay);
                boolean _tmpIsVoicePlay = _tmp_1 != 0;
                int _tmpPid = _cursor.getInt(_cursorIndexOfPid);
                _result = new History(_tmpId, _tmpSource_result, _tmpTarget_result, _tmpDisplay_type, _tmpMills, _tmpEnd_mills, _tmpSourcelanguage_tag, _tmpSourcelanguage_name, _tmpTargetlanguage_tag, _tmpTargetlanguage_name, _tmpIsStartMarker, _tmpIsVoicePlay, _tmpPid);
            } else {
                _result = null;
            }
            History history = _result;
            return history;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<Integer> queryHistorySize() {
        String _sql = "SELECT COUNT(*) FROM history";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(*) FROM history", (int)0);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"history"}, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)HistoryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Integer _result;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        _result = _tmp;
                    } else {
                        _result = 0;
                    }
                    Integer n = _result;
                    return n;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public History queryLastHistory() {
        String _sql = "SELECT `history`.`id` AS `id`, `history`.`source_result` AS `source_result`, `history`.`target_result` AS `target_result`, `history`.`display_type` AS `display_type`, `history`.`mills` AS `mills`, `history`.`end_mills` AS `end_mills`, `history`.`sourcelanguage_tag` AS `sourcelanguage_tag`, `history`.`sourcelanguage_name` AS `sourcelanguage_name`, `history`.`targetlanguage_tag` AS `targetlanguage_tag`, `history`.`targetlanguage_name` AS `targetlanguage_name`, `history`.`start_marker` AS `start_marker`, `history`.`voice_play` AS `voice_play`, `history`.`_pid` AS `_pid` FROM history ORDER BY mills DESC LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT `history`.`id` AS `id`, `history`.`source_result` AS `source_result`, `history`.`target_result` AS `target_result`, `history`.`display_type` AS `display_type`, `history`.`mills` AS `mills`, `history`.`end_mills` AS `end_mills`, `history`.`sourcelanguage_tag` AS `sourcelanguage_tag`, `history`.`sourcelanguage_name` AS `sourcelanguage_name`, `history`.`targetlanguage_tag` AS `targetlanguage_tag`, `history`.`targetlanguage_name` AS `targetlanguage_name`, `history`.`start_marker` AS `start_marker`, `history`.`voice_play` AS `voice_play`, `history`.`_pid` AS `_pid` FROM history ORDER BY mills DESC LIMIT 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            History _result;
            boolean _cursorIndexOfId = false;
            boolean _cursorIndexOfSourceResult = true;
            int _cursorIndexOfTargetResult = 2;
            int _cursorIndexOfDisplayType = 3;
            int _cursorIndexOfMills = 4;
            int _cursorIndexOfEndMills = 5;
            int _cursorIndexOfSourcelanguageTag = 6;
            int _cursorIndexOfSourcelanguageName = 7;
            int _cursorIndexOfTargetlanguageTag = 8;
            int _cursorIndexOfTargetlanguageName = 9;
            int _cursorIndexOfIsStartMarker = 10;
            int _cursorIndexOfIsVoicePlay = 11;
            int _cursorIndexOfPid = 12;
            if (_cursor.moveToFirst()) {
                int _tmpId = _cursor.getInt(0);
                String _tmpSource_result = _cursor.isNull(1) ? null : _cursor.getString(1);
                String _tmpTarget_result = _cursor.isNull(2) ? null : _cursor.getString(2);
                int _tmpDisplay_type = _cursor.getInt(3);
                long _tmpMills = _cursor.getLong(4);
                long _tmpEnd_mills = _cursor.getLong(5);
                String _tmpSourcelanguage_tag = _cursor.isNull(6) ? null : _cursor.getString(6);
                String _tmpSourcelanguage_name = _cursor.isNull(7) ? null : _cursor.getString(7);
                String _tmpTargetlanguage_tag = _cursor.isNull(8) ? null : _cursor.getString(8);
                String _tmpTargetlanguage_name = _cursor.isNull(9) ? null : _cursor.getString(9);
                int _tmp = _cursor.getInt(10);
                boolean _tmpIsStartMarker = _tmp != 0;
                int _tmp_1 = _cursor.getInt(11);
                boolean _tmpIsVoicePlay = _tmp_1 != 0;
                int _tmpPid = _cursor.getInt(12);
                _result = new History(_tmpId, _tmpSource_result, _tmpTarget_result, _tmpDisplay_type, _tmpMills, _tmpEnd_mills, _tmpSourcelanguage_tag, _tmpSourcelanguage_name, _tmpTargetlanguage_tag, _tmpTargetlanguage_name, _tmpIsStartMarker, _tmpIsVoicePlay, _tmpPid);
            } else {
                _result = null;
            }
            History history = _result;
            return history;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<List<History>> queryAllHistoryByMark() {
        String _sql = "SELECT `history`.`id` AS `id`, `history`.`source_result` AS `source_result`, `history`.`target_result` AS `target_result`, `history`.`display_type` AS `display_type`, `history`.`mills` AS `mills`, `history`.`end_mills` AS `end_mills`, `history`.`sourcelanguage_tag` AS `sourcelanguage_tag`, `history`.`sourcelanguage_name` AS `sourcelanguage_name`, `history`.`targetlanguage_tag` AS `targetlanguage_tag`, `history`.`targetlanguage_name` AS `targetlanguage_name`, `history`.`start_marker` AS `start_marker`, `history`.`voice_play` AS `voice_play`, `history`.`_pid` AS `_pid` FROM history WHERE start_marker=1 ORDER BY end_mills DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT `history`.`id` AS `id`, `history`.`source_result` AS `source_result`, `history`.`target_result` AS `target_result`, `history`.`display_type` AS `display_type`, `history`.`mills` AS `mills`, `history`.`end_mills` AS `end_mills`, `history`.`sourcelanguage_tag` AS `sourcelanguage_tag`, `history`.`sourcelanguage_name` AS `sourcelanguage_name`, `history`.`targetlanguage_tag` AS `targetlanguage_tag`, `history`.`targetlanguage_name` AS `targetlanguage_name`, `history`.`start_marker` AS `start_marker`, `history`.`voice_play` AS `voice_play`, `history`.`_pid` AS `_pid` FROM history WHERE start_marker=1 ORDER BY end_mills DESC", (int)0);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"history"}, (Callable)new Callable<List<History>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<History> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)HistoryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    boolean _cursorIndexOfId = false;
                    boolean _cursorIndexOfSourceResult = true;
                    int _cursorIndexOfTargetResult = 2;
                    int _cursorIndexOfDisplayType = 3;
                    int _cursorIndexOfMills = 4;
                    int _cursorIndexOfEndMills = 5;
                    int _cursorIndexOfSourcelanguageTag = 6;
                    int _cursorIndexOfSourcelanguageName = 7;
                    int _cursorIndexOfTargetlanguageTag = 8;
                    int _cursorIndexOfTargetlanguageName = 9;
                    int _cursorIndexOfIsStartMarker = 10;
                    int _cursorIndexOfIsVoicePlay = 11;
                    int _cursorIndexOfPid = 12;
                    ArrayList<History> _result = new ArrayList<History>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        int _tmpId = _cursor.getInt(0);
                        String _tmpSource_result = _cursor.isNull(1) ? null : _cursor.getString(1);
                        String _tmpTarget_result = _cursor.isNull(2) ? null : _cursor.getString(2);
                        int _tmpDisplay_type = _cursor.getInt(3);
                        long _tmpMills = _cursor.getLong(4);
                        long _tmpEnd_mills = _cursor.getLong(5);
                        String _tmpSourcelanguage_tag = _cursor.isNull(6) ? null : _cursor.getString(6);
                        String _tmpSourcelanguage_name = _cursor.isNull(7) ? null : _cursor.getString(7);
                        String _tmpTargetlanguage_tag = _cursor.isNull(8) ? null : _cursor.getString(8);
                        String _tmpTargetlanguage_name = _cursor.isNull(9) ? null : _cursor.getString(9);
                        int _tmp = _cursor.getInt(10);
                        boolean _tmpIsStartMarker = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(11);
                        boolean _tmpIsVoicePlay = _tmp_1 != 0;
                        int _tmpPid = _cursor.getInt(12);
                        History _item = new History(_tmpId, _tmpSource_result, _tmpTarget_result, _tmpDisplay_type, _tmpMills, _tmpEnd_mills, _tmpSourcelanguage_tag, _tmpSourcelanguage_name, _tmpTargetlanguage_tag, _tmpTargetlanguage_name, _tmpIsStartMarker, _tmpIsVoicePlay, _tmpPid);
                        _result.add(_item);
                    }
                    ArrayList<History> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flowable<List<History>> queryLatestHistory() {
        String _sql = "SELECT `history`.`id` AS `id`, `history`.`source_result` AS `source_result`, `history`.`target_result` AS `target_result`, `history`.`display_type` AS `display_type`, `history`.`mills` AS `mills`, `history`.`end_mills` AS `end_mills`, `history`.`sourcelanguage_tag` AS `sourcelanguage_tag`, `history`.`sourcelanguage_name` AS `sourcelanguage_name`, `history`.`targetlanguage_tag` AS `targetlanguage_tag`, `history`.`targetlanguage_name` AS `targetlanguage_name`, `history`.`start_marker` AS `start_marker`, `history`.`voice_play` AS `voice_play`, `history`.`_pid` AS `_pid` FROM history ORDER BY mills DESC LIMIT 30";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT `history`.`id` AS `id`, `history`.`source_result` AS `source_result`, `history`.`target_result` AS `target_result`, `history`.`display_type` AS `display_type`, `history`.`mills` AS `mills`, `history`.`end_mills` AS `end_mills`, `history`.`sourcelanguage_tag` AS `sourcelanguage_tag`, `history`.`sourcelanguage_name` AS `sourcelanguage_name`, `history`.`targetlanguage_tag` AS `targetlanguage_tag`, `history`.`targetlanguage_name` AS `targetlanguage_name`, `history`.`start_marker` AS `start_marker`, `history`.`voice_play` AS `voice_play`, `history`.`_pid` AS `_pid` FROM history ORDER BY mills DESC LIMIT 30", (int)0);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"history"}, (Callable)new Callable<List<History>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<History> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)HistoryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    boolean _cursorIndexOfId = false;
                    boolean _cursorIndexOfSourceResult = true;
                    int _cursorIndexOfTargetResult = 2;
                    int _cursorIndexOfDisplayType = 3;
                    int _cursorIndexOfMills = 4;
                    int _cursorIndexOfEndMills = 5;
                    int _cursorIndexOfSourcelanguageTag = 6;
                    int _cursorIndexOfSourcelanguageName = 7;
                    int _cursorIndexOfTargetlanguageTag = 8;
                    int _cursorIndexOfTargetlanguageName = 9;
                    int _cursorIndexOfIsStartMarker = 10;
                    int _cursorIndexOfIsVoicePlay = 11;
                    int _cursorIndexOfPid = 12;
                    ArrayList<History> _result = new ArrayList<History>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        int _tmpId = _cursor.getInt(0);
                        String _tmpSource_result = _cursor.isNull(1) ? null : _cursor.getString(1);
                        String _tmpTarget_result = _cursor.isNull(2) ? null : _cursor.getString(2);
                        int _tmpDisplay_type = _cursor.getInt(3);
                        long _tmpMills = _cursor.getLong(4);
                        long _tmpEnd_mills = _cursor.getLong(5);
                        String _tmpSourcelanguage_tag = _cursor.isNull(6) ? null : _cursor.getString(6);
                        String _tmpSourcelanguage_name = _cursor.isNull(7) ? null : _cursor.getString(7);
                        String _tmpTargetlanguage_tag = _cursor.isNull(8) ? null : _cursor.getString(8);
                        String _tmpTargetlanguage_name = _cursor.isNull(9) ? null : _cursor.getString(9);
                        int _tmp = _cursor.getInt(10);
                        boolean _tmpIsStartMarker = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(11);
                        boolean _tmpIsVoicePlay = _tmp_1 != 0;
                        int _tmpPid = _cursor.getInt(12);
                        History _item = new History(_tmpId, _tmpSource_result, _tmpTarget_result, _tmpDisplay_type, _tmpMills, _tmpEnd_mills, _tmpSourcelanguage_tag, _tmpSourcelanguage_name, _tmpTargetlanguage_tag, _tmpTargetlanguage_name, _tmpIsStartMarker, _tmpIsVoicePlay, _tmpPid);
                        _result.add(_item);
                    }
                    ArrayList<History> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flowable<List<History>> queryLatestHistoryByPid(int pid) {
        String _sql = "SELECT * FROM history WHERE _pid=? ORDER BY mills DESC LIMIT 30";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM history WHERE _pid=? ORDER BY mills DESC LIMIT 30", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)pid);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"history"}, (Callable)new Callable<List<History>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<History> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)HistoryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfSourceResult = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"source_result");
                    int _cursorIndexOfTargetResult = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"target_result");
                    int _cursorIndexOfDisplayType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"display_type");
                    int _cursorIndexOfMills = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mills");
                    int _cursorIndexOfEndMills = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"end_mills");
                    int _cursorIndexOfSourcelanguageTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcelanguage_tag");
                    int _cursorIndexOfSourcelanguageName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcelanguage_name");
                    int _cursorIndexOfTargetlanguageTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetlanguage_tag");
                    int _cursorIndexOfTargetlanguageName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetlanguage_name");
                    int _cursorIndexOfIsStartMarker = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"start_marker");
                    int _cursorIndexOfIsVoicePlay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"voice_play");
                    int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_pid");
                    ArrayList<History> _result = new ArrayList<History>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        int _tmpId = _cursor.getInt(_cursorIndexOfId);
                        String _tmpSource_result = _cursor.isNull(_cursorIndexOfSourceResult) ? null : _cursor.getString(_cursorIndexOfSourceResult);
                        String _tmpTarget_result = _cursor.isNull(_cursorIndexOfTargetResult) ? null : _cursor.getString(_cursorIndexOfTargetResult);
                        int _tmpDisplay_type = _cursor.getInt(_cursorIndexOfDisplayType);
                        long _tmpMills = _cursor.getLong(_cursorIndexOfMills);
                        long _tmpEnd_mills = _cursor.getLong(_cursorIndexOfEndMills);
                        String _tmpSourcelanguage_tag = _cursor.isNull(_cursorIndexOfSourcelanguageTag) ? null : _cursor.getString(_cursorIndexOfSourcelanguageTag);
                        String _tmpSourcelanguage_name = _cursor.isNull(_cursorIndexOfSourcelanguageName) ? null : _cursor.getString(_cursorIndexOfSourcelanguageName);
                        String _tmpTargetlanguage_tag = _cursor.isNull(_cursorIndexOfTargetlanguageTag) ? null : _cursor.getString(_cursorIndexOfTargetlanguageTag);
                        String _tmpTargetlanguage_name = _cursor.isNull(_cursorIndexOfTargetlanguageName) ? null : _cursor.getString(_cursorIndexOfTargetlanguageName);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsStartMarker);
                        boolean _tmpIsStartMarker = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsVoicePlay);
                        boolean _tmpIsVoicePlay = _tmp_1 != 0;
                        int _tmpPid = _cursor.getInt(_cursorIndexOfPid);
                        History _item = new History(_tmpId, _tmpSource_result, _tmpTarget_result, _tmpDisplay_type, _tmpMills, _tmpEnd_mills, _tmpSourcelanguage_tag, _tmpSourcelanguage_name, _tmpTargetlanguage_tag, _tmpTargetlanguage_name, _tmpIsStartMarker, _tmpIsVoicePlay, _tmpPid);
                        _result.add(_item);
                    }
                    ArrayList<History> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public History queryGuideByPid(int pid) {
        String _sql = "SELECT * FROM history WHERE _pid=? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM history WHERE _pid=? LIMIT 1", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)pid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            History _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfSourceResult = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"source_result");
            int _cursorIndexOfTargetResult = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"target_result");
            int _cursorIndexOfDisplayType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"display_type");
            int _cursorIndexOfMills = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mills");
            int _cursorIndexOfEndMills = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"end_mills");
            int _cursorIndexOfSourcelanguageTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcelanguage_tag");
            int _cursorIndexOfSourcelanguageName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourcelanguage_name");
            int _cursorIndexOfTargetlanguageTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetlanguage_tag");
            int _cursorIndexOfTargetlanguageName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetlanguage_name");
            int _cursorIndexOfIsStartMarker = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"start_marker");
            int _cursorIndexOfIsVoicePlay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"voice_play");
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_pid");
            if (_cursor.moveToFirst()) {
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                String _tmpSource_result = _cursor.isNull(_cursorIndexOfSourceResult) ? null : _cursor.getString(_cursorIndexOfSourceResult);
                String _tmpTarget_result = _cursor.isNull(_cursorIndexOfTargetResult) ? null : _cursor.getString(_cursorIndexOfTargetResult);
                int _tmpDisplay_type = _cursor.getInt(_cursorIndexOfDisplayType);
                long _tmpMills = _cursor.getLong(_cursorIndexOfMills);
                long _tmpEnd_mills = _cursor.getLong(_cursorIndexOfEndMills);
                String _tmpSourcelanguage_tag = _cursor.isNull(_cursorIndexOfSourcelanguageTag) ? null : _cursor.getString(_cursorIndexOfSourcelanguageTag);
                String _tmpSourcelanguage_name = _cursor.isNull(_cursorIndexOfSourcelanguageName) ? null : _cursor.getString(_cursorIndexOfSourcelanguageName);
                String _tmpTargetlanguage_tag = _cursor.isNull(_cursorIndexOfTargetlanguageTag) ? null : _cursor.getString(_cursorIndexOfTargetlanguageTag);
                String _tmpTargetlanguage_name = _cursor.isNull(_cursorIndexOfTargetlanguageName) ? null : _cursor.getString(_cursorIndexOfTargetlanguageName);
                int _tmp = _cursor.getInt(_cursorIndexOfIsStartMarker);
                boolean _tmpIsStartMarker = _tmp != 0;
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsVoicePlay);
                boolean _tmpIsVoicePlay = _tmp_1 != 0;
                int _tmpPid = _cursor.getInt(_cursorIndexOfPid);
                _result = new History(_tmpId, _tmpSource_result, _tmpTarget_result, _tmpDisplay_type, _tmpMills, _tmpEnd_mills, _tmpSourcelanguage_tag, _tmpSourcelanguage_name, _tmpTargetlanguage_tag, _tmpTargetlanguage_name, _tmpIsStartMarker, _tmpIsVoicePlay, _tmpPid);
            } else {
                _result = null;
            }
            History history = _result;
            return history;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<List<History>> all() {
        String _sql = "SELECT `history`.`id` AS `id`, `history`.`source_result` AS `source_result`, `history`.`target_result` AS `target_result`, `history`.`display_type` AS `display_type`, `history`.`mills` AS `mills`, `history`.`end_mills` AS `end_mills`, `history`.`sourcelanguage_tag` AS `sourcelanguage_tag`, `history`.`sourcelanguage_name` AS `sourcelanguage_name`, `history`.`targetlanguage_tag` AS `targetlanguage_tag`, `history`.`targetlanguage_name` AS `targetlanguage_name`, `history`.`start_marker` AS `start_marker`, `history`.`voice_play` AS `voice_play`, `history`.`_pid` AS `_pid` FROM history";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT `history`.`id` AS `id`, `history`.`source_result` AS `source_result`, `history`.`target_result` AS `target_result`, `history`.`display_type` AS `display_type`, `history`.`mills` AS `mills`, `history`.`end_mills` AS `end_mills`, `history`.`sourcelanguage_tag` AS `sourcelanguage_tag`, `history`.`sourcelanguage_name` AS `sourcelanguage_name`, `history`.`targetlanguage_tag` AS `targetlanguage_tag`, `history`.`targetlanguage_name` AS `targetlanguage_name`, `history`.`start_marker` AS `start_marker`, `history`.`voice_play` AS `voice_play`, `history`.`_pid` AS `_pid` FROM history", (int)0);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"history"}, (Callable)new Callable<List<History>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<History> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)HistoryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    boolean _cursorIndexOfId = false;
                    boolean _cursorIndexOfSourceResult = true;
                    int _cursorIndexOfTargetResult = 2;
                    int _cursorIndexOfDisplayType = 3;
                    int _cursorIndexOfMills = 4;
                    int _cursorIndexOfEndMills = 5;
                    int _cursorIndexOfSourcelanguageTag = 6;
                    int _cursorIndexOfSourcelanguageName = 7;
                    int _cursorIndexOfTargetlanguageTag = 8;
                    int _cursorIndexOfTargetlanguageName = 9;
                    int _cursorIndexOfIsStartMarker = 10;
                    int _cursorIndexOfIsVoicePlay = 11;
                    int _cursorIndexOfPid = 12;
                    ArrayList<History> _result = new ArrayList<History>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        int _tmpId = _cursor.getInt(0);
                        String _tmpSource_result = _cursor.isNull(1) ? null : _cursor.getString(1);
                        String _tmpTarget_result = _cursor.isNull(2) ? null : _cursor.getString(2);
                        int _tmpDisplay_type = _cursor.getInt(3);
                        long _tmpMills = _cursor.getLong(4);
                        long _tmpEnd_mills = _cursor.getLong(5);
                        String _tmpSourcelanguage_tag = _cursor.isNull(6) ? null : _cursor.getString(6);
                        String _tmpSourcelanguage_name = _cursor.isNull(7) ? null : _cursor.getString(7);
                        String _tmpTargetlanguage_tag = _cursor.isNull(8) ? null : _cursor.getString(8);
                        String _tmpTargetlanguage_name = _cursor.isNull(9) ? null : _cursor.getString(9);
                        int _tmp = _cursor.getInt(10);
                        boolean _tmpIsStartMarker = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(11);
                        boolean _tmpIsVoicePlay = _tmp_1 != 0;
                        int _tmpPid = _cursor.getInt(12);
                        History _item = new History(_tmpId, _tmpSource_result, _tmpTarget_result, _tmpDisplay_type, _tmpMills, _tmpEnd_mills, _tmpSourcelanguage_tag, _tmpSourcelanguage_name, _tmpTargetlanguage_tag, _tmpTargetlanguage_name, _tmpIsStartMarker, _tmpIsVoicePlay, _tmpPid);
                        _result.add(_item);
                    }
                    ArrayList<History> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

