/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.master.ui.main;

import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.MutableLiveData;
import com.talpa.master.ui.main.OnBeginningOfSpeech;
import com.talpa.master.ui.main.OnBufferReceived;
import com.talpa.master.ui.main.OnEndOfSpeech;
import com.talpa.master.ui.main.OnError;
import com.talpa.master.ui.main.OnEvent;
import com.talpa.master.ui.main.OnPartialResults;
import com.talpa.master.ui.main.OnReadyForSpeech;
import com.talpa.master.ui.main.OnResults;
import com.talpa.master.ui.main.OnRmsChanged;
import com.talpa.master.ui.main.RecognitionState;
import com.talpa.master.ui.main.SpeechViewModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"H\u0002J\u0006\u0010#\u001a\u00020\u001eJ\u0010\u0010$\u001a\u00020\u001e2\b\b\u0002\u0010!\u001a\u00020\"J\u0006\u0010%\u001a\u00020\u001cR'\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\f\u001a\u0004\b\u000f\u0010\nR!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\f\u001a\u0004\b\u0013\u0010\nR#\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\f\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lcom/talpa/master/ui/main/SpeechViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "recognitionResults", "Landroidx/lifecycle/MutableLiveData;", "Ljava/util/ArrayList;", "", "getRecognitionResults", "()Landroidx/lifecycle/MutableLiveData;", "recognitionResults$delegate", "Lkotlin/Lazy;", "recognitionState", "Lcom/talpa/master/ui/main/RecognitionState;", "getRecognitionState", "recognitionState$delegate", "rmsdBState", "", "getRmsdBState", "rmsdBState$delegate", "speechRecognizer", "Landroid/speech/SpeechRecognizer;", "kotlin.jvm.PlatformType", "getSpeechRecognizer", "()Landroid/speech/SpeechRecognizer;", "speechRecognizer$delegate", "finishRecognize", "", "isFinishRecoginze", "", "recognizerIntent", "Landroid/content/Intent;", "locale", "Ljava/util/Locale;", "speechRecognizeAvailable", "startRecognize", "stopRecognize", "OnRecognitionListener", "Translate_release"})
public final class SpeechViewModel
extends AndroidViewModel {
    @NotNull
    private final Lazy rmsdBState$delegate;
    @NotNull
    private final Lazy recognitionResults$delegate;
    @NotNull
    private final Lazy recognitionState$delegate;
    @NotNull
    private final Lazy speechRecognizer$delegate;

    public SpeechViewModel(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
        this.rmsdBState$delegate = LazyKt.lazy((Function0)rmsdBState.2.INSTANCE);
        this.recognitionResults$delegate = LazyKt.lazy((Function0)recognitionResults.2.INSTANCE);
        this.recognitionState$delegate = LazyKt.lazy((Function0)recognitionState.2.INSTANCE);
        this.speechRecognizer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SpeechRecognizer>(this){
            final /* synthetic */ SpeechViewModel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final SpeechRecognizer invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ComponentName componentName;
                List list = this.this$0.getApplication().getPackageManager().queryIntentServices(new Intent("android.speech.RecognitionService"), 0);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getApplication<Applicati\u2026TERFACE), 0\n            )");
                List list2 = list;
                ResolveInfo resolveInfo = (ResolveInfo)CollectionsKt.firstOrNull((List)list2);
                if (resolveInfo != null && (resolveInfo = resolveInfo.serviceInfo) != null) {
                    ResolveInfo it = resolveInfo;
                    boolean bl = false;
                    componentName = new ComponentName(it.packageName, it.name);
                } else {
                    componentName = null;
                }
                ComponentName componentName2 = componentName;
                Iterable iterable = list2;
                StringBuilder stringBuilder = new StringBuilder().append("list=====");
                boolean $i$f$map = false;
                void var5_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ResolveInfo resolveInfo2 = (ResolveInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    ServiceInfo serviceInfo = it.serviceInfo;
                    ServiceInfo serviceInfo2 = it.serviceInfo;
                    collection.add((serviceInfo != null ? serviceInfo.name : null) + '_' + (serviceInfo2 != null ? Boolean.valueOf(serviceInfo2.isEnabled()) : null));
                }
                System.out.println((Object)stringBuilder.append((List)destination$iv$iv).toString());
                return SpeechRecognizer.createSpeechRecognizer((Context)((Context)this.this$0.getApplication()), (ComponentName)componentName2);
            }
        }));
    }

    @NotNull
    public final MutableLiveData<Float> getRmsdBState() {
        Lazy lazy = this.rmsdBState$delegate;
        return (MutableLiveData)lazy.getValue();
    }

    @NotNull
    public final MutableLiveData<ArrayList<String>> getRecognitionResults() {
        Lazy lazy = this.recognitionResults$delegate;
        return (MutableLiveData)lazy.getValue();
    }

    @NotNull
    public final MutableLiveData<RecognitionState> getRecognitionState() {
        Lazy lazy = this.recognitionState$delegate;
        return (MutableLiveData)lazy.getValue();
    }

    private final SpeechRecognizer getSpeechRecognizer() {
        Lazy lazy = this.speechRecognizer$delegate;
        return (SpeechRecognizer)lazy.getValue();
    }

    public final boolean speechRecognizeAvailable() {
        ResolveInfo resolveInfo;
        ComponentName componentName;
        ComponentName componentName2;
        List list = this.getApplication().getPackageManager().queryIntentServices(new Intent("android.speech.RecognitionService"), 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getApplication<Applicati\u2026TERFACE), 0\n            )");
        List list2 = list;
        ResolveInfo resolveInfo2 = (ResolveInfo)CollectionsKt.firstOrNull((List)list2);
        if (resolveInfo2 != null && (resolveInfo2 = resolveInfo2.serviceInfo) != null) {
            ResolveInfo it = resolveInfo2;
            boolean bl = false;
            componentName2 = new ComponentName(it.packageName, it.name);
        } else {
            componentName2 = componentName = null;
        }
        return componentName != null && ((resolveInfo = (ResolveInfo)CollectionsKt.firstOrNull((List)list2)) != null && (resolveInfo = resolveInfo.serviceInfo) != null ? resolveInfo.enabled : false);
    }

    public final boolean startRecognize(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        try {
            boolean isRecognitionAvailable = SpeechRecognizer.isRecognitionAvailable((Context)((Context)this.getApplication()));
            System.out.println((Object)("isRecognitionAvailable=" + isRecognitionAvailable));
            this.getSpeechRecognizer().setRecognitionListener((RecognitionListener)new OnRecognitionListener());
            Intent recognizerIntent = this.recognizerIntent(locale);
            this.getSpeechRecognizer().startListening(recognizerIntent);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static /* synthetic */ boolean startRecognize$default(SpeechViewModel speechViewModel, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        return speechViewModel.startRecognize(locale);
    }

    public final void finishRecognize() {
        try {
            this.getSpeechRecognizer().stopListening();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void stopRecognize() {
        try {
            this.getSpeechRecognizer().stopListening();
            this.getSpeechRecognizer().cancel();
            this.getSpeechRecognizer().destroy();
            this.getRecognitionState().setValue((Object)OnEndOfSpeech.INSTANCE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final boolean isFinishRecoginze() {
        return !Intrinsics.areEqual((Object)this.getRecognitionState().getValue(), (Object)OnReadyForSpeech.INSTANCE) && !Intrinsics.areEqual((Object)this.getRecognitionState().getValue(), (Object)OnBeginningOfSpeech.INSTANCE) && !Intrinsics.areEqual((Object)this.getRecognitionState().getValue(), (Object)OnRmsChanged.INSTANCE);
    }

    private final Intent recognizerIntent(Locale locale) {
        Intent intent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        intent.putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
        intent.putExtra("android.speech.extra.PARTIAL_RESULTS", true);
        intent.putExtra("android.speech.extras.SPEECH_INPUT_MINIMUM_LENGTH_MILLIS", 600000000);
        intent.putExtra("android.speech.extra.LANGUAGE", locale.toLanguageTag());
        return intent;
    }

    static /* synthetic */ Intent recognizerIntent$default(SpeechViewModel speechViewModel, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        return speechViewModel.recognizerIntent(locale);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0012\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0013\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/talpa/master/ui/main/SpeechViewModel$OnRecognitionListener;", "Landroid/speech/RecognitionListener;", "(Lcom/talpa/master/ui/main/SpeechViewModel;)V", "onBeginningOfSpeech", "", "onBufferReceived", "buffer", "", "onEndOfSpeech", "onError", "error", "", "onEvent", "eventType", "params", "Landroid/os/Bundle;", "onPartialResults", "results", "onReadyForSpeech", "onResults", "onRmsChanged", "rmsdB", "", "Translate_release"})
    private final class OnRecognitionListener
    implements RecognitionListener {
        public void onReadyForSpeech(@Nullable Bundle params) {
            OnReadyForSpeech state2 = (OnReadyForSpeech)OnReadyForSpeech.INSTANCE.init((Function1)new Function1<OnReadyForSpeech, Unit>(params){
                final /* synthetic */ Bundle $params;
                {
                    this.$params = $params;
                    super(1);
                }

                public final void invoke(@NotNull OnReadyForSpeech $this$init) {
                    Intrinsics.checkNotNullParameter((Object)$this$init, (String)"$this$init");
                    OnReadyForSpeech.INSTANCE.setParams(this.$params);
                }
            });
            SpeechViewModel.this.getRecognitionState().setValue((Object)state2);
        }

        public void onBeginningOfSpeech() {
            SpeechViewModel.this.getRecognitionState().setValue((Object)OnBeginningOfSpeech.INSTANCE);
        }

        public void onRmsChanged(float rmsdB) {
            SpeechViewModel.this.getRmsdBState().setValue((Object)Float.valueOf(rmsdB));
            OnRmsChanged state2 = (OnRmsChanged)OnRmsChanged.INSTANCE.init((Function1)new Function1<OnRmsChanged, Unit>(rmsdB){
                final /* synthetic */ float $rmsdB;
                {
                    this.$rmsdB = $rmsdB;
                    super(1);
                }

                public final void invoke(@NotNull OnRmsChanged $this$init) {
                    Intrinsics.checkNotNullParameter((Object)$this$init, (String)"$this$init");
                    OnRmsChanged.INSTANCE.setRmsdB(this.$rmsdB);
                }
            });
            SpeechViewModel.this.getRecognitionState().setValue((Object)state2);
        }

        public void onBufferReceived(@Nullable byte[] buffer) {
            OnBufferReceived state2 = (OnBufferReceived)OnBufferReceived.INSTANCE.init((Function1)new Function1<OnBufferReceived, Unit>(buffer){
                final /* synthetic */ byte[] $buffer;
                {
                    this.$buffer = $buffer;
                    super(1);
                }

                public final void invoke(@NotNull OnBufferReceived $this$init) {
                    Intrinsics.checkNotNullParameter((Object)$this$init, (String)"$this$init");
                    OnBufferReceived.INSTANCE.setBuffer(this.$buffer);
                }
            });
            SpeechViewModel.this.getRecognitionState().setValue((Object)state2);
        }

        public void onEndOfSpeech() {
            SpeechViewModel.this.getRecognitionState().setValue((Object)OnEndOfSpeech.INSTANCE);
        }

        public void onError(int error) {
            OnError state2 = (OnError)OnError.INSTANCE.init((Function1)new Function1<OnError, Unit>(error){
                final /* synthetic */ int $error;
                {
                    this.$error = $error;
                    super(1);
                }

                public final void invoke(@NotNull OnError $this$init) {
                    Intrinsics.checkNotNullParameter((Object)$this$init, (String)"$this$init");
                    OnError.INSTANCE.setError(this.$error);
                }
            });
            SpeechViewModel.this.getRecognitionState().setValue((Object)state2);
        }

        public void onResults(@Nullable Bundle results) {
            ArrayList recognitionTempResults;
            Bundle bundle = results;
            ArrayList arrayList = recognitionTempResults = bundle != null ? bundle.getStringArrayList("results_recognition") : null;
            if (arrayList != null) {
                ArrayList arrayList2 = arrayList;
                SpeechViewModel speechViewModel = SpeechViewModel.this;
                ArrayList it = arrayList2;
                boolean bl = false;
                speechViewModel.getRecognitionResults().setValue((Object)it);
            }
            SpeechViewModel.this.getRecognitionState().setValue(OnResults.INSTANCE.init((Function1)new Function1<OnResults, Unit>(results){
                final /* synthetic */ Bundle $results;
                {
                    this.$results = $results;
                    super(1);
                }

                public final void invoke(@NotNull OnResults $this$init) {
                    Intrinsics.checkNotNullParameter((Object)$this$init, (String)"$this$init");
                    OnResults.INSTANCE.setResults(this.$results);
                }
            }));
        }

        public void onPartialResults(@Nullable Bundle results) {
            Bundle bundle = results;
            ArrayList partialResults = bundle != null ? bundle.getStringArrayList("results_recognition") : null;
            OnPartialResults state2 = (OnPartialResults)OnPartialResults.INSTANCE.init((Function1)new Function1<OnPartialResults, Unit>(results){
                final /* synthetic */ Bundle $results;
                {
                    this.$results = $results;
                    super(1);
                }

                public final void invoke(@NotNull OnPartialResults $this$init) {
                    Intrinsics.checkNotNullParameter((Object)$this$init, (String)"$this$init");
                    OnPartialResults.INSTANCE.setResults(this.$results);
                }
            });
            SpeechViewModel.this.getRecognitionState().setValue((Object)state2);
        }

        public void onEvent(int eventType, @Nullable Bundle params) {
            OnEvent state2 = (OnEvent)OnEvent.INSTANCE.init((Function1)new Function1<OnEvent, Unit>(eventType, params){
                final /* synthetic */ int $eventType;
                final /* synthetic */ Bundle $params;
                {
                    this.$eventType = $eventType;
                    this.$params = $params;
                    super(1);
                }

                public final void invoke(@NotNull OnEvent $this$init) {
                    Intrinsics.checkNotNullParameter((Object)$this$init, (String)"$this$init");
                    OnEvent.INSTANCE.setEventType(this.$eventType);
                    OnEvent.INSTANCE.setParams(this.$params);
                }
            });
            SpeechViewModel.this.getRecognitionState().setValue((Object)state2);
        }
    }
}

