/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.master.utils;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.media.AudioRecord;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.View;
import androidx.core.os.LocaleListCompat;
import com.talpa.master.MoLContentProvider;
import com.talpa.master.common.LanguageListUtilsKt;
import java.lang.reflect.Method;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001f\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\f\"\u00020\b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0004J\u0006\u0010\u0015\u001a\u00020\u0004\u00a8\u0006\u0016"}, d2={"Lcom/talpa/master/utils/AppUtil;", "", "()V", "checkApkExist", "", "context", "Landroid/content/Context;", "packageName", "", "getLocaleListCompat", "Landroidx/core/os/LocaleListCompat;", "languages", "", "([Ljava/lang/String;)Landroidx/core/os/LocaleListCompat;", "getOsType", "isDarkTheme", "isHiOS", "isNavigationBarShown", "activity", "Landroid/app/Activity;", "phoneIsInUses", "validateMicAvailability", "Translate_release"})
public final class AppUtil {
    @NotNull
    public static final AppUtil INSTANCE = new AppUtil();

    private AppUtil() {
    }

    public final boolean isDarkTheme(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int flag = context.getResources().getConfiguration().uiMode & 0x30;
        return flag == 32;
    }

    @NotNull
    public final LocaleListCompat getLocaleListCompat(String ... languages) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)languages, (String)"languages");
        StringBuilder builder = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] $this$forEach$iv = languages;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            builder.append(it);
            builder.append(",");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder()\n        \u2026\n            }.toString()");
        String supportList = string2;
        String string3 = Locale.getDefault().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDefault().language");
        LocaleListCompat localeListCompat = LocaleListCompat.forLanguageTags((String)LanguageListUtilsKt.getOrderedLanguageList(string3, supportList));
        Intrinsics.checkNotNullExpressionValue((Object)localeListCompat, (String)"forLanguageTags(\n       \u2026t\n            )\n        )");
        return localeListCompat;
    }

    public final boolean checkApkExist(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            return false;
        }
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(packageName, 8192);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"context.packageManager\n \u2026ACKAGES\n                )");
            ApplicationInfo info = applicationInfo;
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public final boolean isNavigationBarShown(@NotNull Activity activity) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        View view = activity.findViewById(16908336);
        if (view == null) {
            return false;
        }
        View view2 = view;
        int visible = view2.getVisibility();
        switch (visible) {
            case 4: 
            case 8: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean validateMicAvailability() {
        boolean available = true;
        AudioRecord recorder = new AudioRecord(1, 44100, 16, 1, 44100);
        try {
            if (recorder.getRecordingState() != 1) {
                available = false;
            }
            recorder.startRecording();
            if (recorder.getRecordingState() != 3) {
                recorder.stop();
                available = false;
            }
            recorder.stop();
        }
        finally {
            recorder.release();
            recorder = null;
        }
        return available;
    }

    public final boolean phoneIsInUses() {
        PackageManager packageManager = MoLContentProvider.Companion.getMApplicationContext().getPackageManager();
        if (!packageManager.hasSystemFeature("android.hardware.telephony")) {
            return false;
        }
        Object object = MoLContentProvider.Companion.getMApplicationContext().getSystemService("phone");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
        TelephonyManager mTelephonyManager = (TelephonyManager)object;
        int state2 = mTelephonyManager.getCallState();
        return state2 != 0;
    }

    @Nullable
    public final String getOsType() {
        String value = null;
        try {
            Class<?> cls = Class.forName("android.os.SystemProperties");
            Class[] classArray = new Class[]{String.class};
            Method getMethod = cls.getMethod("get", classArray);
            Object[] objectArray = new Object[]{"ro.tranos.type"};
            Object object = getMethod.invoke(cls, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            value = (String)object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public final boolean isHiOS() {
        String osType = this.getOsType();
        return StringsKt.equals$default((String)osType, (String)"hios", (boolean)false, (int)2, null);
    }
}

