package com.talpa.master

import android.app.Application
import android.content.ContentProvider
import android.content.ContentValues
import android.content.Context
import android.database.Cursor
import android.net.Uri
import com.blankj.utilcode.util.ToastUtils
import com.blankj.utilcode.util.Utils
import com.talpa.datareport.report.DataAnalysisHelper
import com.talpa.master.framework.RoomHelper
import com.talpa.translate.face.TranslateService
import io.reactivex.exceptions.UndeliverableException
import io.reactivex.plugins.RxJavaPlugins
import java.io.IOException
import java.net.SocketException

/**
 * created by kgxl on: 2021/4/16
 */
class MoLContentProvider : ContentProvider() {

    companion object {
        lateinit var mApplicationContext: Context

    }


    override fun onCreate(): Boolean {
        mApplicationContext = context!!
        Utils.init(context as Application)
        ToastUtils.getDefaultMaker().setNotUseSystemToast()
        errorHandle()
        TranslateService.Companion.getInstance().init(context as Application)
        RoomHelper.init(context as Application)
        //因为mol的进程初始化是在用户设置系统语言之前。 所以初始化要往后面挪动。
//        if (SharedPreferenceHelper.getBooleanValue(SharedPreferenceHelper.IS_FIRST_OPEN, true)) {
//            GlobalScope.launch(context = Dispatchers.IO) {
//                context?.getSourceLocale()
//                context?.getTargetLocale()
//            }
//        }
        DataAnalysisHelper.setDebug(BuildConfig.DEBUG)

        return true
    }

    private fun errorHandle() {
        RxJavaPlugins.setErrorHandler { e ->

            if (e is UndeliverableException) {
            }
            if ((e is IOException) || (e is SocketException)) {
                // fine, irrelevant network problem or API that throws on cancellation
            }
            if (e is InterruptedException) {
                // fine, some blocking code was interrupted by a dispose call
            }
            if ((e is NullPointerException) || (e is IllegalArgumentException)) {
                // that's likely a bug in the application
                //                Thread.currentThread().getUncaughtExceptionHandler()
                //                    .handleException(Thread.currentThread(), e);
                //                return;
            }
            if (e is IllegalStateException) {
                // that's a bug in RxJava or in a custom operator
                //                Thread.currentThread().getUncaughtExceptionHandler()
                //                    .handleException(Thread.currentThread(), e);
            }
            e.printStackTrace()
        }
    }



    override fun query(
        uri: Uri,
        projection: Array<out String>?,
        selection: String?,
        selectionArgs: Array<out String>?,
        sortOrder: String?
    ): Cursor? {
        return null
    }

    override fun getType(uri: Uri): String? {
        return null
    }

    override fun insert(uri: Uri, values: ContentValues?): Uri? {
        return null
    }

    override fun delete(uri: Uri, selection: String?, selectionArgs: Array<out String>?): Int {
        return 0
    }

    override fun update(
        uri: Uri,
        values: ContentValues?,
        selection: String?,
        selectionArgs: Array<out String>?
    ): Int {
        return 0
    }
}