package com.talpa.master.common

import android.content.Context
import android.content.res.Configuration
import android.content.res.Resources
import java.util.*

/**
 * Create by kgxl on 2021/4/2
 */
object Constant {
    const val LISTENER_TIME: Long = 20L
    const val HISTORY_LIST: String = "HISTORY_LIST"
    const val STARMARK_LIST: String = "STARMARK_LIST"
    const val HISTORY_ID: String = "HISTORY_ID"
    const val IS_STAR_MARK: String = "IS_STAR_MARK"

    // 正在听
    val listeningMap by lazy {
        hashMapOf<String, String>()
    }

    // 可能无法理解您所说的话,单击重试或重新开始录制。
    val errorMap by lazy {
        hashMapOf<String, String>()
    }

    // 正在翻译...
    val TranslatingMap by lazy {
        hashMapOf<String, String>()
    }

    // 没有听清你说的话，点击录音重新开始。
    val SpeechRecognitionMap by lazy {
        hashMapOf<String, String>()
    }

    // 翻译
    val TranslatMap by lazy {
        hashMapOf<String, String>()
    }

    // 识别服务正忙
    val RecognitionBusyMap by lazy {
        hashMapOf<String, String>()
    }

    // 没有任何语音输入，点击录音重新开始。
    val SpeechNoPutMap by lazy {
        hashMapOf<String, String>()
    }

    // 识别中
    val RecognizingMap by lazy {
        hashMapOf<String, String>()
    }

    // 输入文本
    val entenTextMap by lazy {
        hashMapOf<String, String>()
    }

    // 请稍后再试
    val textTranslatErrorMap by lazy {
        hashMapOf<String, String>()
    }


    // 欢迎使用语言大师，点击上方按钮切换语种。
    //Welcome to MOL, click to button above to switch languages.
    val guide_tip1 by lazy {
        hashMapOf<String, String>()
    }

    // 点击底部按钮开始说话。
    //Press the button below to speak.
    val guide_tip2 by lazy {
        hashMapOf<String, String>()
    }
}

fun HashMap<String, String>.getString(context: Context,
    languageCode: String?,
    defaultValue: String = "",
    defaultLanguageCode: String = "en"
): String {
    var txt: String?
    if (null == languageCode) {
        txt = this[Locale.getDefault().language]
        if (txt.isNullOrEmpty()) {
            txt = this[defaultLanguageCode] ?: defaultValue
        }
        return txt
    }
    txt = this[languageCode]
    if (txt.isNullOrEmpty()) {
        if ("fil" == languageCode) {
            txt = this["tl"]
        }
    }

    if (txt.isNullOrEmpty()) {
        txt = this[defaultLanguageCode] ?: defaultValue
    }
    return txt
}



private fun Context.getResource(targetLocal: Locale): Resources {
    val context = this
    val config = Configuration().apply {
        setLocale(targetLocal)
    }
    val ctxNew = context.createConfigurationContext(config)
    return ctxNew.resources
}

fun Int.getString(
    context: Context?,
    languageCode: String?,
    defaultValue: String = "",
    defaultLanguageCode: String = "en",
    formatString:String? = null
): String {
    if (null == context){
        return defaultValue
    }
    var code = languageCode ?: Locale.getDefault().toLanguageTag()
    if ("fil" == code) {
        code = "tl"
    }
    try {
        var txt: String
        txt = if (formatString.isNullOrEmpty()) {
            context.getResource(Locale(code)).getString(this)
        } else {
            context.getResource(Locale(code)).getString(this, formatString)
        }

        if (txt.isEmpty()) {
            txt = if (formatString.isNullOrEmpty()) {
                context.getResource(Locale(defaultLanguageCode)).getString(this)
            } else {
                context.getResource(Locale(defaultLanguageCode)).getString(this, formatString)
            }
        }
        return txt
    } catch (e:Exception) {
        e.printStackTrace()
    }
    return defaultValue
}