package com.talpa.master.common

import android.Manifest.permission.VIBRATE
import android.content.Context
import android.os.Vibrator
import androidx.annotation.RequiresPermission
import com.talpa.master.MoLContentProvider


/**
 * created by kgxl on: 2021/4/28
 */
class VibrateUtils private constructor() {
    companion object {
        private var vibrator: Vibrator? =  MoLContentProvider.mApplicationContext.getSystemService(Context.VIBRATOR_SERVICE) as Vibrator

        @RequiresPermission(VIBRATE)
        fun vibrate(milliseconds: Long) {
            val vibrator = vibrator ?: return
            vibrator.vibrate(milliseconds)
        }

        @RequiresPermission(VIBRATE)
        fun vibrate(pattern: LongArray?, repeat: Int) {
            val vibrator = vibrator ?: return
            vibrator.vibrate(pattern, repeat)
        }

        @RequiresPermission(VIBRATE)
        fun cancel() {
            val vibrator = vibrator ?: return
            vibrator.cancel()
        }
    }

    init {
        throw UnsupportedOperationException("u can't instantiate me...")
    }
}