package com.talpa.master.databinding

import android.app.Activity
import android.content.Context
import android.content.pm.ActivityInfo
import android.content.res.Configuration
import android.os.Bundle
import android.view.View
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import com.gyf.immersionbar.ktx.immersionBar
import com.talpa.master.R
import com.talpa.master.utils.AppUtil
import com.talpa.translate.framework.BaseActivity


/**
 *
 * @author CY 2018/11/30
 */
abstract class DataBindingActivity<VDB : ViewDataBinding> : BaseActivity() {

    abstract fun getContentView(): Int

    open fun skipTheme() = false
    open fun skipOrientation() = false

    val mBinding: VDB by lazy {
        DataBindingUtil.setContentView<VDB>(this, getContentView())
    }

    override fun onCreate(savedInstanceState: Bundle?) {

        if (!skipTheme()) {
            if (AppUtil.isHiOS()) {
                this.setTheme(R.style.Theme_Translate)
            } else {
                this.setTheme(R.style.XOSTheme_Translate)
            }
        }
        super.onCreate(savedInstanceState)
        mBinding.lifecycleOwner = this


        initView()
        init()
        setDarkMode(getStatusBarColorResId(), getNavigationBarColorResId(), isDarkFont())
        // 状态栏
//        StatusBarUtil.setColor(this, getResources().getColor(R.color.background_base))
//        StatusBarUtil.setTransparent(this)
//        StatusBarUtil.setTranslucentForImageViewInFragment(this, 0, null)
//        StatusBarUtil.setLightMode(this)

//        setAndroidNativeLightStatusBar(this, getDarkModeStatus(this))

        if (!skipOrientation()) {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT)
        }

    }

    open fun getStatusBarColorResId() = R.color.mol_face_page_bg
    open fun getNavigationBarColorResId() = R.color.mol_face_page_bg
    open fun isDarkFont() = this.isDarkFontDefault()

    private fun setAndroidNativeLightStatusBar(activity: Activity, dark: Boolean) {
        val decor: View = activity.window.decorView
        if (dark) { //暗黑 设置状态栏为白色
            decor.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN or View.SYSTEM_UI_FLAG_LAYOUT_STABLE)
        } else { //设置状态栏为黑色
            decor.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR)
        }
    }

    open fun getDarkModeStatus(context: Context): Boolean {
        val mode = context.resources.configuration.uiMode and Configuration.UI_MODE_NIGHT_MASK
        return mode == Configuration.UI_MODE_NIGHT_NO
    }

    override fun onRestart() {
        super.onRestart()

        println("onRestart=================")
    }

    override fun onResume() {
        super.onResume()

    }

    override fun onWindowFocusChanged(hasFocus: Boolean) {
        super.onWindowFocusChanged(hasFocus)
        molServiceEnable()
    }

    abstract fun initView()

    abstract fun init()

    /**
     * 配置，防止文字大小跟随系统
     */
    override fun attachBaseContext(newBase: Context?) {
        val config = newBase?.resources?.configuration
        config?.fontScale = 1f
        super.attachBaseContext(newBase)
    }


    /**
     * 状态栏高度
     */
    fun Context.statusBarHeight(): Int {
        val id = resources.getIdentifier("status_bar_height", "dimen", "android")
        return resources.getDimension(id).toInt()
    }

    /**
     * MOL开关是否打开
     */
    fun molServiceEnable() {
//        val MOL_SERVICE_ENABLE = "mol_service_enable"
//        val enable: String? = Settings.Global.getString(contentResolver, MOL_SERVICE_ENABLE)
//        if (!enable.isNullOrEmpty()) {
//            if ("true" == enable) {
//                //开启状态
//            } else {
//                //关闭状态
//                val intent = Intent()
//                intent.action = "com.transsion.mol.SETTING_MAIN"
//                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
//                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK)
//                this.startActivity(intent)
//                this.finish()
//            }
//        }
    }
}

fun Activity.setDarkMode(colorResIdStatus: Int, colorResIdNavigation:Int, isDarkFont:Boolean = !isDarkFontDefault()) {
    immersionBar {
        fitsSystemWindows(true)
        statusBarDarkFont(isDarkFont)
        statusBarColor(colorResIdStatus)
        navigationBarDarkIcon(isDarkFont)
        navigationBarColor(colorResIdNavigation)
    }
}

fun Activity.isDarkFontDefault():Boolean {
    val currentNightMode = resources.configuration.uiMode and Configuration.UI_MODE_NIGHT_MASK
    return currentNightMode == Configuration.UI_MODE_NIGHT_NO
}