package com.talpa.translate.framework

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Context
import android.content.pm.PackageManager
import android.os.Build
import android.os.Bundle
import android.os.PersistableBundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat


/**
 * Activity 基类
 * @author CY 2018/11/30
 */
@SuppressLint("Registered")
open class BaseActivity : AppCompatActivity() {


    override fun onCreate(savedInstanceState: Bundle?, persistentState: PersistableBundle?) {
        super.onCreate(savedInstanceState, persistentState)
        // 设置背景颜色
        window.setBackgroundDrawableResource(getResources().getColor(com.talpa.master.R.color.background_base))
    }


    /**
     * 配置，防止文字大小跟随系统
     */
    override fun attachBaseContext(newBase: Context?) {
        val config = newBase?.resources?.configuration
        config?.fontScale = 1f
        super.attachBaseContext(newBase)
    }

}


/**
 * 状态栏样式改变
 */
fun Activity.lightStatusBar(light: Boolean) {

    val flag = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
        if (light) View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN or
                View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR
        else View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
    } else {
        View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
    }

    window.decorView.systemUiVisibility = flag
}



/**
 * 权限扩展
 */
fun Activity.checkPermission(permission: String) =
    ActivityCompat.checkSelfPermission(this, permission) == PackageManager.PERMISSION_GRANTED

