package com.talpa.master.framework

import android.app.Application
import androidx.room.Room
import androidx.room.migration.Migration
import androidx.sqlite.db.SupportSQLiteDatabase
import com.talpa.master.repository.AppDatabase


/**
 * Create by kgxl on 2021/4/2
 */
object RoomHelper {

    private lateinit var mApplication: Application
    private val migration1_2 = object : Migration(1, 2) {
        override fun migrate(database: SupportSQLiteDatabase) {
        }
    }
    private val migration2_3 = object : Migration(2, 3) {
        override fun migrate(database: SupportSQLiteDatabase) {
            val sql = "ALTER TABLE `history` ADD COLUMN `_pid` INTEGER NOT NULL DEFAULT 0"
            database.execSQL(sql)
        }
    }

    private val appDatabase by lazy {
        Room.databaseBuilder(
            mApplication,
            AppDatabase::class.java,
            "master"
        )
            .fallbackToDestructiveMigration()
            .addMigrations(migration1_2, migration2_3)
            .build()

    }

    val historyDao by lazy { appDatabase.historyDao() }

    fun init(application: Application) {
        mApplication = application
    }


}