package com.talpa.master.repository

//import com.cy.sts.common.Logcat

import android.Manifest
import android.content.Context
import android.content.pm.PackageManager
import android.os.Build
import android.preference.PreferenceManager
import android.telephony.TelephonyManager
import android.text.TextUtils
import android.util.Log
import androidx.core.app.ActivityCompat
import androidx.core.os.ConfigurationCompat
import com.talpa.master.repository.Preferences.Companion.KEY_LANGUAGE_SOURCE
import com.talpa.master.repository.Preferences.Companion.KEY_LANGUAGE_TARGET
import com.talpa.translate.face.common.Constants

import java.util.*


class Preferences {
    companion object {
        const val PERMISSION_MIC_SETUP = "MKF_startup"//麦克风权限启动
        const val PERMISSION_MIC_SWITCH = "MKF_switch"//麦克风权限开关 开，记录一次，关，记录一次
        const val PERMISSION_NOTIFY_SETUP = "PUSH_startup"//通知栏权限启动 调起权限，记录一次
        const val PERMISSION_NOTIFY_SWITCH = "push_switch"//通知栏权限开关 开，记录一次，关，记录一次
        const val PERMISSION_VIBRATION = "shake_startup"//震动开关 开，记录一次，关，记录一次
        const val RECORDING_COUNT =
            "voice_recording_usage_count"//语音录制使用次数 当用户按住（超过1秒）说话，记录一次，点击一次不计算
        const val TRANSLATION_USAGE_COUNT = "translation_usage_count"//翻译接口使用次数
        const val TRANSLATION_RESULT = "translation_result"//当用户翻译结果成功，呈现翻译内容，记录次数
        const val BUTTON_SOUND = "sound_button"//声音播放键,默认打开，当用户点击声音按钮，记录次数
        const val BUTTON_COPY = "copy_button"//复制按钮，当用户点击声音按钮，记录次数
        const val BUTTON_EDIT = "edit_button"//编辑按钮，当用户点击声音按钮，记录次数
        const val BUTTON_ROTATING = "rotating_font"//旋转字体按钮，当用户点击声音按钮，记录次数
        const val TB_001 = "TB_001"//网络异常报错,使用翻译过程中，发生网络异常事件记录次数
        const val TB_002 = "TB_002"//无网络 事件发生，记录一次
        const val TB_003 = "TB_003"//听不清楚 事件发生，记录一次
        const val SPEECH_TO_TEXT = "SPEECH_TO_TEXT"
        const val TRANSLATE = "TRANSLATE"

        const val KEY_LANGUAGE_SOURCE = "sourceLocaleKey"
        const val KEY_LANGUAGE_TARGET = "targetLocaleKey"
    }
}

fun Context.getDefaultLanguage():Locale? {
    ConfigurationCompat.getLocales(resources.configuration).apply {
        if (size() > 0) {
            return get(0)
        }
    }
    return null
}

fun Context.initLanguage() {
    PreferenceManager
        .getDefaultSharedPreferences(applicationContext).apply {
            if (!contains(KEY_LANGUAGE_SOURCE) || !contains(KEY_LANGUAGE_TARGET)) {
//            *「源语⾔」⾸次进⼊默认为英⽂，⾮⾸次默认为前
//            ⼀次的选择；「⽬标语⾔」⾸次默认为⽤户的系统语
//            ⾔，⾮⾸次默认为前⼀次的选择（如果⽤户的系统语
//            ⾔为英⽂，则默认选中为语⾔列表排序中英⽂下⼀个
//            et）
                val defaultSourceLanguage = Locale.ENGLISH.language
//                var defaultTargetLanguage = Locale.getDefault().language
                val current: Locale = getDefaultLanguage() ?: Locale.getDefault()
                var defaultTargetLanguage = current.language
//                defaultTargetLanguage =  current.language
                Log.i("Hi-Face-to-Face", "defaultSourceLanguage:$defaultSourceLanguage" +
                        ", defaultTargetLanguage:$defaultTargetLanguage" +
                        ", Locale.getDefault().language:${Locale.getDefault().language}" +
                        ", ConfigurationCompat.getLocales(resources.configuration).get(0):${getDefaultLanguage()?.language}")

                if (defaultTargetLanguage == "ckb"){
                    defaultTargetLanguage = "ku"
                }
                if (defaultTargetLanguage == "fil"){
                    defaultTargetLanguage = "tl"
                }

                if (!Constants.supportLanguages.contains(defaultTargetLanguage)) {
                    defaultTargetLanguage = "et"
                }
                if (defaultTargetLanguage == defaultSourceLanguage) {
                    defaultTargetLanguage = "et"
                }

                edit().putString(KEY_LANGUAGE_SOURCE, defaultSourceLanguage)
                    .putString(KEY_LANGUAGE_TARGET, defaultTargetLanguage)
                    .apply()
            }
        }
}

/**
 * 获取源地区
 *
 */
fun Context.getSourceLocale(): Locale {
    var languageTag = PreferenceManager
        .getDefaultSharedPreferences(applicationContext)
        .getString(KEY_LANGUAGE_SOURCE, null)
    if (languageTag.isNullOrEmpty()) {
        initLanguage()
        languageTag = PreferenceManager
            .getDefaultSharedPreferences(applicationContext)
            .getString(KEY_LANGUAGE_SOURCE, null)
    }
    val locale =
        languageTag?.let { Locale.forLanguageTag(languageTag) } ?: Locale.forLanguageTag("en")
    saveSourceLocale(languageTag = locale.language)
    return locale
}


/**
 * 保存源地区
 * @param languageTag
 */
fun Context.saveSourceLocale(languageTag: String) {

    val editor = PreferenceManager
        .getDefaultSharedPreferences(applicationContext)
        .edit()
    editor.putString(KEY_LANGUAGE_SOURCE, languageTag)
    editor.apply()

}

/**
 * 获取目标地区
 */
fun Context.getTargetLocale(defaultLanguageTag: String = "en"): Locale {
    val languageTag = PreferenceManager
        .getDefaultSharedPreferences(applicationContext)
        .getString(KEY_LANGUAGE_TARGET, null)

    return languageTag?.let { Locale.forLanguageTag(languageTag) }?:Locale.forLanguageTag(defaultLanguageTag)
}

/**
 * 保存目标地区
 * @param languageTag
 */
fun Context.saveTargetLocale(languageTag: String) {
    val editor = PreferenceManager
        .getDefaultSharedPreferences(applicationContext)
        .edit()
    editor.putString(KEY_LANGUAGE_TARGET, languageTag)
    editor.apply()
}


/**
 * 是否第一次进入主界面
 */
fun isFirstToMain(context: Context): Boolean {

    val preference = PreferenceManager
        .getDefaultSharedPreferences(context)
    val isFirstToMain = preference
        .getBoolean("key_is_first_to_main", true)

    if (isFirstToMain) {
        val editor = preference.edit()
        editor.putBoolean("key_is_first_to_main", !isFirstToMain)
        editor.apply()
    }


    return isFirstToMain
}

/**
 * 是否第一次进入主界面
 */
fun isFirstEnterApp(context: Context): Boolean {

    val preference = PreferenceManager
        .getDefaultSharedPreferences(context)
    val isFirstEnterApp = preference
        .getBoolean("key_is_first_enter_app", true)

    if (isFirstEnterApp) {
        val editor = preference.edit()
        editor.putBoolean("key_is_first_enter_app", !isFirstEnterApp)
        editor.apply()
    }

    return isFirstEnterApp

}

/**
 * 是否应该显示引导
 */
fun shouldShowGuide(context: Context): Boolean {
    val preference = PreferenceManager
        .getDefaultSharedPreferences(context)
    return preference
        .getBoolean("key_should_show_guide", true)
}

/**
 * 保存隐藏引导
 */
fun saveHideGuide(context: Context) {
    val preference = PreferenceManager
        .getDefaultSharedPreferences(context)
    preference.edit().putBoolean("key_should_show_guide", false).apply()
}

/**
 * 读取IMEI
 */
@Deprecated(message = "杜绝使用此方法", level = DeprecationLevel.ERROR)
fun readIMEI(context: Context): String? {

    val preference = PreferenceManager
        .getDefaultSharedPreferences(context)
    var imei = preference.getString(KEY_IMEI, null)

    if (TextUtils.isEmpty(imei)) {
        val granted =
            ActivityCompat.checkSelfPermission(context, Manifest.permission.READ_PHONE_STATE)
        if (granted == PackageManager.PERMISSION_GRANTED) {
            val tm = context.getSystemService(Context.TELEPHONY_SERVICE) as TelephonyManager
            imei = if (Build.VERSION.SDK_INT > Build.VERSION_CODES.O) tm.imei else tm.deviceId
            preference.edit().putString(KEY_IMEI, imei).apply()
        }

    }

    return imei
}


private const val KEY_IMEI = "key_imei"