package com.talpa.master.repository.room.dao

import android.os.Process
import androidx.room.*
import com.talpa.master.repository.room.model.History
import com.talpa.master.ui.main.v2.GuideUtil
import io.reactivex.Flowable

@Dao
interface HistoryDao {

//    @Query("SELECT * FROM history ORDER BY mills DESC")
//    fun queryHistorys(): DataSource.Factory<Int, History>

    @Query("DELETE FROM history WHERE start_marker = :isStartMarker AND _pid != :pid AND _pid != :leftGuidePid AND _pid != :GuidePid ")
    fun clearHistory(
        isStartMarker: Boolean = false,
        pid: Int = Process.myPid(),
        leftGuidePid: Int = GuideUtil.LEFT_GUIDE_PID,
        GuidePid: Int = GuideUtil.RIGHT_GUIDE_PID
    )

    @Query("SELECT * FROM history WHERE id = :id")
    fun queryHistory(id: String): History?

    @Query("SELECT COUNT(*) FROM history")
    fun queryHistorySize(): Flowable<Int>

    @Query("SELECT * FROM history ORDER BY mills DESC LIMIT 1")
    fun queryLastHistory(): History

    @Query("SELECT * FROM history WHERE start_marker=1 ORDER BY end_mills DESC")
    fun queryAllHistoryByMark(): Flowable<MutableList<History>>

    @Query("SELECT * FROM history ORDER BY mills DESC LIMIT 30")
    fun queryLatestHistory(): Flowable<MutableList<History>>

    @Query("SELECT * FROM history WHERE _pid=:pid ORDER BY mills DESC LIMIT 30")
    fun queryLatestHistoryByPid(pid: Int = Process.myPid()): Flowable<MutableList<History>>

    @Query("SELECT * FROM history WHERE _pid=:pid LIMIT 1")
    fun queryGuideByPid(pid: Int = Process.myPid()): History?

    @Query("SELECT * FROM history")
    fun all(): Flowable<MutableList<History>>

    @Insert(onConflict = OnConflictStrategy.ABORT)
    fun insertHistory(historys: List<History>)

    @Insert
    fun insert(history: History)

    @Update(onConflict = OnConflictStrategy.REPLACE)
    fun updateStarModel(history: History)

    @Delete
    fun deleteHistory(history: History)
}