package com.talpa.master.repository.room.model

import android.os.Process
import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Ignore
import androidx.room.PrimaryKey


@Entity(tableName = "history")
data class History(
    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "id")  //每条数据的唯一标识
    var id: Int = 0,

    @ColumnInfo(name = "source_result")  //源语言内容
    var source_result: String = "",

    @ColumnInfo(name = "target_result")  //目标语言内容
    var target_result: String = "",

    @ColumnInfo(name = "display_type")  //显示类型  0源 背景色 绿色 1目标 背景色 蓝色
    var display_type: Int,


    @ColumnInfo(name = "mills")  //时间戳
    var mills: Long,

    @ColumnInfo(name = "end_mills")  //星标最后点击时间
    var end_mills: Long,


    @ColumnInfo(name = "sourcelanguage_tag")  //源语言tag
    var sourcelanguage_tag: String = "",

    @ColumnInfo(name = "sourcelanguage_name")  //源语言名字
    var sourcelanguage_name: String = "",

    @ColumnInfo(name = "targetlanguage_tag")  //目标语言tag
    var targetlanguage_tag: String = "",

    @ColumnInfo(name = "targetlanguage_name")  //目标语言name
    var targetlanguage_name: String = "",

    @ColumnInfo(name = "start_marker")
    var isStartMarker: Boolean = false,  // 是否是星标

    @ColumnInfo(name = "voice_play")
    var isVoicePlay: Boolean = false,  // 是否能播报

    @ColumnInfo(name = "_pid")
    var pid: Int = Process.myPid(),  // 进程pid

)