package com.talpa.master.repository.room.model

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey

/**
 * 语言列表数据模型
 */
class LanguageModel: BaseModel<LanguageModel.Data>() {
    data class Data(
        var resource: String,//: "google",
        var languages: List<LanguageList>
    )

    @Entity(tableName = "languageList")
    data class LanguageList(
        @PrimaryKey
        @ColumnInfo(name = "key")  //语言Tag  Locale.toLanguageTag() 获得  相关API Locale.forLanguageTag()  Locale.toLanguageTag()
        var key: String = "",// "en",

        @ColumnInfo(name = "name")
        var name: String = "",//, "English"

        @ColumnInfo(name = "resource")
        var resource: String = "", // "google"

        @ColumnInfo(name = "recently_time")
        var recentlyTime: Long = 0L,//最近使用时间

        @ColumnInfo(name = "flag_asset")
        var flag_asset: String = "",//国旗，对应assets/flag/...

        @ColumnInfo(name = "name_ch")
        var name_ch: String = "",//中文名称

        @ColumnInfo(name = "name_en")
        var name_en: String = "",//英文名称

        /**
         * 是否是已经选中
         */
        @ColumnInfo(name = "selected")
        var isSelected: Boolean = false,

        /**
         * 翻译类型，判定当前选中的翻译语言需要根据translateType，isSelected一起决定
         * 1，表示源语言，2，表示目标语言
         */
        @ColumnInfo(name = "languageType")
        var languageType: Int = 0

    )
}