package com.talpa.master.translate.lang

import java.lang.StringBuilder
import java.util.*

/**
 *  Translate Lang
 *  @author CY 2019-01-13
 */
enum class LANG {

    /********Translate Language Start ***********/

    AUTO, // 自动检测语种


    CEB,//宿务语  ceb (ISO-639-2)
    CO,//科西嘉语  co
    HT,//海地克里奥尔语  ht
//    HE,//希伯来语  he**
    HMN,//苗语  hmn (ISO-639-2)
    JW,//爪哇语  jw
    LA,//拉丁语  la
    MI,//毛利语  mi
    //NO,//挪威语  no
    NY,//尼杨扎语（齐切瓦语）  ny
    SM,//萨摩亚语  sm
    ST,//塞索托语  st
    SD,//信德语  sd
    SU,//巽他语  su
    YI,//意第绪语  yi
    //ID,//印度尼西亚语

    //https://cloud.google.com/translate/docs/languages
    /********Google Translate Language enD ***********/

    /********Microsoft ********************/
    FJ,//斐济 fj
    OTQ,//克雷塔罗奥托米语 otq
    TLH,//克林贡语 tlh
    TY,//塔希提语 ty
    YUA,//尤卡坦玛雅语 yua
    FILH,//克林贡语


    /*Android Locale Language list Start*/
    SBP,//桑古语
    KSH,//科隆语
    NYN,//尼昂科勒语
    PS,//普什图语
    pt,//葡萄牙语
    LUO,//卢欧语
    FIL,//菲律宾语
    MGH,//马库阿语
    CCP,//ccp
    LUY,//卢雅语
    MGO,//梅塔语
    BAS,//巴萨语
    TEO,//特索语
    QU,//克丘亚语
    af,//南非荷兰语
    BRX,//博多语
    AK,//阿肯语
    am,//阿姆哈拉语
    KDE,//马孔德语
    ar,//阿拉伯语
    AS,//阿萨姆语
    AZ,//阿塞拜疆语
    RM,//罗曼什语
    RN,//隆迪语
    RO,//罗马尼亚语
    BE,//白俄罗斯语
    RU,//俄语
    BG,//保加利亚语
    RW,//卢旺达语
    KEA,//卡布佛得鲁语
    BM,//班巴拉语
    bn,//孟加拉语
    BO,//藏语
    TWQ,//北桑海语
    BR,//布列塔尼语
    BS,//波斯尼亚语
    XOG,//索加语
    SE,//北方萨米语
    SG,//桑戈语
    SI,//僧伽罗语
    SEH,//塞纳语
    SK,//斯洛伐克语
    SL,//斯洛文尼亚语
    SN,//绍纳语
    SO,//索马里语
    CA,//加泰罗尼亚语
    SQ,//阿尔巴尼亚语
    SR,//塞尔维亚语
    mzn,//马赞德兰语
    ses,//东桑海语
    ce,//车臣语
    SV,//瑞典语
    sw,//斯瓦希里语
    TA,//泰米尔语
    ASA,//帕雷语
    YAV,//洋卞语
    CS,//捷克语
    TE,//泰卢固语
    TG,//塔吉克语
    th,//泰语
    TI,//提格利尼亚语
    CY,//威尔士语
    TK,//土库曼语
    DYO,//朱拉语
    TO,//汤加语
    DA,//丹麦语
    TR,//土耳其语
    TT,//鞑靼语
    DE,//德语
    CGG,//奇加语
    AST,//阿斯图里亚斯语
    NMG,//夸西奥语
    BEM,//本巴语
    UG,//维吾尔语
    BEZ,//贝纳语
    DZ,//宗卡语
    UK,//乌克兰语
    UR,//乌尔都语
    DJE,//哲尔马语
    HAW,//夏威夷语
    EE,//埃维语
    UZ,//乌兹别克语
    TZM,//塔马齐格特语
    EL,//希腊语
    en,//英语
    NNH,//恩甘澎语
    EO,//世界语
    CHR,//切罗基语
    es,//西班牙语
    ET,//爱沙尼亚语
    EU,//巴斯克语
    VI,//越南语
    KHQ,//西桑海语
    SHI,//希尔哈语
    HSB,//上索布语
    FA,//波斯语
    FF,//富拉语
    FI,//芬兰语
    RWK,//罗瓦语
    YUE,//粤语
    FO,//法罗语
    fr,//法语
    FY,//西弗里西亚语
    JGO,//恩艮巴语
    LKT,//拉科塔语
    WO,//沃洛夫语
    GA,//爱尔兰语
    WAE,//瓦尔瑟语
    ZGH,//标准摩洛哥塔马塞特语
    GD,//苏格兰盖尔语
    GL,//加利西亚语
    GU,//古吉拉特语
    GV,//马恩语
    XH,//科萨语
    HA,//豪萨语
    KU,//库尔德语
    hi,//印地语
    AGQ,//亚罕语
    GSW,//瑞士德语
    HR,//克罗地亚语
    KKJ,//卡库语
    HU,//匈牙利语
    HY,//亚美尼亚语
    YO,//约鲁巴语
    IG,//伊博语
    NAQ,//纳马语
    VAI,//瓦伊语
    II,//四川彝语
    IN,//印度尼西亚语
    IS,//冰岛语
    IT,//意大利语
    KLN,//卡伦金语
    IW,//希伯来语
    //ZH,//中文
    zh,//中文（简体）  zh-CN (BCP-47)
    ZH_TW,//中文（繁体）  zh-TW (BCP-47)
    ja,//日语
    ZU,//祖鲁语
    JI,//意第绪语
    GUZ,//古西语
    SMN,//伊纳里萨米语
    KA,//格鲁吉亚语
    KI,//吉库尤语
    MAS,//马赛语
    KK,//哈萨克语
    KL,//格陵兰语
    KM,//高棉语
    KN,//卡纳达语
    ko,//韩语
    KS,//克什米尔语
    KW,//康沃尔语
    KY,//柯尔克孜语
    LB,//卢森堡语
    EBU,//恩布语
    LG,//卢干达语
    NDS,//低地德语
    JMC,//马切姆语
    FUR,//弗留利语
    LN,//林加拉语
    LO,//老挝语
    KOK,//孔卡尼语
    LT,//立陶宛语
    LU,//鲁巴加丹加语
    LV,//拉脱维亚语
    NUS,//努埃尔语
    VUN,//温旧语
    LAG,//朗吉语
    DAV,//台塔语
    MG,//马拉加斯语
    LRC,//北卢尔语
    MK,//马其顿语
    ML,//马拉雅拉姆语
    MN,//蒙古语
    MR,//马拉地语
    MS,//马来语
    MT,//马耳他语
    MY,//缅甸语
    DSB,//下索布语
    NB,//书面挪威语
    ND,//北恩德贝勒语
    NE,//尼泊尔语
    MUA,//蒙当语
    NL,//荷兰语
    NN,//挪威尼诺斯克语
    ROF,//兰博语
    KAB,//卡拜尔语
    KAM,//卡姆巴语
    MER,//梅鲁语
    SAH,//萨哈语
    OM,//奥罗莫语
    SAQ,//桑布鲁语
    OR,//奥里亚语
    OS,//奥塞梯语
    MFE,//毛里求斯克里奥尔语
    DUA,//都阿拉语
    PA,//旁遮普语
    KSB,//香巴拉语
    EWO,//旺杜语
    PL,//波兰语
    KSF,//巴菲亚语

    /*Android Locale Language list end*/
}




//
///**
// * 支持翻译的语言
// */
//val supportLanguage = hashMapOf<Locale, LANG>().apply {
//this[Locale.forLanguageTag("en-ZW")] = LANG.en
//this[Locale.forLanguageTag("hi-IN")] = LANG.HI
//this[Locale.forLanguageTag("bn-IN")] = LANG.BN
//this[Locale.forLanguageTag("kn-IN")] = LANG.KN
//this[Locale.forLanguageTag("ur-PK")] = LANG.UR
//this[Locale.forLanguageTag("mr-IN")] = LANG.MR
//this[Locale.forLanguageTag("ar-YE")] = LANG.ar
//this[Locale.forLanguageTag("gu-IN")] = LANG.GU
//this[Locale.forLanguageTag("ta-SG")] = LANG.TA
//this[Locale.forLanguageTag("pa-Guru-IN")] = LANG.PA
//this[Locale.forLanguageTag("ml-IN")] = LANG.ML
//this[Locale.forLanguageTag("te-IN")] = LANG.TE
//this[Locale.forLanguageTag("ne-NP")] = LANG.NE
//this[Locale.forLanguageTag("fr-YT")] = LANG.FR
//this[Locale.forLanguageTag("es-VE")] = LANG.es
//this[Locale.forLanguageTag("pt-TL")] = LANG.pt
//this[Locale.forLanguageTag("ru-UA")] = LANG.RU
//this[Locale.forLanguageTag("zh-Hans-CN")] = LANG.zh_cn
//this[Locale.forLanguageTag("de-LU")] = LANG.DE
//this[Locale.forLanguageTag("ha-NG")] = LANG.HA
//this[Locale.forLanguageTag("ja-JP")] = LANG.ja
//this[Locale.forLanguageTag("ms-SG")] = LANG.MS
//this[Locale.forLanguageTag("sw-UG")] = LANG.sw
//this[Locale.forLanguageTag("jw")] = LANG.JW
//this[Locale.forLanguageTag("th-TH")] = LANG.th
//this[Locale.forLanguageTag("id-ID")] = LANG.IN
//this[Locale.forLanguageTag("tr-TR")] = LANG.TR
//this[Locale.forLanguageTag("fa-IR")] = LANG.FA
//this[Locale.forLanguageTag("en-PH")] = LANG.en
//this[Locale.forLanguageTag("vi-VN")] = LANG.VI
//this[Locale.forLanguageTag("ko-KR")] = LANG.KO
//this[Locale.forLanguageTag("it-VA")] = LANG.IT
//this[Locale.forLanguageTag("it-VA")] = LANG.IT
//this[Locale.forLanguageTag("am-ET")] = LANG.am
//this[Locale.forLanguageTag("cs-CZ")] = LANG.CS
//this[Locale.forLanguageTag("hr-HR")] = LANG.HR
//this[Locale.forLanguageTag("sv-SE")] = LANG.SV
//this[Locale.forLanguageTag("nl-SX")] = LANG.NL
//this[Locale.forLanguageTag("el-GR")] = LANG.EL
//this[Locale.forLanguageTag("ro-RO")] = LANG.RO
//this[Locale.forLanguageTag("pl-PL")] = LANG.PL
//this[Locale.forLanguageTag("fi-FI")] = LANG.FI
//this[Locale.forLanguageTag("hu-HU")] = LANG.HU
//this[Locale.forLanguageTag("he-IL")] = LANG.IW
//this[Locale.forLanguageTag("kk-KZ")] = LANG.KK
//this[Locale.forLanguageTag("km-KH")] = LANG.KM
//this[Locale.forLanguageTag("ky-KG")] = LANG.KY
//this[Locale.forLanguageTag("my-MM")] = LANG.MY
//this[Locale.forLanguageTag("nb-NO")] = LANG.NB
//this[Locale.forLanguageTag("ps-AF")] = LANG.PS
//this[Locale.forLanguageTag("si-LK")] = LANG.SI
//this[Locale.forLanguageTag("so-SO")] = LANG.SO
//this[Locale.forLanguageTag("sq-XK")] = LANG.SQ
//this[Locale.forLanguageTag("uk-UA")] = LANG.UK
//this[Locale.forLanguageTag("bg-BG")] = LANG.BG
//this[Locale.forLanguageTag("yo-NG")] = LANG.YO
//this[Locale.forLanguageTag("da-GL")] = LANG.DA
//this[Locale.forLanguageTag("is-IS")] = LANG.IS
//}




/* 微软支持的语音
val json = """
    {
  "translation": {
    "af": {
      "name": "南非荷兰语",
      "nativename": "Afrikaans",
      "dir": "ltr"
    },
    "ar": {
      "name": "阿拉伯语",
      "nativename": "العربية",
      "dir": "rtl"
    },
    "bg": {
      "name": "保加利亚语",
      "nativename": "Български",
      "dir": "ltr"
    },
    "bn": {
      "name": "孟加拉语",
      "nativename": "বাংলা",
      "dir": "ltr"
    },
    "bs": {
      "name": "波斯尼亚语",
      "nativename": "bosanski (latinica)",
      "dir": "ltr"
    },
    "ca": {
      "name": "加泰隆语",
      "nativename": "Català",
      "dir": "ltr"
    },
    "cs": {
      "name": "捷克语",
      "nativename": "Čeština",
      "dir": "ltr"
    },
    "cy": {
      "name": "威尔士语",
      "nativename": "Welsh",
      "dir": "ltr"
    },
    "da": {
      "name": "丹麦语",
      "nativename": "Dansk",
      "dir": "ltr"
    },
    "de": {
      "name": "德语",
      "nativename": "Deutsch",
      "dir": "ltr"
    },
    "el": {
      "name": "希腊语",
      "nativename": "Ελληνικά",
      "dir": "ltr"
    },
    "en": {
      "name": "英语",
      "nativename": "english",
      "dir": "ltr"
    },
    "es": {
      "name": "西班牙语",
      "nativename": "Español",
      "dir": "ltr"
    },
    "et": {
      "name": "爱沙尼亚语",
      "nativename": "Eesti",
      "dir": "ltr"
    },
    "fa": {
      "name": "波斯语",
      "nativename": "Persian",
      "dir": "rtl"
    },
    "fi": {
      "name": "芬兰语",
      "nativename": "Suomi",
      "dir": "ltr"
    },
    "fil": {
      "name": "菲律宾语",
      "nativename": "Filipino",
      "dir": "ltr"
    },
    "fj": {
      "name": "斐济",
      "nativename": "Fijian",
      "dir": "ltr"
    },
    "fr": {
      "name": "法语",
      "nativename": "Français",
      "dir": "ltr"
    },
    "he": {
      "name": "希伯来语",
      "nativename": "עברית",
      "dir": "rtl"
    },
    "hi": {
      "name": "印地语",
      "nativename": "हिंदी",
      "dir": "ltr"
    },
    "hr": {
      "name": "克罗地亚语",
      "nativename": "Hrvatski",
      "dir": "ltr"
    },
    "ht": {
      "name": "海地克里奥尔语",
      "nativename": "Haitian Creole",
      "dir": "ltr"
    },
    "hu": {
      "name": "匈牙利语",
      "nativename": "Magyar",
      "dir": "ltr"
    },
    "id": {
      "name": "印度尼西亚语",
      "nativename": "Indonesia",
      "dir": "ltr"
    },
    "is": {
      "name": "冰岛语",
      "nativename": "Íslenska",
      "dir": "ltr"
    },
    "it": {
      "name": "意大利语",
      "nativename": "Italiano",
      "dir": "ltr"
    },
    "ja": {
      "name": "日语",
      "nativename": "日本語",
      "dir": "ltr"
    },
    "ko": {
      "name": "朝鲜语",
      "nativename": "한국어",
      "dir": "ltr"
    },
    "lt": {
      "name": "立陶宛语",
      "nativename": "Lietuvių",
      "dir": "ltr"
    },
    "lv": {
      "name": "拉脱维亚语",
      "nativename": "Latviešu",
      "dir": "ltr"
    },
    "mg": {
      "name": "马尔加什语",
      "nativename": "Malagasy",
      "dir": "ltr"
    },
    "ms": {
      "name": "马来语",
      "nativename": "Melayu",
      "dir": "ltr"
    },
    "mt": {
      "name": "马耳他语",
      "nativename": "Il-Malti",
      "dir": "ltr"
    },
    "mww": {
      "name": "白苗文",
      "nativename": "Hmong Daw",
      "dir": "ltr"
    },
    "nb": {
      "name": "挪威语",
      "nativename": "Norsk",
      "dir": "ltr"
    },
    "nl": {
      "name": "荷兰语",
      "nativename": "Nederlands",
      "dir": "ltr"
    },
    "otq": {
      "name": "克雷塔罗奥托米语",
      "nativename": "Querétaro Otomi",
      "dir": "ltr"
    },
    "pl": {
      "name": "波兰语",
      "nativename": "Polski",
      "dir": "ltr"
    },
    "pt": {
      "name": "葡萄牙语",
      "nativename": "Português",
      "dir": "ltr"
    },
    "ro": {
      "name": "罗马尼亚语",
      "nativename": "Română",
      "dir": "ltr"
    },
    "ru": {
      "name": "俄语",
      "nativename": "Русский",
      "dir": "ltr"
    },
    "sk": {
      "name": "斯洛伐克语",
      "nativename": "Slovenčina",
      "dir": "ltr"
    },
    "sl": {
      "name": "斯洛文尼亚语",
      "nativename": "Slovenščina",
      "dir": "ltr"
    },
    "sm": {
      "name": "萨摩亚语",
      "nativename": "Samoan",
      "dir": "ltr"
    },
    "sr-Cyrl": {
      "name": "塞尔维亚语 (西里尔文)",
      "nativename": "srpski (ćirilica)",
      "dir": "ltr"
    },
    "sr-Latn": {
      "name": "塞尔维亚语 (拉丁文)",
      "nativename": "srpski (latinica)",
      "dir": "ltr"
    },
    "sv": {
      "name": "瑞典语",
      "nativename": "Svenska",
      "dir": "ltr"
    },
    "sw": {
      "name": "斯瓦希里语",
      "nativename": "Kiswahili",
      "dir": "ltr"
    },
    "ta": {
      "name": "泰米尔语",
      "nativename": "தமிழ்",
      "dir": "ltr"
    },
    "te": {
      "name": "泰卢固语",
      "nativename": "తెలుగు",
      "dir": "ltr"
    },
    "th": {
      "name": "泰语",
      "nativename": "ไทย",
      "dir": "ltr"
    },
    "tlh": {
      "name": "克林贡语",
      "nativename": "Klingon",
      "dir": "ltr"
    },
    "to": {
      "name": "汤加语",
      "nativename": "lea fakatonga",
      "dir": "ltr"
    },
    "tr": {
      "name": "土耳其语",
      "nativename": "Türkçe",
      "dir": "ltr"
    },
    "ty": {
      "name": "塔希提语",
      "nativename": "Tahitian",
      "dir": "ltr"
    },
    "uk": {
      "name": "乌克兰语",
      "nativename": "Українська",
      "dir": "ltr"
    },
    "ur": {
      "name": "乌尔都语",
      "nativename": "اردو",
      "dir": "rtl"
    },
    "vi": {
      "name": "越南语",
      "nativename": "Tiếng Việt",
      "dir": "ltr"
    },
    "yua": {
      "name": "尤卡坦玛雅语",
      "nativename": "Yucatec Maya",
      "dir": "ltr"
    },
    "yue": {
      "name": "粤语(繁体)",
      "nativename": "粵語 (繁體中文)",
      "dir": "ltr"
    },
    "zh-Hans": {
      "name": "简体中文",
      "nativename": "简体中文",
      "dir": "ltr"
    },
    "zh-Hant": {
      "name": "繁体中文",
      "nativename": "繁體中文",
      "dir": "ltr"
    }
  },
  "transliteration": {
    "ar": {
      "name": "阿拉伯语",
      "nativename": "العربية",
      "scripts": [
        {
          "code": "Arab",
          "name": "阿拉伯语",
          "nativename": "العربية",
          "dir": "rtl",
          "toScripts": [
            {
              "code": "Latn",
              "name": "Latin",
              "nativename": "اللاتينية",
              "dir": "ltr"
            }
          ]
        },
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "اللاتينية",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Arab",
              "name": "Arabic",
              "nativename": "العربية",
              "dir": "rtl"
            }
          ]
        }
      ]
    },
    "bn": {
      "name": "孟加拉语",
      "nativename": "বাংলা",
      "scripts": [
        {
          "code": "Beng",
          "name": "孟加拉语",
          "nativename": "Bengali",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Latn",
              "name": "Latin",
              "nativename": "Latin",
              "dir": "ltr"
            }
          ]
        },
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "Latin",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Beng",
              "name": "Bangla",
              "nativename": "Bengali",
              "dir": "ltr"
            }
          ]
        }
      ]
    },
    "gu": {
      "name": "古吉拉特语",
      "nativename": "ગુજરાતી",
      "scripts": [
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "Latin",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Gujr",
              "name": "Gujarati",
              "nativename": "Gujarati",
              "dir": "ltr"
            }
          ]
        }
      ]
    },
    "he": {
      "name": "希伯来语",
      "nativename": "עברית",
      "scripts": [
        {
          "code": "Hebr",
          "name": "希伯莱语",
          "nativename": "עברית",
          "dir": "rtl",
          "toScripts": [
            {
              "code": "Latn",
              "name": "Latin",
              "nativename": "לטינית",
              "dir": "ltr"
            }
          ]
        },
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "לטינית",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Hebr",
              "name": "Hebrew",
              "nativename": "עברית",
              "dir": "rtl"
            }
          ]
        }
      ]
    },
    "hi": {
      "name": "印地语",
      "nativename": "हिंदी",
      "scripts": [
        {
          "code": "Deva",
          "name": "梵文",
          "nativename": "देवनागरी",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Latn",
              "name": "Latin",
              "nativename": "लैटिन",
              "dir": "ltr"
            }
          ]
        },
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "लैटिन",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Deva",
              "name": "Devanagari",
              "nativename": "देवनागरी",
              "dir": "ltr"
            }
          ]
        }
      ]
    },
    "ja": {
      "name": "日语",
      "nativename": "日本語",
      "scripts": [
        {
          "code": "Jpan",
          "name": "日语",
          "nativename": "日本語",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Latn",
              "name": "Latin",
              "nativename": "ラテン語",
              "dir": "ltr"
            }
          ]
        },
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "ラテン語",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Jpan",
              "name": "Japanese",
              "nativename": "日本語",
              "dir": "ltr"
            }
          ]
        }
      ]
    },
    "kn": {
      "name": "卡纳拉语",
      "nativename": "ಕನ್ನಡ",
      "scripts": [
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "Latin",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Knda",
              "name": "Kannada",
              "nativename": "Kannada",
              "dir": "ltr"
            }
          ]
        }
      ]
    },
    "ml": {
      "name": "马拉雅拉姆语",
      "nativename": "മലയാളം",
      "scripts": [
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "Latin",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Mlym",
              "name": "Malayalam",
              "nativename": "Malayalam",
              "dir": "ltr"
            }
          ]
        }
      ]
    },
    "mr": {
      "name": "马拉地语",
      "nativename": "मराठी",
      "scripts": [
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "Latin",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Deva",
              "name": "Devanagari",
              "nativename": "Devanagari",
              "dir": "ltr"
            }
          ]
        }
      ]
    },
    "or": {
      "name": "奥里雅语",
      "nativename": "Oriya",
      "scripts": [
        {
          "code": "Orya",
          "name": "Oriya",
          "nativename": "Oriya",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Latn",
              "name": "Latin",
              "nativename": "Latin",
              "dir": "ltr"
            }
          ]
        },
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "Latin",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Orya",
              "name": "Oriya",
              "nativename": "Oriya",
              "dir": "ltr"
            }
          ]
        }
      ]
    },
    "pa": {
      "name": "旁遮普语",
      "nativename": "ਪੰਜਾਬੀ",
      "scripts": [
        {
          "code": "Guru",
          "name": "Gurmukhi",
          "nativename": "Gurmukhi",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Latn",
              "name": "Latin",
              "nativename": "Latin",
              "dir": "ltr"
            }
          ]
        },
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "Latin",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Guru",
              "name": "Gurmukhi",
              "nativename": "Gurmukhi",
              "dir": "ltr"
            }
          ]
        }
      ]
    },
    "sr-Cyrl": {
      "name": "塞尔维亚语 (西里尔文)",
      "nativename": "srpski (ćirilica)",
      "scripts": [
        {
          "code": "Cyrl",
          "name": "西里尔文",
          "nativename": "Cyrillic",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Latn",
              "name": "Latin",
              "nativename": "Latinski",
              "dir": "ltr"
            }
          ]
        }
      ]
    },
    "sr-Latn": {
      "name": "塞尔维亚语 (拉丁文)",
      "nativename": "srpski (latinica)",
      "scripts": [
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "Latinski",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Cyrl",
              "name": "Cyrillic",
              "nativename": "Ćirilica",
              "dir": "ltr"
            }
          ]
        }
      ]
    },
    "ta": {
      "name": "泰米尔语",
      "nativename": "தமிழ்",
      "scripts": [
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "Latin",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Taml",
              "name": "Tamil",
              "nativename": "Tamil",
              "dir": "ltr"
            }
          ]
        }
      ]
    },
    "te": {
      "name": "泰卢固语",
      "nativename": "తెలుగు",
      "scripts": [
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "Latin",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Telu",
              "name": "Telugu",
              "nativename": "Telugu",
              "dir": "ltr"
            }
          ]
        }
      ]
    },
    "th": {
      "name": "泰语",
      "nativename": "ไทย",
      "scripts": [
        {
          "code": "Thai",
          "name": "泰语",
          "nativename": "ภาษาไทย",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Latn",
              "name": "Latin",
              "nativename": "ละติน",
              "dir": "ltr"
            }
          ]
        },
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "ละติน",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Thai",
              "name": "Thai",
              "nativename": "ภาษาไทย",
              "dir": "ltr"
            }
          ]
        }
      ]
    },
    "zh-Hans": {
      "name": "简体中文",
      "nativename": "简体中文",
      "scripts": [
        {
          "code": "Hans",
          "name": "简体汉语",
          "nativename": "简体汉语",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Latn",
              "name": "Latin",
              "nativename": "拉丁语",
              "dir": "ltr"
            },
            {
              "code": "Hant",
              "name": "Hat",
              "nativename": "传统",
              "dir": "ltr"
            }
          ]
        },
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "拉丁语",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Hans",
              "name": "Han",
              "nativename": "简体汉语",
              "dir": "ltr"
            },
            {
              "code": "Hant",
              "name": "Hat",
              "nativename": "传统",
              "dir": "ltr"
            }
          ]
        }
      ]
    },
    "zh-Hant": {
      "name": "繁体中文",
      "nativename": "繁體中文",
      "scripts": [
        {
          "code": "Hant",
          "name": "传统",
          "nativename": "傳統",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Latn",
              "name": "Latin",
              "nativename": "拉丁语",
              "dir": "ltr"
            },
            {
              "code": "Hans",
              "name": "Han",
              "nativename": "简体汉语",
              "dir": "ltr"
            }
          ]
        },
        {
          "code": "Latn",
          "name": "拉丁语",
          "nativename": "拉丁文",
          "dir": "ltr",
          "toScripts": [
            {
              "code": "Hans",
              "name": "Han",
              "nativename": "简体汉语",
              "dir": "ltr"
            },
            {
              "code": "Hant",
              "name": "Hat",
              "nativename": "传统",
              "dir": "ltr"
            }
          ]
        }
      ]
    }
  },
  "dictionary": {
    "af": {
      "name": "南非荷兰语",
      "nativename": "Afrikaans",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "ar": {
      "name": "阿拉伯语",
      "nativename": "العربية",
      "dir": "rtl",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "bg": {
      "name": "保加利亚语",
      "nativename": "Български",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "bn": {
      "name": "孟加拉语",
      "nativename": "বাংলা",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "bs": {
      "name": "波斯尼亚语",
      "nativename": "bosanski (latinica)",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "ca": {
      "name": "加泰隆语",
      "nativename": "Català",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "cs": {
      "name": "捷克语",
      "nativename": "Čeština",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "cy": {
      "name": "威尔士语",
      "nativename": "Welsh",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "da": {
      "name": "丹麦语",
      "nativename": "Dansk",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "de": {
      "name": "德语",
      "nativename": "Deutsch",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "el": {
      "name": "希腊语",
      "nativename": "Ελληνικά",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "en": {
      "name": "英语",
      "nativename": "english",
      "dir": "ltr",
      "translations": [
        {
          "name": "南非荷兰语",
          "nativename": "Afrikaans",
          "dir": "ltr",
          "code": "af"
        },
        {
          "name": "阿拉伯语",
          "nativename": "العربية",
          "dir": "rtl",
          "code": "ar"
        },
        {
          "name": "保加利亚语",
          "nativename": "Български",
          "dir": "ltr",
          "code": "bg"
        },
        {
          "name": "孟加拉语",
          "nativename": "বাংলা",
          "dir": "ltr",
          "code": "bn"
        },
        {
          "name": "波斯尼亚语",
          "nativename": "bosanski (latinica)",
          "dir": "ltr",
          "code": "bs"
        },
        {
          "name": "加泰隆语",
          "nativename": "Català",
          "dir": "ltr",
          "code": "ca"
        },
        {
          "name": "简体中文",
          "nativename": "简体中文",
          "dir": "ltr",
          "code": "zh-Hans"
        },
        {
          "name": "捷克语",
          "nativename": "Čeština",
          "dir": "ltr",
          "code": "cs"
        },
        {
          "name": "威尔士语",
          "nativename": "Welsh",
          "dir": "ltr",
          "code": "cy"
        },
        {
          "name": "丹麦语",
          "nativename": "Dansk",
          "dir": "ltr",
          "code": "da"
        },
        {
          "name": "德语",
          "nativename": "Deutsch",
          "dir": "ltr",
          "code": "de"
        },
        {
          "name": "希腊语",
          "nativename": "Ελληνικά",
          "dir": "ltr",
          "code": "el"
        },
        {
          "name": "西班牙语",
          "nativename": "Español",
          "dir": "ltr",
          "code": "es"
        },
        {
          "name": "爱沙尼亚语",
          "nativename": "Eesti",
          "dir": "ltr",
          "code": "et"
        },
        {
          "name": "波斯语",
          "nativename": "Persian",
          "dir": "rtl",
          "code": "fa"
        },
        {
          "name": "芬兰语",
          "nativename": "Suomi",
          "dir": "ltr",
          "code": "fi"
        },
        {
          "name": "法罗语",
          "nativename": "Haitian Creole",
          "dir": "ltr",
          "code": "ht"
        },
        {
          "name": "法语",
          "nativename": "Français",
          "dir": "ltr",
          "code": "fr"
        },
        {
          "name": "希伯来语",
          "nativename": "עברית",
          "dir": "rtl",
          "code": "he"
        },
        {
          "name": "印地语",
          "nativename": "हिंदी",
          "dir": "ltr",
          "code": "hi"
        },
        {
          "name": "克罗地亚语",
          "nativename": "Hrvatski",
          "dir": "ltr",
          "code": "hr"
        },
        {
          "name": "匈牙利语",
          "nativename": "Magyar",
          "dir": "ltr",
          "code": "hu"
        },
        {
          "name": "印度尼西亚语",
          "nativename": "Indonesia",
          "dir": "ltr",
          "code": "id"
        },
        {
          "name": "冰岛语",
          "nativename": "Íslenska",
          "dir": "ltr",
          "code": "is"
        },
        {
          "name": "意大利语",
          "nativename": "Italiano",
          "dir": "ltr",
          "code": "it"
        },
        {
          "name": "日语",
          "nativename": "日本語",
          "dir": "ltr",
          "code": "ja"
        },
        {
          "name": "朝鲜语",
          "nativename": "한국어",
          "dir": "ltr",
          "code": "ko"
        },
        {
          "name": "立陶宛语",
          "nativename": "Lietuvių",
          "dir": "ltr",
          "code": "lt"
        },
        {
          "name": "拉脱维亚语",
          "nativename": "Latviešu",
          "dir": "ltr",
          "code": "lv"
        },
        {
          "name": "马耳他语",
          "nativename": "Il-Malti",
          "dir": "ltr",
          "code": "mt"
        },
        {
          "name": "马来语",
          "nativename": "Melayu",
          "dir": "ltr",
          "code": "ms"
        },
        {
          "name": "白苗文",
          "nativename": "Hmong Daw",
          "dir": "ltr",
          "code": "mww"
        },
        {
          "name": "荷兰语",
          "nativename": "Nederlands",
          "dir": "ltr",
          "code": "nl"
        },
        {
          "name": "挪威语",
          "nativename": "Norsk",
          "dir": "ltr",
          "code": "nb"
        },
        {
          "name": "波兰语",
          "nativename": "Polski",
          "dir": "ltr",
          "code": "pl"
        },
        {
          "name": "葡萄牙语",
          "nativename": "Português",
          "dir": "ltr",
          "code": "pt"
        },
        {
          "name": "罗马尼亚语",
          "nativename": "Română",
          "dir": "ltr",
          "code": "ro"
        },
        {
          "name": "俄语",
          "nativename": "Русский",
          "dir": "ltr",
          "code": "ru"
        },
        {
          "name": "斯洛伐克语",
          "nativename": "Slovenčina",
          "dir": "ltr",
          "code": "sk"
        },
        {
          "name": "斯洛文尼亚语",
          "nativename": "Slovenščina",
          "dir": "ltr",
          "code": "sl"
        },
        {
          "name": "塞尔维亚语 (拉丁文)",
          "nativename": "srpski (latinica)",
          "dir": "ltr",
          "code": "sr-Latn"
        },
        {
          "name": "瑞典语",
          "nativename": "Svenska",
          "dir": "ltr",
          "code": "sv"
        },
        {
          "name": "斯瓦希里语",
          "nativename": "Kiswahili",
          "dir": "ltr",
          "code": "sw"
        },
        {
          "name": "泰米尔语",
          "nativename": "தமிழ்",
          "dir": "ltr",
          "code": "ta"
        },
        {
          "name": "泰语",
          "nativename": "ไทย",
          "dir": "ltr",
          "code": "th"
        },
        {
          "name": "克林贡语",
          "nativename": "Klingon",
          "dir": "ltr",
          "code": "tlh"
        },
        {
          "name": "土耳其语",
          "nativename": "Türkçe",
          "dir": "ltr",
          "code": "tr"
        },
        {
          "name": "乌克兰语",
          "nativename": "Українська",
          "dir": "ltr",
          "code": "uk"
        },
        {
          "name": "乌尔都语",
          "nativename": "اردو",
          "dir": "rtl",
          "code": "ur"
        },
        {
          "name": "越南语",
          "nativename": "Tiếng Việt",
          "dir": "ltr",
          "code": "vi"
        }
      ]
    },
    "es": {
      "name": "西班牙语",
      "nativename": "Español",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "et": {
      "name": "爱沙尼亚语",
      "nativename": "Eesti",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "fa": {
      "name": "波斯语",
      "nativename": "Persian",
      "dir": "rtl",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "fi": {
      "name": "芬兰语",
      "nativename": "Suomi",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "fr": {
      "name": "法语",
      "nativename": "Français",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "he": {
      "name": "希伯来语",
      "nativename": "עברית",
      "dir": "rtl",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "hi": {
      "name": "印地语",
      "nativename": "हिंदी",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "hr": {
      "name": "克罗地亚语",
      "nativename": "Hrvatski",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "ht": {
      "name": "法罗语",
      "nativename": "Haitian Creole",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "hu": {
      "name": "匈牙利语",
      "nativename": "Magyar",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "id": {
      "name": "印度尼西亚语",
      "nativename": "Indonesia",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "is": {
      "name": "冰岛语",
      "nativename": "Íslenska",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "it": {
      "name": "意大利语",
      "nativename": "Italiano",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "ja": {
      "name": "日语",
      "nativename": "日本語",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "ko": {
      "name": "朝鲜语",
      "nativename": "한국어",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "lt": {
      "name": "立陶宛语",
      "nativename": "Lietuvių",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "lv": {
      "name": "拉脱维亚语",
      "nativename": "Latviešu",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "ms": {
      "name": "马来语",
      "nativename": "Melayu",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "mt": {
      "name": "马耳他语",
      "nativename": "Il-Malti",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "mww": {
      "name": "白苗文",
      "nativename": "Hmong Daw",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "nb": {
      "name": "挪威语",
      "nativename": "Norsk",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "nl": {
      "name": "荷兰语",
      "nativename": "Nederlands",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "pl": {
      "name": "波兰语",
      "nativename": "Polski",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "pt": {
      "name": "葡萄牙语",
      "nativename": "Português",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "ro": {
      "name": "罗马尼亚语",
      "nativename": "Română",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "ru": {
      "name": "俄语",
      "nativename": "Русский",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "sk": {
      "name": "斯洛伐克语",
      "nativename": "Slovenčina",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "sl": {
      "name": "斯洛文尼亚语",
      "nativename": "Slovenščina",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "sr-Latn": {
      "name": "塞尔维亚语 (拉丁文)",
      "nativename": "srpski (latinica)",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "sv": {
      "name": "瑞典语",
      "nativename": "Svenska",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "sw": {
      "name": "斯瓦希里语",
      "nativename": "Kiswahili",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "ta": {
      "name": "泰米尔语",
      "nativename": "தமிழ்",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "th": {
      "name": "泰语",
      "nativename": "ไทย",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "tlh": {
      "name": "克林贡语",
      "nativename": "Klingon",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "tr": {
      "name": "土耳其语",
      "nativename": "Türkçe",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "uk": {
      "name": "乌克兰语",
      "nativename": "Українська",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "ur": {
      "name": "乌尔都语",
      "nativename": "اردو",
      "dir": "rtl",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "vi": {
      "name": "越南语",
      "nativename": "Tiếng Việt",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    },
    "zh-Hans": {
      "name": "简体中文",
      "nativename": "简体中文",
      "dir": "ltr",
      "translations": [
        {
          "name": "英语",
          "nativename": "english",
          "dir": "ltr",
          "code": "en"
        }
      ]
    }
  }
}
""".trimIndent()
        */

/*Google LANG
[
{"name":"南非荷兰语","code":"af"},
{"name":"阿尔巴尼亚语","code":"sq"},
{"name":"阿姆哈拉语","code":"am"},
{"name":"阿拉伯语","code":"ar"},
{"name":"亚美尼亚语","code":"hy"},
{"name":"阿塞拜疆语","code":"az"},
{"name":"巴斯克语","code":"eu"},
{"name":"白俄罗斯语","code":"be"},
{"name":"孟加拉语","code":"bn"},
{"name":"波斯尼亚语","code":"bs"},
{"name":"保加利亚语","code":"bg"},
{"name":"加泰罗尼亚语","code":"ca"},
{"name":"宿务语","code":"ceb (ISO-639-2)"},
{"name":"中文（简体）","code":"zh-CN (BCP-47)"},
{"name":"中文（繁体）","code":"zh-TW (BCP-47)"},
{"name":"科西嘉语","code":"co"},
{"name":"克罗地亚语","code":"hr"},
{"name":"捷克语","code":"cs"},
{"name":"丹麦语","code":"da"},
{"name":"荷兰语","code":"nl"},
{"name":"英语","code":"en"},
{"name":"世界语","code":"eo"},
{"name":"爱沙尼亚语","code":"et"},
{"name":"芬兰语","code":"fi"},
{"name":"法语","code":"fr"},
{"name":"弗里斯兰语","code":"fy"},
{"name":"加利西亚语","code":"gl"},
{"name":"格鲁吉亚语","code":"ka"},
{"name":"德语","code":"de"},
{"name":"希腊语","code":"el"},
{"name":"古吉拉特语","code":"gu"},
{"name":"海地克里奥尔语","code":"ht"},
{"name":"豪萨语","code":"ha"},
{"name":"夏威夷语","code":"haw (ISO-639-2)"},
{"name":"希伯来语","code":"he**"},
{"name":"印地语","code":"hi"},
{"name":"苗语","code":"hmn (ISO-639-2)"},
{"name":"匈牙利语","code":"hu"},
{"name":"冰岛语","code":"is"},
{"name":"伊博语","code":"ig"},
{"name":"印度尼西亚语","code":"id"},
{"name":"爱尔兰语","code":"ga"},
{"name":"意大利语","code":"it"},
{"name":"日语","code":"ja"},
{"name":"爪哇语","code":"jw"},
{"name":"卡纳达语","code":"kn"},
{"name":"哈萨克语","code":"kk"},
{"name":"高棉语","code":"km"},
{"name":"韩语","code":"ko"},
{"name":"库尔德语","code":"ku"},
{"name":"吉尔吉斯语","code":"ky"},
{"name":"老挝语","code":"lo"},
{"name":"拉丁语","code":"la"},
{"name":"拉脱维亚语","code":"lv"},
{"name":"立陶宛语","code":"lt"},
{"name":"卢森堡语","code":"lb"},
{"name":"马其顿语","code":"mk"},
{"name":"马尔加什语","code":"mg"},
{"name":"马来语","code":"ms"},
{"name":"马拉雅拉姆语","code":"ml"},
{"name":"马耳他语","code":"mt"},
{"name":"毛利语","code":"mi"},
{"name":"马拉地语","code":"mr"},
{"name":"蒙古语","code":"mn"},
{"name":"缅甸语","code":"my"},
{"name":"尼泊尔语","code":"ne"},
{"name":"挪威语","code":"no"},
{"name":"尼杨扎语（齐切瓦语）","code":"ny"},
{"name":"普什图语","code":"ps"},
{"name":"波斯语","code":"fa"},
{"name":"波兰语","code":"pl"},
{"name":"葡萄牙语（葡萄牙、巴西）","code":"pt"},
{"name":"旁遮普语","code":"pa"},
{"name":"罗马尼亚语","code":"ro"},
{"name":"俄语","code":"ru"},
{"name":"萨摩亚语","code":"sm"},
{"name":"苏格兰盖尔语","code":"gd"},
{"name":"塞尔维亚语","code":"sr"},
{"name":"塞索托语","code":"st"},
{"name":"修纳语","code":"sn"},
{"name":"信德语","code":"sd"},
{"name":"僧伽罗语","code":"si"},
{"name":"斯洛伐克语","code":"sk"},
{"name":"斯洛文尼亚语","code":"sl"},
{"name":"索马里语","code":"so"},
{"name":"西班牙语","code":"es"},
{"name":"巽他语","code":"su"},
{"name":"斯瓦希里语","code":"sw"},
{"name":"瑞典语","code":"sv"},
{"name":"塔加路语（菲律宾语）","code":"tl"},
{"name":"塔吉克语","code":"tg"},
{"name":"泰米尔语","code":"ta"},
{"name":"泰卢固语","code":"te"},
{"name":"泰语","code":"th"},
{"name":"土耳其语","code":"tr"},
{"name":"乌克兰语","code":"uk"},
{"name":"乌尔都语","code":"ur"},
{"name":"乌兹别克语","code":"uz"},
{"name":"越南语","code":"vi"},
{"name":"威尔士语","code":"cy"},
{"name":"班图语","code":"xh"},
{"name":"意第绪语","code":"yi"},
{"name":"约鲁巴语","code":"yo"},
{"name":"祖鲁语","code":"zu"}
]
 */
/*
fun main() {
    val g = """
        langMap[LANG.AUTO] = "auto-detect"
        langMap[LANG.NL] = "af"//南非荷兰语
        langMap[LANG.ar] = "ar"//阿拉伯语
        langMap[LANG.BG] = "bg"//保加利亚语
        langMap[LANG.BN] = "bn"//孟加拉语
        langMap[LANG.FA] = "bs"//波斯尼亚语
        langMap[LANG.CA] = "ca"//加泰隆语
        langMap[LANG.CS] = "cs"//捷克语
        langMap[LANG.CY] = "cy"//威尔士语
        langMap[LANG.DA] = "da"//丹麦语
        langMap[LANG.DE] = "de"//德语
        langMap[LANG.EL] = "el"//希腊语
        langMap[LANG.en] = "en"//英语
        langMap[LANG.es] = "es"//西班牙语
        langMap[LANG.ET] = "et"//爱沙尼亚语
        langMap[LANG.FA] = "fa"//波斯语
        langMap[LANG.FI] = "fi"//芬兰语
        langMap[LANG.FIL] = "fil"//菲律宾语
        langMap[LANG.FJ] = "fj"//斐济
        langMap[LANG.FR] = "fr"//法语
        langMap[LANG.IW] = "he"//希伯来语
        langMap[LANG.HI] = "hi"//印地语
        langMap[LANG.HR] = "hr"//克罗地亚语
        langMap[LANG.FR] = "ht"//海地克里奥尔语
        langMap[LANG.HU] = "hu"//匈牙利语
        langMap[LANG.IN] = "id"//印度尼西亚语
        langMap[LANG.IS] = "is"//冰岛语
        langMap[LANG.IT] = "it"//意大利语
        langMap[LANG.ja] = "ja"//日语
        langMap[LANG.ko] = "ko"//朝鲜语
        langMap[LANG.LT] = "lt"//立陶宛语
        langMap[LANG.LV] = "lv"//拉脱维亚语
        langMap[LANG.MG] = "mg"//马尔加什语
        langMap[LANG.MS] = "ms"//马来语
        langMap[LANG.MT] = "mt"//马耳他语
        langMap[LANG.HMN] = "mww"//白苗文
        langMap[LANG.NB] = "nb"//挪威语
        langMap[LANG.NL] = "nl"//荷兰语
        langMap[LANG.OTQ] = "otq"//克雷塔罗奥托米语
        langMap[LANG.PL] = "pl"//波兰语
        langMap[LANG.pt] = "pt"//葡萄牙语
        langMap[LANG.RO] = "ro"//罗马尼亚语
        langMap[LANG.RU] = "ru"//俄语
        langMap[LANG.SK] = "sk"//斯洛伐克语
        langMap[LANG.SL] = "sl"//斯洛文尼亚语
        langMap[LANG.SM] = "sm"//萨摩亚语
        langMap[LANG.SR] = "sr-Cyrl"//塞尔维亚语 (西里尔文)
        langMap[LANG.SR] = "sr-Latn"//塞尔维亚语 (拉丁文)
        langMap[LANG.SV] = "sv"//瑞典语
        langMap[LANG.sw] = "sw"//斯瓦希里语
        langMap[LANG.TA] = "ta"//泰米尔语
        langMap[LANG.TE] = "te"//泰卢固语
        langMap[LANG.th] = "th"//泰语
        langMap[LANG.FILH] = "tlh"//克林贡语
        langMap[LANG.TO] = "to"//汤加语
        langMap[LANG.TR] = "tr"//土耳其语
        langMap[LANG.TY] = "ty"//塔希提语
        langMap[LANG.UK] = "uk"//乌克兰语
        langMap[LANG.UR] = "ur"//乌尔都语
        langMap[LANG.VI] = "vi"//越南语
        langMap[LANG.YUA] = "yua"//尤卡坦玛雅语
        //langMap[LANG.YUE] = "yue"//粤语(繁体)
        langMap[LANG.zh_cn] = "zh-Hans"//简体中文
        langMap[LANG.ZH_TW] = "zh-Hant"//繁体中文
    """.trimIndent()

    val sb = StringBuilder()

    val sr = StringReader(g)
    val list = sr.readLines()

    for (line in list) {

        if (line.trim().isEmpty()) continue
        val code = line.substring(line.indexOf('"') + 1, line.lastIndexOf('"'))
        //langMap[LANG.AUTO] = "auto"

        val row = ", \"$code\" to LANG.${code.toUpperCase()}"
        sb.append(row).append('\n')
    }
    println(sb.toString())
}
        */