package com.talpa.master.ui.history

import android.graphics.Rect
import android.graphics.drawable.AnimationDrawable
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import androidx.recyclerview.widget.RecyclerView
import com.blankj.utilcode.util.SizeUtils
import com.talpa.master.R
import com.talpa.master.databinding.MolItemHistoryBinding
import com.talpa.master.databinding.MolItemHistoryEmptyBinding
import com.talpa.master.repository.room.model.History
import com.talpa.master.ui.main.MainViewModel
import com.talpa.master.utils.AppUtil
import com.talpa.master.utils.ViewOutlineProviderImpl

/**
 * Create by kgxl on 2021/4/13
 */
class HistoryAdapter(private val viewModel: HistoryViewModel, private val type: String) :
    RecyclerView.Adapter<HistoryAdapter.BaseViewHolder>() {
    abstract open inner class BaseViewHolder(private val binding: ViewDataBinding) :
        RecyclerView.ViewHolder(binding.root) {
        abstract fun bind(position: Int)
    }

    inner class HistoryViewHolder(private val binding: MolItemHistoryBinding) :
        BaseViewHolder(binding) {
        private lateinit var mHistory: History
        private val itemClick = View.OnClickListener {
            when (it.id) {
                // 复制
                R.id.tv_main_result_copy -> {
                    mHistory?.let { history ->
                        viewModel.copyText(history, it)
                    }
                }
                // 星标
                R.id.tv_main_result_start -> {
                    mHistory?.let { history ->
                        viewModel.starMark(history, type, adapterPosition, it as ImageView)
                    }
                }
                // 播报
                R.id.tv_main_result_voice -> {
                    viewModel.lastPlayIndex = viewModel.currentPlayClickIndex
                    viewModel.currentPlayClickIndex = adapterPosition
                    viewModel.playTranslateVoice(mHistory)
                }
                //列表
                R.id.history_parent -> {
                    binding.molFaceControlGroup.let { group ->
                        if (group.visibility == View.VISIBLE) {
                            group.visibility = View.GONE
                            viewModel.enlarge(mHistory, false)
                            Log.i("Sky_Test", "mHistory:$mHistory, localParamEnlarge = false")
                        } else {
                            group.visibility = View.VISIBLE
                            viewModel.enlarge(mHistory, true)
                            Log.i("Sky_Test", "mHistory:$mHistory, localParamEnlarge = true")
                        }
                    }
                }
                //展开
                R.id.mol_face_enlarge_icon -> {
                    viewModel.itemEnlarge(mHistory, position = 0)
                }
            }
        }


        override fun bind(position: Int) {
            val history = viewModel.historys.value?.get(position)
            history?.let {
                mHistory = it
                if (it.id.toString().trim() == viewModel.translateHistoryId) {
                    viewModel.isStarMark = it.isStartMarker
                }

                binding.tvMainResultSource.text = it.source_result
                binding.tvMainResultText.text = it.target_result
                binding.historyParent.clipToOutline = true
                val dp: Float = SizeUtils.dp2px(if (AppUtil.isHiOS()) 14F else 8F).toFloat()
                binding.historyParent.outlineProvider =
                    ViewOutlineProviderImpl(dp)

                // 是否是星标
                if (history.isStartMarker) {
                    binding.tvMainResultStart.setImageResource(R.drawable.mol_face_collected_icon)
                } else {
                    binding.tvMainResultStart.setImageResource(R.drawable.mol_face_collect_icon)
                }

                // 是否能播放
                if (history.isVoicePlay) {
                    binding.tvMainResultVoice.setImageResource(R.drawable.mol_face_left_play_normal)
                    binding.tvMainResultVoice.isEnabled = true
                } else {
                    binding.tvMainResultVoice.setImageResource(R.drawable.mol_face_left_play_disable)
                    binding.tvMainResultVoice.isEnabled = false
                }


                if (position == viewModel.currentPlayClickIndex) {
                    if (viewModel.currentPlayStatus == MainViewModel.VoicePlayStatus.START) {
                        binding.tvMainResultVoice.setImageResource(R.drawable.mol_voice_start_anim)
                        (binding.tvMainResultVoice.drawable as AnimationDrawable).start()
                    } else {
                        binding.tvMainResultVoice.setImageResource(R.drawable.mol_face_left_play_normal)
                    }
                } else if (position == viewModel.lastPlayIndex) {
                    binding.tvMainResultVoice.setImageResource(R.drawable.mol_face_left_play_normal)
                }

                //更新UI状态，是否是展开状态
                binding.molFaceControlGroup.let { group ->
                    val isEnlarge = viewModel.isEnlarge(it)
                    Log.v("Sky_Test", "mHistory:$it, isEnlarge = $isEnlarge")
                    if (isEnlarge) {
                        group.visibility = View.VISIBLE
                    } else {
                        group.visibility = View.GONE
                    }
                }

                binding.tvMainResultStart.setOnClickListener(itemClick)
                binding.tvMainResultCopy.setOnClickListener(itemClick)
                binding.tvMainResultVoice.setOnClickListener(itemClick)
                binding.historyParent.setOnClickListener(itemClick)
                binding.molFaceEnlargeIcon.setOnClickListener(itemClick)
            }
        }
    }

    inner class EmptyViewHolder(private val binding: MolItemHistoryEmptyBinding) :
        BaseViewHolder(binding) {
        override fun bind(position: Int) {
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BaseViewHolder {
        val inflater = LayoutInflater.from(parent.context)
        if (viewType == 1) {
            return EmptyViewHolder(
                DataBindingUtil.inflate(
                    inflater,
                    R.layout.mol_item_history_empty,
                    parent,
                    false
                )
            )
        }
        val bind =
            DataBindingUtil.inflate<MolItemHistoryBinding>(
                inflater,
                R.layout.mol_item_history,
                parent,
                false
            )
        return HistoryViewHolder(bind)
    }

    override fun onBindViewHolder(holder: BaseViewHolder, position: Int) {
        holder.bind(position)
    }

    override fun getItemCount(): Int = viewModel.historys.value?.size ?: 0

    override fun getItemViewType(position: Int): Int {
        if (viewModel.historys.value?.size == 0) {
            return 1
        }
        return super.getItemViewType(position)
    }

    class SpaceItemDecoration(var bottom: Int, var firstTop:Int = 0) : RecyclerView.ItemDecoration() {
        override fun getItemOffsets(
            outRect: Rect,
            view: View,
            parent: RecyclerView,
            state: RecyclerView.State
        ) {
            val itemPosition: Int = parent.getChildAdapterPosition(view)
            if (itemPosition == 0) {
                outRect.top = firstTop
            }
            outRect.bottom = bottom
        }
    }
}