package com.talpa.master.ui.main

import android.app.Application
import androidx.lifecycle.AndroidViewModel
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.viewModelScope
import com.hiservice.aidl.UtteranceProgressCallback
import com.hiservice.connect.HiServiceConnection
import com.hiservice.connect.registerUtteranceProgress
import com.hiservice.connect.unregisterUtteranceProgress
import com.talpa.master.repository.room.model.History
import com.talpa.translate.face.TranslateService
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import java.util.*


class ResultViewModel(ctx: Application) : AndroidViewModel(ctx) {
    var isAutoScreen: Boolean = false
    lateinit var history: History
    val voicePlayStatus = MutableLiveData<VoicePlayStatus>()

    // 播报
    fun playTranslateVoice(content:String? = null, languageCode:String? = null) {
        if (null == content || null == languageCode) {
            return
        }
        viewModelScope.launch {
            if (TranslateService.Companion.getInstance().isSpeaking()) {
                stopTranslateVoice()
            } else {
                val isSuccess: Boolean = TranslateService.Companion.getInstance().startSpeak(
                    content,
                    Locale.forLanguageTag(languageCode).language
                )
            }
        }
    }

    fun registerCall() = viewModelScope.launch(context = Dispatchers.IO){
        HiServiceConnection.registerUtteranceProgress(callback = utteranceProgressCallback)
    }

    fun unregisterCall() = viewModelScope.launch(context = Dispatchers.IO) {
        HiServiceConnection.unregisterUtteranceProgress(callback = utteranceProgressCallback)
    }

    val utteranceProgressCallback = object :
        UtteranceProgressCallback.Stub() {
        override fun onStart(p0: String?) {
            voicePlayStatus.postValue(VoicePlayStatus.START)
        }

        override fun onDone(p0: String?) {
            voicePlayStatus.postValue(VoicePlayStatus.END)
        }

        override fun onError(p0: String?) {
            voicePlayStatus.postValue(VoicePlayStatus.ERROR)
        }
    }
    fun stopTranslateVoice() {
        viewModelScope.launch(context = Dispatchers.IO) {
            TranslateService.Companion.getInstance().stopSpeak()
            voicePlayStatus.postValue(VoicePlayStatus.PAUSE)
        }

    }

    enum class VoicePlayStatus(val value: Int) {
        START(0),//开始
        PAUSE(1),//暂停
        END(2),//结束
        ERROR(3),//结束
    }

}