package com.talpa.master.ui.main

import android.app.Application
import androidx.lifecycle.AndroidViewModel
import com.talpa.master.framework.RoomHelper
import com.talpa.master.repository.room.model.History
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

/**
 * created by kgxl on: 2021/5/8
 */

class RoomViewModel(ctx: Application) : AndroidViewModel(ctx) {
    /**
     * 插入新数据
     */
    suspend fun insertHistoryList(
        result: String, viewModel: MainViewModel, sourceLanguage: String?,
        targetLanguage: String?
    ): History = withContext(Dispatchers.IO) {
        val languages = viewModel.languageList
        val sourceName =
            languages.findLast { it.key == sourceLanguage }?.name
                ?: ""
        val targetName =
            languages.findLast { it.key == targetLanguage }?.name
                ?: ""
        val history: History
        val isVoicePlay = true
//        targetLanguage?.let {
//            isVoicePlay = viewModel.isCanPlayVoice(it)
//        }
        when (viewModel.currentSpeech) {
            CommunicationActivity.SpeechType.SOURCE -> {
                history =
                    History(

                        source_result = viewModel.sourceResult.value ?: "",
                        target_result = result,
                        display_type = MainViewModel.HistoryItemViewType.SOURCE.value,
                        end_mills = System.currentTimeMillis(),
                        mills = System.currentTimeMillis(),
                        isVoicePlay = isVoicePlay,
                        sourcelanguage_tag = sourceLanguage ?: "",
                        targetlanguage_tag = targetLanguage ?: "",
                        sourcelanguage_name = sourceName,
                        targetlanguage_name = targetName,
                    )
            }
            CommunicationActivity.SpeechType.TARGET -> {
                history =
                    History(
                        target_result = result,
                        source_result = viewModel.sourceResult.value ?: "",
                        display_type = MainViewModel.HistoryItemViewType.TARGET.value,
                        end_mills = System.currentTimeMillis(),
                        mills = System.currentTimeMillis(),
                        isVoicePlay = isVoicePlay,
                        sourcelanguage_tag = sourceLanguage ?: "",
                        targetlanguage_tag = targetLanguage ?: "",
                        sourcelanguage_name = sourceName,
                        targetlanguage_name = targetName
                    )
            }
        }
        RoomHelper.historyDao.insert(history)
        RoomHelper.historyDao.queryLastHistory()
    }

}