package com.talpa.master.ui.main.adapter

import android.graphics.Rect
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.CheckBox
import android.widget.CompoundButton
import androidx.recyclerview.widget.RecyclerView
import com.talpa.master.R
import com.talpa.master.databinding.MolItemChoiceLanguageBinding
import com.talpa.master.framework.RoomHelper
import com.talpa.master.repository.room.model.LanguageModel
import com.talpa.master.ui.main.MainViewModel
import com.talpa.master.utils.AppUtil
import io.reactivex.Flowable
import io.reactivex.schedulers.Schedulers

/**
 * Create by kgxl on 2021/4/8
 */
class ChoiceLanguageAdapter(
    private val vm: MainViewModel,
    private val onItemClick: OnItemClickListener
) :
    RecyclerView.Adapter<ChoiceLanguageAdapter.ItemViewHolder>() {
    private var isFirstLoad: Boolean = true

    inner class ItemViewHolder(private val bind: MolItemChoiceLanguageBinding) :
        RecyclerView.ViewHolder(bind.root) {
        private lateinit var currentData: LanguageModel.LanguageList

        private val itemClick = View.OnClickListener {
            click(it)
            bind.cbCheckLanguage.isChecked = true
        }

        private val itemCheck = View.OnClickListener {
            if ((it as CheckBox).isChecked) {
                click(it)
            } else {
                if (vm.langCheck[adapterPosition] != null){
                    if (vm.langCheck[adapterPosition]) {
                        it.isChecked = true
                    }
                }
            }
        }


        private fun click(view: View) {
            currentData.isSelected = true
            if (vm.currentLangType == MainViewModel.LanguageType.SOURCE) {
                currentData.languageType = MainViewModel.LanguageType.SOURCE.value
                vm.sourceLang.postValue(currentData.name)
                vm.updateSourceLanguage(
                    languageTag = currentData.key,
                    languageName = currentData.name
                )
            } else if (vm.currentLangType == MainViewModel.LanguageType.TARGET) {
                currentData.languageType = MainViewModel.LanguageType.TARGET.value
                vm.targetLang.postValue(currentData.name)
                vm.updateTargetLanguage(
                    languageTag = currentData.key,
                    languageName = currentData.name
                )
            }

            onItemClick.onItemClick(view, adapterPosition)
        }



        fun bind(data: LanguageModel.LanguageList) {
            currentData = data
            bind.language = data.name
            bind.key = data.key
            val isCheck = vm.langCheck.get(adapterPosition)?:false
            if (bind.cbCheckLanguage.isChecked != isCheck) {
                bind.cbCheckLanguage.isChecked = isCheck
            }
            bind.mItemClickListener = itemClick
            bind.cbCheckLanguage.setOnClickListener(itemCheck)

            val drawable = bind.cbCheckLanguage.context.resources.getDrawable(R.drawable.mol_btn_radio_material_anim, null)
            val drawable_xos = bind.cbCheckLanguage.context.resources.getDrawable(R.drawable.mol_btn_radio_material_anim_xos, null)
            if (AppUtil.isHiOS()){
                bind.cbCheckLanguage.setCompoundDrawablesRelativeWithIntrinsicBounds(null,null,drawable,null)
            }else{
                bind.cbCheckLanguage.setCompoundDrawablesRelativeWithIntrinsicBounds(null,null,drawable_xos,null)
            }

        }
    }


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ItemViewHolder {
        val layoutInflater = LayoutInflater.from(parent.context)
        return ItemViewHolder(MolItemChoiceLanguageBinding.inflate(layoutInflater, parent, false))
    }

    override fun onBindViewHolder(holder: ItemViewHolder, position: Int) {
        vm.languageList?.let { holder.bind(it[position]) }

    }

    override fun getItemCount(): Int {
        return vm.languageList.size
    }

    class SpaceItemDecoration(var space: Int) : RecyclerView.ItemDecoration() {
        override fun getItemOffsets(
            outRect: Rect,
            view: View,
            parent: RecyclerView,
            state: RecyclerView.State
        ) {
            outRect.bottom = space
        }
    }

    interface OnItemClickListener {
        fun onItemClick(v: View, index: Int)
    }
}