package com.talpa.master.ui.main.fragment

import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.util.DisplayMetrics
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import androidx.core.view.updatePadding
import androidx.fragment.app.activityViewModels
import androidx.lifecycle.ViewModelProvider
import com.blankj.utilcode.util.BarUtils
import com.talpa.master.R
import com.talpa.master.databinding.DataBindingDialogFragment
import com.talpa.master.databinding.MolFragmentChoiceLanguageBinding
import com.talpa.master.ui.main.MainViewModel
import com.talpa.master.utils.AppUtil
import com.talpa.master.utils.SharedPreferenceHelper
import com.talpa.master.widget.RecordTextView
import com.talpa.translate.utils.DpUtils

/**
 * Create by  on 2021/4/5
 */
class ChoiceLanguageFragment : DataBindingDialogFragment<MolFragmentChoiceLanguageBinding>(),
    View.OnClickListener, RecordTextView.OnRecordListener {
    companion object {
        val TAG: String = ChoiceLanguageFragment::class.java.simpleName
        fun getInstance(): ChoiceLanguageFragment {
            return ChoiceLanguageFragment()
        }
    }


//    private val viewModel: CommunicationViewModelV2 by viewModels {
//        ViewModelProvider.AndroidViewModelFactory.getInstance(application)
//    }
    private val mainViewModel: MainViewModel by activityViewModels<MainViewModel> {
        ViewModelProvider.AndroidViewModelFactory.getInstance(
            requireActivity().application
        )
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        mBinding.vm = mainViewModel
        initView()

        if (AppUtil.isHiOS()) {
            mBinding.tvStartUsing.setTextColor(resources.getColor(R.color.choice_language_he_say_bg))

        } else {
            mBinding.tvStartUsing.setTextColor(resources.getColor(R.color.choice_language_he_say_bg_xos))

        }
    }

    override fun onPause() {
        super.onPause()

    }

    override fun onDestroyView() {
        super.onDestroyView()
    }

    private fun initView() {
        val darkTheme = AppUtil.isDarkTheme(requireContext().applicationContext)
        mainViewModel.isDark.postValue(darkTheme)
        mBinding.tvStartUsing.setOnClickListener(this)
        mBinding.tvYouSayLanguage.setOnRecordListener(this)
        mBinding.tvHeSayLanguage.setOnRecordListener(this)
//        mBinding.tvLanguageYouSayArrow.setOnRecordListener(this)
//        mBinding.tvLanguageHeSayArrow.setOnRecordListener(this)

        val win = dialog!!.window
        win!!.setWindowAnimations(R.style.DialogAnim)
        // 一定要设置Background，如果不设置，window属性设置无效
        win!!.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
        val dm = DisplayMetrics()
        activity!!.windowManager.defaultDisplay.getMetrics(dm)
        val params = win!!.attributes
        params.gravity = Gravity.BOTTOM
        // 使用ViewGroup.LayoutParams，以便Dialog 宽度充满整个屏幕
        if (BarUtils.getNavBarHeight() == 1) {
            params.verticalMargin = 0.05f
        }
        params.width = ViewGroup.LayoutParams.MATCH_PARENT
        params.height = DpUtils.dip2px(requireContext().applicationContext, 398f)
        //params.verticalMargin=resources.getDimension(R.dimen.dp8)
        win.decorView.updatePadding(bottom = resources.getDimension(R.dimen.dp8).toInt())
        win!!.attributes = params
        dialog!!.setCanceledOnTouchOutside(false)
    }

    override fun getContentView(): Int = R.layout.mol_fragment_choice_language

    override fun onClick(v: View) {
        when (v.id) {
            R.id.tv_start_using -> {
                SharedPreferenceHelper.putBooleanValue(SharedPreferenceHelper.IS_FIRST_OPEN, false)
                this.dismissAllowingStateLoss()
            }
        }
    }

    override fun onRecordTextViewClick(v: View) {
        when (v.id) {
            // 你说
            R.id.tv_you_say_language -> {//,R.id.tv_language_you_say_arrow
                mainViewModel.currentLangType = MainViewModel.LanguageType.SOURCE

                val sourceLanguae =
                    mainViewModel.sourceLanguageLiveData.value?.toString() ?: return

                val choiceLanguageListFragment = ChoiceLanguageListFragment.getInstance(
                    mainViewModel, defaultSelectLanguage = sourceLanguae
                )
                choiceLanguageListFragment.show(
                    requireActivity().supportFragmentManager,
                    ChoiceLanguageListFragment.TAG
                )
            }

            // 他说
            R.id.tv_he_say_language -> {//,R.id.tv_he_say_language_arrow
                mainViewModel.currentLangType = MainViewModel.LanguageType.TARGET

                val targetLanguage =
                    mainViewModel.targetLanguageLiveData.value?.toString() ?: return

                val choiceLanguageListFragment = ChoiceLanguageListFragment.getInstance(
                    mainViewModel, defaultSelectLanguage = targetLanguage
                )

                choiceLanguageListFragment.show(
                    requireActivity().supportFragmentManager,
                    ChoiceLanguageListFragment.TAG
                )

            }
        }
    }

    override fun onEventUp(v: View) {

    }
}


