package com.talpa.master.ui.main.fragment

import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.util.DisplayMetrics
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import androidx.core.util.forEach
import androidx.core.view.updatePadding
import androidx.fragment.app.activityViewModels
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import com.blankj.utilcode.util.BarUtils
import com.talpa.datareport.report.DataAnalysisHelper
import com.talpa.datareport.report.FA_lan_click_success
import com.talpa.master.R
import com.talpa.master.databinding.DataBindingDialogFragment
import com.talpa.master.databinding.MolFragmentChoiceLanguageListBinding
import com.talpa.master.ui.main.MainViewModel
import com.talpa.master.ui.main.adapter.ChoiceLanguageAdapter
import com.talpa.master.utils.AppUtil
import com.talpa.translate.utils.DpUtils
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext


/**
 * Create by  on 2021/4/5
 */

class ChoiceLanguageListFragment() :
    DataBindingDialogFragment<MolFragmentChoiceLanguageListBinding>() {

    private val viewModel: MainViewModel by activityViewModels()
    private var defaultSelectLanguage: String = ""

    companion object {
        val TAG: String = ChoiceLanguageListFragment::class.java.name
        fun getInstance(
            vm: MainViewModel,
            defaultSelectLanguage: String
        ): ChoiceLanguageListFragment {
            val choiceLanguageListFragment = ChoiceLanguageListFragment()
            val bundle = Bundle()
            bundle.putString("defaultSelectLanguage", defaultSelectLanguage)
            choiceLanguageListFragment.arguments = bundle
            return choiceLanguageListFragment
        }
    }

    override fun onStart() {
        super.onStart()
        val win = dialog!!.window
        win!!.setWindowAnimations(R.style.DialogAnim)
        win!!.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
        val dm = DisplayMetrics()
        requireActivity().windowManager.defaultDisplay.getMetrics(dm)
        val params = win!!.attributes
        params.gravity = Gravity.BOTTOM
        if (BarUtils.getNavBarHeight() == 1) {
            params.verticalMargin = 0.05f
        }
        params.width = ViewGroup.LayoutParams.MATCH_PARENT
        params.height = DpUtils.dip2px(requireContext().applicationContext, 500f)
        win!!.attributes = params
        dialog!!.setCanceledOnTouchOutside(true)


        win.decorView.updatePadding(bottom = resources.getDimension(R.dimen.dp8).toInt())

    }


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        defaultSelectLanguage = arguments?.getString("defaultSelectLanguage") ?: ""
        initView()
        initLanguageList()
    }

    // 初始化
    private fun initView() {
        if (viewModel.currentLangType == MainViewModel.LanguageType.SOURCE) {
            mBinding.tvChoiceLanguageListTitle.setText(R.string.you_say)
        } else {
            mBinding.tvChoiceLanguageListTitle.setText(R.string.he_say)
        }

        mBinding.rvChoiceLanguage.layoutManager = LinearLayoutManager(context)
        mBinding.rvChoiceLanguage.adapter =
            ChoiceLanguageAdapter(viewModel, object : ChoiceLanguageAdapter.OnItemClickListener {
                override fun onItemClick(v: View, index: Int) {

                    lifecycleScope.launch(Dispatchers.Main) {
                        val keys = withContext(context = Dispatchers.IO) {
                            val keys = arrayListOf<Int>()
                            viewModel.langCheck.forEach { key, value ->
                                if (value && key != index) {
                                    viewModel.langCheck.put(key, false)
                                    keys.add(key)
                                }
                            }
                            keys
                        }

                        keys.forEach { mBinding.rvChoiceLanguage.adapter?.notifyItemChanged(it) }


                        delay(600)
                        withContext(Dispatchers.Main) {
                            dismissAllowingStateLoss()
                        }
                    }
//                    mBinding.rvChoiceLanguage.postDelayed({
//                        if ( fragmentManager!= null) {
//                            dismissAllowingStateLoss()
//                        }
//                    }, 600)
                    DataAnalysisHelper.logEvent(
                        context ?: return, FA_lan_click_success, hashMapOf(
                            "type" to if (viewModel.currentLangType == MainViewModel.LanguageType.SOURCE) {
                                "1"
                            } else {
                                "2"
                            }
                        )
                    )

                }
            })
        mBinding.rvChoiceLanguage.addItemDecoration(ChoiceLanguageAdapter.SpaceItemDecoration(20))
        mBinding.viewModel = viewModel
        val darkTheme = AppUtil.isDarkTheme(requireContext().applicationContext)
        viewModel.isDark.postValue(darkTheme)

       }

    // 语言列表
    private fun initLanguageList() {
        lifecycleScope.launch(context = Dispatchers.IO) {
            //var selectIndex = 0
            viewModel.languageList.forEachIndexed { index, languageList ->
                viewModel.langCheck.put(index, defaultSelectLanguage == languageList.key)
            }
            withContext(context = Dispatchers.Main) {
                mBinding.rvChoiceLanguage.adapter?.notifyDataSetChanged()
                //mBinding.rvChoiceLanguage.smoothScrollToPosition(selectIndex)
            }

        }
    }


    override fun getContentView(): Int = R.layout.mol_fragment_choice_language_list

}


