package com.talpa.master.ui.main.fragment

import android.animation.Animator
import android.animation.ObjectAnimator
import android.app.Activity
import android.content.Context
import android.graphics.Point
import android.graphics.Rect
import android.os.Build
import android.provider.Settings
import android.text.Editable
import android.text.TextWatcher
import android.util.Log
import android.view.Display
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.inputmethod.InputMethodManager
import android.widget.Toast
import androidx.appcompat.app.AppCompatDialog
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.view.isVisible
import com.talpa.datareport.report.DataAnalysisHelper
import com.talpa.datareport.report.FA_keyboard_input_fail
import com.talpa.lib.language.open.dp2px
import com.talpa.lib.language.open.getAttrColor
import com.talpa.lib.language.util.FoldUtils
import com.talpa.lib.language.util.WindowSizeClass
import com.talpa.master.R
import com.talpa.master.common.getString
import com.talpa.master.databinding.MolDialogTextTranslateBinding
import com.talpa.master.ui.main.v2.CommunicationViewModelV2
import com.talpa.master.utils.ILengthFilter
import com.talpa.master.utils.MaxLengthFilter
import com.talpa.master.utils.NetWorkUtil
import kotlin.math.max


/**
 * created by kgxl on: 2021/4/24
 */
class TextTranslateFragment() : ITextTranslateDialog, View.OnClickListener {
    companion object {
        private const val INPUT_MAX_COUNT: Int = 200

        private const val ANIMATION_DURATION_INPUT_LAYOUT = 300L
        val TAG: String = TextTranslateFragment::class.java.name

        fun newInstance(): TextTranslateFragment {
            return TextTranslateFragment()
        }
    }

//    private val viewModel by activityViewModels<CommunicationViewModelV2>()

//    private fun getContentView(): Int = R.layout.mol_dialog_text_translate

    //输入框 输入的 源语言内容
    private var sourceInputStr: String = ""

    //输入框 输入的 目标语言的内容
    private var targetInputStr: String = ""
    private var sourceType: String? = null
    private var targetType: String? = null
//    private var isChangeLang: Boolean = false//是否源语言

    //    private var mOnDismissListener: OnDismissListener? = null
//    private var isTranslate = false

    //    private var isSourceClick: Boolean = true
//    private var isTargetClick: Boolean = false
    private var isSelectedLeftTab = false
//    private var sourceLangType: String = ""


    private val textWatch = object : TextWatcher {
        override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {

        }

        override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
            s?.let {
                val mBinding = gBinding ?: return
                mBinding.inputMax.text = txt(it.length)

//                if (it.isNotEmpty()) {
//                    if (AppUtil.isHiOS()) {
//                        mBinding.tvTextTranslate.setTextColor(getColor(R.color.white))
//                    } else {
//                        mBinding.tvTextTranslate.setTextColor(getColor(R.color.white))
//                    }
//                } else {
//                    mBinding.tvTextTranslate.setTextColor(getColor(R.color.text_translate_title))
//                }
            }
        }

        override fun afterTextChanged(s: Editable?) {
            val viewModel = mViewModel ?: return
            viewModel.editTextStr = s.toString()
        }

    }

    private fun txt(it: Int) = "$it/$INPUT_MAX_COUNT"

//
//    override fun getTheme(): Int {
//        return R.style.inputDialog
//    }


    override fun dismiss() {
//        lifecycleScope.launch(Dispatchers.IO) {
//            delay(200)
//            withContext(Dispatchers.Main) {
//                val mBinding = gBinding ?: return@withContext
//                toogleSoftInput(mBinding.etTextTranslate)
//            }
//        }
//        hideNavigationBarColor()
//        super.onDismiss(dialog)
//        mDialog?.dismiss()

        gBinding?.root?.let { hideAnimation(it) }
        gBinding?.etTextTranslate?.let { hideKeyboard(it) }
    }

//    private var mNavigationBarColor: Int? = null
//    private var mStatusBarColor: Int? = null

//    override fun onActivityCreated(savedInstanceState: Bundle?) {
//        super.onActivityCreated(savedInstanceState)
//
//        showNavigationBarColor()
//    }

//    private fun showNavigationBarColor() {
//        activity?.let {
//            if (it is CommunicationActivityV2) {
//                it.showDimAmount(true)
//                it.window?.apply {
//                    mNavigationBarColor = navigationBarColor
//                    mStatusBarColor = statusBarColor
//
//                    val isDark = it.isDarkFontDefault()
//                    val isDarkTheme = isDarkTheme(it)
//                    it.setDarkMode(
//                        R.color.face_dialog_dim_amount_bg_color,
//                        R.color.face_color_bottom_dialog,
//                        isDark
//                    )
//
//                    Log.v("SkyTest", "showNavigationBarColor.$isDark, isDarkTheme:$isDarkTheme")
//                }
//            }
//        }
//    }

//    private fun hideNavigationBarColor(activity:Activity?) {
//        activity?.let {
//            if (it is CommunicationActivityV2) {
//                it.showDimAmount(false)
//                mNavigationBarColor?.let { color ->
//                    it.window?.navigationBarColor = color
//                }
//                mStatusBarColor?.let { color ->
//                    it.window?.statusBarColor = color
//                }
//                Log.v("SkyTest", "hideNavigationBarColor.")
//
//            }
//        }
//    }

    private fun onViewCreated(dialog: AppCompatDialog?) {

        initView()

        initListener()

//        initDialogParam(dialog)

//        initObservers()
    }

    private fun initEditText() {
        val mBinding = gBinding ?: return
        mBinding.etTextTranslate.requestFocus()
        mBinding.etTextTranslate.isFocusable = true
        mBinding.etTextTranslate.isCursorVisible = true
        mBinding.etTextTranslate.isFocusableInTouchMode = true
        mBinding.etTextTranslate.addTextChangedListener(textWatch)
        mBinding.etTextTranslate.maxEms = INPUT_MAX_COUNT
        mBinding.etTextTranslate.filters =
            arrayOf(MaxLengthFilter(INPUT_MAX_COUNT, object : ILengthFilter {
                override fun onChange() {
                    maxLengthToast()
                }
            }))


//        if (AppUtil.isHiOS()) {
//            mBinding.etTextTranslate.highlightColor = getColor(R.color.mol_fill_text_high_color)
//            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
//                mBinding.etTextTranslate.setTextCursorDrawable(R.drawable.mol_edit_cursor_color)
//            }
//        } else {
//            mBinding.etTextTranslate.highlightColor = getColor(R.color.choice_text_high_color_xos)
//            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
//                mBinding.etTextTranslate.setTextCursorDrawable(R.drawable.mol_edit_cursor_color_xos)
//            }
//        }

        mBinding.etTextTranslate.setOnEditorActionListener { _, _, _ ->
            startTranslate()
            true
        }

        mBinding.inputMax.text = txt(0)
        mBinding.etTextTranslate.requestFocus()
    }

    private var mMaxLengthToast: Toast? = null

    private fun maxLengthToast() {
        if (null == mMaxLengthToast) {
            val context = mContext ?: return
            context.let {
                Toast.makeText(it, R.string.feedback_max_size_toast, Toast.LENGTH_LONG)
                    ?.apply {
                        mMaxLengthToast = this
                    }
            }
        }

        mMaxLengthToast?.apply {
            show()
        }

    }

    private var keyboardIsActive = false
    override fun pause() {
        Log.v("Sky", "input dialog :pause")
        mMaxLengthToast?.cancel()
        mMaxLengthToast = null
        keyboardIsActive = false
        gBinding?.etTextTranslate?.let {
            keyboardIsActive = isActive()
            hideKeyboard(it)
        }
    }

    override fun resume() {
        Log.v("Sky", "input dialog :resume:$keyboardIsActive")
        if (keyboardIsActive) {
            gBinding?.etTextTranslate?.let {
                it.postDelayed({ showKeyboard(it) }, 100L)
            }
        }
    }


//    private fun initDialogParam(dialog: AppCompatDialog) {
//        val window = dialog.window ?: return
//        window.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
////        val dm = DisplayMetrics()
////        activity?.windowManager?.defaultDisplay?.getMetrics(dm)
//        dialog.setCanceledOnTouchOutside(false)
//        dialog.setCancelable(true)
//
////        window.navigationBarColor = Color.WHITE
//
//        val params = window.attributes ?: return
//        params.gravity = Gravity.BOTTOM
//        params.width = ViewGroup.LayoutParams.MATCH_PARENT
//        params.height = ViewGroup.LayoutParams.WRAP_CONTENT
//        window.attributes = params
//        window.setDimAmount(0F)
//        window.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_VISIBLE or WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN or WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE)
//    }


    private fun initView() {

        initEditText()

        val viewModel = mViewModel ?: return
        val mBinding = gBinding ?: return

        val target = viewModel.targetLanguageLiveData.value
        val source = viewModel.sourceLanguageLiveData.value
        sourceType = source?.toLanguageTag()
        targetType = target?.toLanguageTag()

        mBinding.viewModel = viewModel

//        //默认选中左边
//        isSelectedLeftTab = false
//        onTabSelectedLeft()
    }

    private fun initListener() {
        val mBinding = gBinding ?: return
        mBinding.tvTextTranslateSource.setOnClickListener(this)
        mBinding.tvTextTranslateTarget.setOnClickListener(this)
        mBinding.tvTextTranslate.setOnClickListener(this)
        mBinding.closeIvClick.setOnClickListener(this)
    }

    override fun onClick(v: View?) {
        when (v?.id) {
            // 源语言点击
            R.id.tv_text_translate_source -> {
                onTabSelectedLeft()

            }
            // 目标语言点击
            R.id.tv_text_translate_target -> {
                onTabSelectedRight()
            }
            // 翻译
            R.id.tv_text_translate -> {
                startTranslate()
            }
            //close
            R.id.close_iv_click -> {
                dismiss()
            }
        }
    }

    private fun onTabSelectedRight() {
        if (!isSelectedLeftTab) {
            return
        }
        isSelectedLeftTab = false
        showTranslationBtnName(targetInputStr, false)
    }

    private fun onTabSelectedLeft() {
        if (isSelectedLeftTab) {
            return
        }

        isSelectedLeftTab = true
        showTranslationBtnName(sourceInputStr, true)
    }


    /**
     * 开始翻译
     */

    private fun startTranslate() {
        val viewModel = mViewModel ?: return
        val context = mContext ?: return
        val mBinding = gBinding ?: return
        val txt = viewModel.editTextStr.trim()
        //网络状态
        if (!NetWorkUtil.getActiveNetworkConnected()) {
            Toast.makeText(context, R.string.main_net_error, Toast.LENGTH_SHORT).show()
            DataAnalysisHelper.logEvent(context, FA_keyboard_input_fail)
            return
        }
        if (txt.isBlank() || txt.isEmpty()) {
            mBinding.etTextTranslate.setText("")
            return
        }

        viewModel.isTextTranslate = true

        viewModel.editTextStr = ""

        //开始翻译中
        viewModel.startTranslateText(txt, isSelectedLeftTab)
        dismiss()
    }


    private fun getSourceLangType(): String? = if (isSelectedLeftTab) sourceType else targetType
    private fun getTargetLangType(): String? = if (!isSelectedLeftTab) sourceType else targetType


    private fun showTranslationBtnName(inputStr: String, isLeftTab: Boolean) {
        val mBinding = gBinding ?: return
        val context = mContext ?: return
        if (isLeftTab) {
            targetInputStr = mBinding.etTextTranslate.text.toString().trim()

            context.getColor(R.color.mol_face_input_dialog_tab_normal).let {
                mBinding.tvTextTranslateTarget.setTextColor(it)
            }
            context.getAttrColor(com.transsion.widgetslib.R.attr.os_platform_basic_color)?.let {
                mBinding.tvTextTranslateSource.setTextColor(it)
            }

        } else {
            sourceInputStr = mBinding.etTextTranslate.text.toString().trim()

            context.getColor(R.color.mol_face_input_dialog_tab_normal).let {
                mBinding.tvTextTranslateSource.setTextColor(it)
            }

            context.getAttrColor(com.transsion.widgetslib.R.attr.os_platform_basic_color)?.let {
                mBinding.tvTextTranslateTarget.setTextColor(it)
            }
        }

        mBinding.etTextTranslate.setText(inputStr)
        mBinding.etTextTranslate.setSelection(inputStr.length)

        mBinding.tvTextTranslate.text = R.string.v_translate.getString(context,getSourceLangType())
        mBinding.etTextTranslate.hint = R.string.v_enten_text.getString(context,getSourceLangType())
    }

    private var gBinding: MolDialogTextTranslateBinding? = null
    private var mViewModel: CommunicationViewModelV2? = null
    private var mContext: Context? = null
    private var navigationBarHeight = 0
    private var screenRealHeight = 0

    private fun clear() {
        gBinding = null
        mViewModel = null
        mContext = null
    }

    override fun show(
        context: Activity,
        inflater: LayoutInflater,
        viewGroup: ViewGroup,
        viewModel: CommunicationViewModelV2,
        defaultInputText: String,
        defaultSelection: Int,
        defaultKeyboardShown: Boolean,
        defaultSelectLeft: Boolean
    ) {

        gBinding = MolDialogTextTranslateBinding.inflate(inflater)
        val binding = gBinding ?: return
        mContext = context
        mViewModel = viewModel
        if (navigationBarHeight == 0) {
            navigationBarHeight = context.getNavigationBarHeight()
        }
        if (screenRealHeight == 0) {
            screenRealHeight = context.getScreenRealHeight()
        }

        val layoutParams = ConstraintLayout.LayoutParams(
            ConstraintLayout.LayoutParams.MATCH_PARENT,
            ConstraintLayout.LayoutParams.WRAP_CONTENT
        )

        // CUT: 2022/11/2 折叠屏适配
        val windowSizeClass = FoldUtils.computeWindowSizeClasses(context)

        windowSizeClass.also {
            if (windowSizeClass != WindowSizeClass.COMPACT) {
                val dp100Float =
                    context?.resources?.getDimension(com.talpa.lib.language.R.dimen.ld_dialog_margin_hor)
                        ?: dp2px(100F)
                layoutParams.setMargins(dp100Float.toInt(), 0, dp100Float.toInt(), 0)
            }
        }

        viewGroup.removeAllViews()
        viewGroup.addView(binding.root, layoutParams)

        onViewCreated(null)

        if (defaultInputText.isNotEmpty()) {
            shown(binding.root, defaultKeyboardShown, defaultSelectLeft)

            binding.etTextTranslate.setText(defaultInputText)
            binding.etTextTranslate.setSelection(defaultSelection)
        } else {
            showAnimation(binding.root, defaultKeyboardShown, defaultSelectLeft)
        }

        keyboardIsActive = defaultKeyboardShown
    }

    private fun shown(view: View, defaultKeyboardShown: Boolean, defaultSelectLeft: Boolean) {
        mViewModel?.showInputDialog()
        view.visibility = View.VISIBLE

        gBinding?.etTextTranslate?.let {
            if (defaultKeyboardShown) {
                showKeyboard(it)
            } else {
                hideKeyboard(it)
            }
        }


        if (defaultSelectLeft) {
            //默认选中左边
            isSelectedLeftTab = false
            onTabSelectedLeft()
        } else {
            //默认选中右边
            isSelectedLeftTab = true
            onTabSelectedRight()
        }

    }


    override fun isShowing(): Boolean {
        return gBinding?.root?.isVisible == true
    }

    override fun inputText(): String {
        return gBinding?.etTextTranslate?.text?.toString() ?: ""
    }

    override fun inputSelection(): Int {
        return gBinding?.etTextTranslate?.selectionEnd ?: 0
    }

    override fun isKeyboardShown(): Boolean {
        return isActive()
    }

    override fun isSelectLeft(): Boolean {
        return isSelectedLeftTab
    }

    private fun showKeyboard(view: View) {
        Log.v("Sky", "showKeyboard:")
        val imm: InputMethodManager = view.context
            .getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager? ?: return
        view.requestFocus()
        imm.showSoftInput(view, 0)
    }

    private fun isActive(): Boolean {

        gBinding?.root?.let {
            val r = Rect()
            it.getGlobalVisibleRect(r)
            val screenHeight = screenRealHeight
            val navigationHeight = max(navigationBarHeight, 72)
            val isShow = screenHeight - r.bottom > navigationHeight
            Log.v(
                "Sky",
                "isActive, it.bottom :${r.bottom} , screenHeight:$screenHeight, (${screenHeight - r.bottom}), navigationHeight:$navigationHeight, isShow:$isShow"
            )
            return isShow
        }
        return false
    }

    private fun hideKeyboard(view: View) {
        Log.v("Sky", "hideKeyboard:")
        val imm: InputMethodManager = view.context
            .getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager? ?: return
        imm.hideSoftInputFromWindow(view.windowToken, 0)
    }

    private var mInputLayoutHeight = 0F

    private fun showAnimation(
        view: View,
        defaultKeyboardShown: Boolean,
        defaultSelectLeft: Boolean
    ) {
        if (mInputLayoutHeight == 0F) {
            mInputLayoutHeight =
                dp2px(355F)//从布局中计算得来.
        }

        var fromY = if (mInputLayoutHeight > 0F) mInputLayoutHeight else dp2px(355F)
        if (view.translationY != 0F) {
            fromY = view.translationY
        }

        view.clearAnimation()
        ObjectAnimator.ofFloat(view, "translationY", fromY, 0F).apply {
            duration = ANIMATION_DURATION_INPUT_LAYOUT / 2
            addListener(object : Animator.AnimatorListener {
                override fun onAnimationStart(animation: Animator) {
                    shown(view, defaultKeyboardShown, defaultSelectLeft)
                }

                override fun onAnimationEnd(animation: Animator) {
                }

                override fun onAnimationCancel(animation: Animator) {
                }

                override fun onAnimationRepeat(animation: Animator) {
                }
            })
            start()
        }

    }


    private fun hideAnimation(view: View) {

        if (mInputLayoutHeight == 0F) {
            mInputLayoutHeight = dp2px(355F)//max(view.measuredHeight.toFloat(), mInputLayoutHeight)
        }

        val fromY = if (mInputLayoutHeight > 0F) mInputLayoutHeight else dp2px(355F)

        view.clearAnimation()

        ObjectAnimator.ofFloat(view, "translationY", view.translationY, fromY).apply {
            duration = ANIMATION_DURATION_INPUT_LAYOUT
            addListener(object : Animator.AnimatorListener {
                override fun onAnimationStart(animation: Animator) {

                }

                override fun onAnimationEnd(animation: Animator) {
                    view.visibility = View.GONE
                    mViewModel?.hideInputDialog()
                    clear()
                }

                override fun onAnimationCancel(animation: Animator) {
                    view.visibility = View.GONE
                    mViewModel?.hideInputDialog()
                    clear()
                }

                override fun onAnimationRepeat(animation: Animator) {
                }
            })
            start()
        }
    }
}


private fun Activity.isNavigationBarShow(): Boolean {
    try {
        val display: Display = windowManager.defaultDisplay
        val size = Point()
        val realSize = Point()
        display.getSize(size)
        display.getRealSize(realSize)
        return realSize.y != size.y
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return false
}

private fun Context.isGestureNavigationBarOn(): Boolean {
    return Settings.Secure.getInt(contentResolver, "navigation_mode", 0) == 2
}

private fun Activity.getNavigationBarHeight(): Int {
    try {
        if (Build.MODEL.contains("AD8", false) || Build.MODEL.contains("AD9", false)) {
            if (isGestureNavigationBarOn()) {
                return 0
            }
        } else {
            if (!isNavigationBarShow()) {
                return 0
            }
        }
        val resourceId = resources.getIdentifier(
            "navigation_bar_height",
            "dimen", "android"
        )
        //获取NavigationBar的高度
        return resources.getDimensionPixelSize(resourceId)
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return 128
}

private fun Activity.getScreenRealHeight(): Int {
    try {

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
            val rect = windowManager.currentWindowMetrics.bounds
            return rect.height()
        }

        val display: Display = windowManager.defaultDisplay
        val realSize = Point()
        display.getRealSize(realSize)
        return realSize.y
    } catch (e: Exception) {
        e.printStackTrace()
    }
    if (Build.MODEL.contains("AD8", false) || Build.MODEL.contains("AD9", false)) {
        return 2460
    }
    return 1280
}

