package com.talpa.master.ui.main.v2

import android.app.Application
import android.widget.Toast
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.viewModelScope
import com.talpa.datareport.report.DataAnalysisHelper
import com.talpa.datareport.report.FA_result_Voice_broadcast
import com.talpa.datareport.report.FA_result_collect
import com.talpa.datareport.report.FA_result_copy
import com.talpa.master.R
import com.talpa.master.framework.RoomHelper
import com.talpa.master.repository.room.model.History
import com.talpa.master.ui.main.MainViewModel
import com.talpa.master.utils.event.Event
import com.talpa.translate.face.TranslateService
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

class CommunicationViewModelV2(private val ctx: Application) : MainViewModel(ctx) {

    val timeCount = MutableLiveData<String>()

    val enlargeDialogLiveData = MutableLiveData<Event<History>>()


    private val listHistory = MutableLiveData<List<History>>()
    private val map = HashMap<Int, Boolean>()
    val updateListEnlarge = MutableLiveData<Pair<Int, Int>>()
    val checkStopLiveData = MutableLiveData<Event<Boolean>>()


    fun itemCollect(info: History, position: Int) {
        info.isStartMarker = !info.isStartMarker

        viewModelScope.launch {
            withContext(Dispatchers.Main) {
                listHistory.value?.forEach {
                    if (it.id == info.id) {
                        it.isStartMarker = info.isStartMarker
                    }
                }
            }

            if (info.isStartMarker) {
                info.end_mills = System.currentTimeMillis()
                Toast.makeText(ctx, R.string.collected_toast_translation, Toast.LENGTH_SHORT)
                    .show()
            } else {
                info.end_mills = 0L
                Toast.makeText(ctx, R.string.uncollected_toast_translation, Toast.LENGTH_SHORT)
                    .show()
            }

            DataAnalysisHelper.logEvent(ctx, FA_result_collect)

            withContext(Dispatchers.IO) {
                RoomHelper.historyDao.updateStarModel(info)
            }
        }
    }

    fun itemCopy(info: History, position: Int) {
        copy(null, info.target_result)
        DataAnalysisHelper.logEvent(ctx, FA_result_copy)
    }

    fun itemEnlarge(info: History, position: Int) {
        stopTranslateVoice()
        enlargeDialogLiveData.value = Event(info)
    }

    fun itemPlay(info: History, position: Int) {

        viewModelScope.launch(Dispatchers.IO) {
            if (currentPlayClickIndex != position && TranslateService.Companion.getInstance().isSpeaking()) {
                stopTranslateVoice()
            }
            checkStopRecord()
            playTranslateVoice(info, position)
            DataAnalysisHelper.logEvent(ctx, FA_result_Voice_broadcast)
        }

    }

    private fun checkStopRecord() {
        checkStopLiveData.postValue(Event(true))
    }

    fun enlarge(history: History, isEnlarge: Boolean) {
        updateListEnlarge.value = Pair(0, 0)
        map.clear()
        map[history.id] = isEnlarge
    }

    fun isEnlarge(it: History): Boolean {
        return map[it.id] ?: false
    }

    override fun onCleared() {
        super.onCleared()
        map.clear()
    }


    val txtTranslateLiveData = MutableLiveData<Event<Pair<String, Boolean>>>()

    fun startTranslateText(txt: String, isLeft: Boolean) {
        txtTranslateLiveData.postValue(Event(Pair(txt, isLeft)))
    }

    private val _hideInputDialogLiveData = MutableLiveData<Event<Boolean>>()
    val hideInputDialogLiveData : LiveData<Event<Boolean>> = _hideInputDialogLiveData
    fun hideInputDialog() {
        _hideInputDialogLiveData.value = Event(true)
    }

    fun showInputDialog() {
        _hideInputDialogLiveData.value = Event(false)
    }
}