package com.talpa.master.ui.main.v2

import android.util.Log
import android.view.View
import com.talpa.master.R
import com.talpa.master.common.Constant
import com.talpa.master.common.getString
import com.talpa.master.databinding.MolItemConversationLeftSayingBinding
import com.talpa.master.repository.room.model.History
import com.talpa.master.ui.main.CommunicationActivityV2
import java.util.*

class ConversationLeftSayingHolder(private val binding: MolItemConversationLeftSayingBinding) :
    ConversationHolder(binding) {
    override fun bind(itemData: History?, position: Int) {

    }

    override fun bindCount(timeCount: Int) {

        val txt = "( ${timeCount}s )"

        Log.i(CommunicationActivityV2.TAG, "bindCount: timeCount:$txt")

        binding.molFaceDestText.visibility = View.GONE
        binding.molFaceLine.visibility = View.GONE

        binding.viewModel?.timeCount?.value = txt
        binding.molFaceCountDown.text = txt
        binding.molFaceCountDown.visibility = View.VISIBLE

        var key = binding.viewModel?.sourceLanguageLiveData?.value?.toLanguageTag()
        if (key.isNullOrEmpty()) {
            key = Locale.getDefault().toLanguageTag()
        }
        val value = R.string.v_listen.getString(binding.root.context, key)
        val text = if (value.isNullOrEmpty()) "" else "$value..."
        binding.molFaceIWantSaying.text = text
    }

    override fun recordTipMessage(contentMsg:String?, tipMessage: String?) {
        Log.i(CommunicationActivityV2.TAG, "recordError, left, contentMsg:$contentMsg, tipMessage:$tipMessage")
        binding.molFaceCountDown.visibility = View.GONE
        if (tipMessage.isNullOrEmpty() || contentMsg.isNullOrEmpty()) {
            binding.molFaceDestText.visibility = View.GONE
            binding.molFaceLine.visibility = View.GONE

            binding.molFaceIWantSaying.text = contentMsg ?: (tipMessage ?: "")
        } else {
            binding.molFaceIWantSaying.text = contentMsg

            binding.molFaceDestText.text = tipMessage
            binding.molFaceDestText.visibility = View.VISIBLE
            binding.molFaceLine.visibility = View.VISIBLE
        }
    }

}