package com.talpa.master.ui.main.v2

import android.graphics.drawable.AnimationDrawable
import android.view.View
import com.talpa.master.R
import com.talpa.master.databinding.MolItemConversationRightTextBinding
import com.talpa.master.repository.room.model.History
import com.talpa.master.ui.main.MainViewModel

class ConversationRightHolder(private val binding: MolItemConversationRightTextBinding) :
    ConversationHolder(binding) {
    override fun bind(itemData: History?, position: Int) {
        itemData?.let { info ->
            binding.apply {
                molFaceSourceText.text = info.source_result
                molFaceDestText.text = info.target_result
                updateCollect(info)

                //
                if (viewModel?.isEnlarge(info) == true) {
                    binding.molFaceControlGroup.visibility = View.VISIBLE
                } else {
                    binding.molFaceControlGroup.visibility = View.GONE
                }

                binding.root.setOnClickListener {
                    if (binding.molFaceControlGroup.visibility == View.VISIBLE) {
                        binding.molFaceControlGroup.visibility = View.GONE
                        viewModel?.enlarge(info, false)
                    } else {
                        binding.molFaceControlGroup.visibility = View.VISIBLE
                        viewModel?.enlarge(info, true)
                    }
                }


                if (info.isVoicePlay) {
                    molFacePlayIcon.visibility = View.VISIBLE
                    molFacePlayIconClick.visibility = View.VISIBLE
                } else {
                    molFacePlayIcon.visibility = View.GONE
                    molFacePlayIconClick.visibility = View.GONE
                }


                molFaceCollectIconClick.setOnClickListener {
                    viewModel?.itemCollect(info, position)
                    updateCollect(info)
                }
                molFaceCopyIconClick.setOnClickListener {
                    viewModel?.itemCopy(info, position)
                }
                molFaceEnlargeIconClick.setOnClickListener {
                    viewModel?.itemEnlarge(info, position)
                }
                molFacePlayIconClick.setOnClickListener {
                    viewModel?.itemPlay(info, position)
                }

                if (position == viewModel?.currentPlayClickIndex ?: -1) {
                    when (viewModel?.voicePlayStatusV2?.value?.peekContent()) {
                        MainViewModel.VoicePlayStatus.START -> {
                            molFacePlayIcon.setImageResource(R.drawable.mol_voice_start_anim_black)
                            (molFacePlayIcon.drawable as AnimationDrawable).start()
                        }
                        else -> {
                            molFacePlayIcon.setImageResource(R.drawable.mol_face_right_play_normal)
                        }
                    }
                } else {
                    molFacePlayIcon.setImageResource(R.drawable.mol_face_right_play_normal)
                }

            }
        }
    }

    private fun MolItemConversationRightTextBinding.updateCollect(info: History) {
        if (info.isStartMarker) {
            molFaceCollectIcon.setImageResource(R.drawable.mol_face_collected_right_icon)
        } else {
            molFaceCollectIcon.setImageResource(R.drawable.mol_face_collect_right_icon)
        }
    }
}