package com.talpa.master.ui.main.v2

import android.content.Context
import com.talpa.master.R
import com.talpa.master.common.Constant
import com.talpa.master.common.getString
import com.talpa.master.framework.RoomHelper
import com.talpa.master.repository.room.model.History
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import java.util.*

/**
 * @author skycar
 * @Date 2022/5/10
 *
 * 欢迎使用语言大师，点击上方按钮切换语种。
Welcome to MOL, click to button above to switch languages.
点击底部按钮开始说话。
Press the button to speak.
 */
class GuideUtil {

    companion object {
        const val LEFT_GUIDE_PID = Int.MAX_VALUE
        const val RIGHT_GUIDE_PID = Int.MAX_VALUE - 1
    }

    var leftGuide: History? = null
    var rightGuide: History? = null

    suspend fun initGuide(context:Context, srcCode: String, dstCode: String, appName: String) =
        withContext(Dispatchers.IO) {
            RoomHelper.historyDao.queryGuideByPid(LEFT_GUIDE_PID)?.apply {
                leftGuide = this
            }
            RoomHelper.historyDao.queryGuideByPid(RIGHT_GUIDE_PID)?.apply {
                rightGuide = this
            }
            if (null == leftGuide) {
                initLeft(context, srcCode, dstCode, appName)
            }
            if (null == rightGuide) {
                initRight(context,srcCode, dstCode)
            }
        }

    private fun initRight(context:Context,srcCode: String, dstCode: String) {
        val srcStringTip2 =
            R.string.v_guide_tip2.getString(context, srcCode, "Press the button below to speak.")
        val dstStringTip2 =
            R.string.v_guide_tip2.getString(context, dstCode, "Rääkimiseks vajutage allolevat nuppu.")
        History(
            source_result = srcStringTip2,
            target_result = dstStringTip2,
            display_type = 1,
            mills = 2,
            end_mills = 2,
            sourcelanguage_tag = srcCode,
            sourcelanguage_name = Locale.forLanguageTag(srcCode).displayName,
            targetlanguage_tag = dstCode,
            targetlanguage_name = Locale.forLanguageTag(dstCode).displayName,
            isStartMarker = false,
            isVoicePlay = true,
            pid = RIGHT_GUIDE_PID
        ).apply {
            RoomHelper.historyDao.insert(this)
            RoomHelper.historyDao.queryGuideByPid(RIGHT_GUIDE_PID)?.apply {
                rightGuide = this
            }
        }
    }

    private fun initLeft(context:Context,srcCode: String, dstCode: String, appName: String) {
        val srcStringTip1 = R.string.v_guide_tip1.getString(context,
            srcCode,
            "Welcome to *, click to button above to switch languages.",
            formatString = appName
        )
        val dstStringTip1 = R.string.v_guide_tip1.getString(context,
            dstCode,
            "Tere tulemast *! Keelte vahetamiseks klõpsake ülaloleval nupul.",
            formatString = appName
        )

        History(
            source_result = srcStringTip1.replace("*", appName),
            target_result = dstStringTip1.replace("*", appName),
            display_type = 0,
            mills = 1,
            end_mills = 1,
            sourcelanguage_tag = srcCode,
            sourcelanguage_name = Locale.forLanguageTag(srcCode).displayName,
            targetlanguage_tag = dstCode,
            targetlanguage_name = Locale.forLanguageTag(dstCode).displayName,
            isStartMarker = false,
            isVoicePlay = true,
            pid = LEFT_GUIDE_PID
        ).apply {
            RoomHelper.historyDao.insert(this)
            RoomHelper.historyDao.queryGuideByPid(LEFT_GUIDE_PID)?.apply {
                leftGuide = this
            }
        }
    }
}