package com.talpa.master.ui.mark

import android.app.Activity
import android.content.Intent
import android.content.pm.ActivityInfo
import android.media.AudioManager
import android.util.Log
import android.view.View
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.AppCompatImageView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.view.updateLayoutParams
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.SimpleItemAnimator
import com.airbnb.lottie.LottieAnimationView
import com.airbnb.lottie.LottieDrawable
import com.blankj.utilcode.util.SizeUtils
import com.talpa.lib.language.util.FoldUtils
import com.talpa.master.R
import com.talpa.master.common.Constant
import com.talpa.master.common.Constant.STARMARK_LIST
import com.talpa.master.databinding.DataBindingActivity
import com.talpa.master.databinding.MolActivityStarMarkBinding
import com.talpa.master.ui.history.HistoryAdapter
import com.talpa.master.ui.history.HistoryViewModel
import com.talpa.master.ui.main.CommunicationActivity
import com.talpa.master.ui.main.MainViewModel
import com.talpa.master.ui.main.v2.TranslateEnlargeActivity
import com.talpa.master.utils.AppUtil
import com.talpa.translate.face.TranslateService
import com.transsion.effectengine.bounceeffect.OverScrollDecorHelper
import kotlinx.coroutines.launch

class StarMarkActivity : DataBindingActivity<MolActivityStarMarkBinding>() {

    private val viewModel: HistoryViewModel by lazy {
        ViewModelProvider(
            this@StarMarkActivity,
            HistoryViewModel.factory()
        )[HistoryViewModel::class.java]
    }
    private var mAudioManger: AudioManager? = null
    private var afChangeListener: AudioManager.OnAudioFocusChangeListener? = null

    private var mHistoryAdapter :HistoryAdapter? = null

    override fun getContentView(): Int = R.layout.mol_activity_star_mark

    override fun skipOrientation(): Boolean {
        // 中等宽度 以上的 屏幕
        if (FoldUtils.isTabletType(this)) {
            // CUT: 2022/11/10 设计文稿 不区分横竖屏,测试让适配横竖屏
            requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_FULL_USER
        } else {
            requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_PORTRAIT
        }

        return true
    }

    override fun initView() {
        setSupportActionBar(mBinding.toolBar)
        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        supportActionBar?.setDisplayShowTitleEnabled(false)
        mBinding.toolBar.setNavigationOnClickListener {
            backToIsStartMark()
            finish()
        }
        mBinding.toolBar.navigationContentDescription = null

        (mBinding.rvMark.itemAnimator as SimpleItemAnimator).supportsChangeAnimations = false
        val historyId = intent.getStringExtra(Constant.HISTORY_ID)
        historyId?.let { viewModel.translateHistoryId = it }
        mBinding.rvMark.layoutManager = LinearLayoutManager(this)
        mBinding.rvMark.adapter = HistoryAdapter(viewModel, STARMARK_LIST).apply {
            mHistoryAdapter = this
        }
        mBinding.rvMark.addItemDecoration(HistoryAdapter.SpaceItemDecoration(SizeUtils.dp2px(16F)))
        OverScrollDecorHelper.setUpOverScroll(mBinding.rvMark, OverScrollDecorHelper.ORIENTATION_VERTICAL)

        val darkTheme = AppUtil.isDarkTheme(applicationContext)
        viewModel.isDark.postValue(darkTheme)
        viewModel.registerCall()
        initOnAudioFocus()


        // 切换暗黑模式暂停播放
        viewModel.voicePlayStatus.value = MainViewModel.VoicePlayStatus.END
        lifecycleScope.launch {
            TranslateService.Companion.getInstance().stopSpeak()
        }

        viewModel.enlargeDialogLiveData.observe(this, Observer {event->
            val it = event.getContentIfNotHandled() ?: return@Observer
            TranslateEnlargeActivity.launch(this, it.target_result, it.targetlanguage_tag)

//            val instance = TranslateResultFragment.getInstance(
//                it.id.toString().trim()
//            )
//            instance
//                .show(supportFragmentManager, TranslateResultFragment.TAG)
//            instance.setOnDismissListener(object :
//                TranslateResultFragment.OnDismissListener {
//                override fun onDismiss(isBack: Boolean) {
//                    Log.d(CommunicationActivity.TAG, "onDismiss: ${isBack}")
//                    viewModel.registerCall()
//                    initOnAudioFocus()
//                }
//            })
        })
        viewModel.updateListEnlarge.observe(this, Observer {
            it?.let {
                mHistoryAdapter?.notifyDataSetChanged()
            }
        })

    }

    private fun initOnAudioFocus() {
        mAudioManger = this.getSystemService(AppCompatActivity.AUDIO_SERVICE) as AudioManager
        afChangeListener = AudioManager.OnAudioFocusChangeListener { focusChange ->
            when (focusChange) {
                AudioManager.AUDIOFOCUS_LOSS_TRANSIENT -> {
                    // Pause playback
                    Log.d(CommunicationActivity.TAG, "init: 音頻焦點————AUDIOFOCUS_LOSS_TRANSIENT")
                    viewModel.stopTranslateVoice()
                }
            }
        }
        mAudioManger!!.requestAudioFocus(
            afChangeListener,
            AudioManager.STREAM_MUSIC,
            AudioManager.AUDIOFOCUS_GAIN
        )
    }

    override fun init() {
        mBinding.viewModel = viewModel
        viewModel.selectHistoryByMark()
        viewModel.historys.observe(this, Observer {
            if (it.size == 0) {
                mBinding.root.findViewById<ConstraintLayout>(R.id.cl_empty).visibility =
                    View.VISIBLE
                mBinding.rvMark.visibility = View.GONE
            } else {
                if (mBinding.rvMark.visibility == View.GONE) {
                    mBinding.rvMark.visibility = View.VISIBLE
                    mBinding.root.findViewById<ConstraintLayout>(R.id.cl_empty).visibility =
                        View.GONE
                }
                mBinding.rvMark.adapter?.notifyDataSetChanged()
            }
        })


        viewModel.voicePlayStatus.observe(this, Observer{
            viewModel.currentPlayStatus = it
            if (viewModel.lastPlayIndex == viewModel.currentPlayClickIndex) {
                mBinding.rvMark.adapter?.notifyItemChanged(viewModel.currentPlayClickIndex)
            } else {
                mBinding.rvMark.adapter?.notifyItemChanged(viewModel.lastPlayIndex)
                mBinding.rvMark.adapter?.notifyItemChanged(viewModel.currentPlayClickIndex)
            }
        })


        viewModel.isDark.observe(this,Observer {

            val imageView = mBinding.root.findViewById<LottieAnimationView>(R.id.no_image)
            val textView = mBinding.root.findViewById<TextView>(R.id.no_text)

            val isHiOS = AppUtil.isHiOS()


            var folder = "favorites"

            folder = if (isHiOS) {
                "$folder/hios"
            } else {
                "$folder/xos"
            }

            if (it) {
                folder = "$folder/dark"
                textView.setTextColor(resources.getColor(R.color.text_color_dark))
            } else {
                folder = "$folder/light"
                textView.setTextColor(resources.getColor(R.color.text_color_light))
            }

            imageView.cancelAnimation()
            imageView.imageAssetsFolder = "$folder/images"
            imageView.setAnimation("$folder/data.json")
            imageView.repeatCount = LottieDrawable.INFINITE
            imageView.repeatMode = LottieDrawable.RESTART
            imageView.playAnimation()

            if (isHiOS) {
                imageView.updateLayoutParams {
                    width = resources.getDimension(R.dimen.face_favorites_empty_lottie_hios_width).toInt()
                    height = resources.getDimension(R.dimen.face_favorites_empty_lottie_hios_height).toInt()
                }

            } else {
                imageView.updateLayoutParams {
                    width = resources.getDimension(R.dimen.face_favorites_empty_lottie_xos_width).toInt()
                    height = resources.getDimension(R.dimen.face_favorites_empty_lottie_xos_height).toInt()
                }
            }

        })
    }


    // 退到后台或者息屏停止播放
    override fun onPause() {
        super.onPause()
        viewModel.currentPlayStatus = MainViewModel.VoicePlayStatus.END
        mBinding.rvMark.adapter?.notifyItemChanged(viewModel.currentPlayClickIndex)
        lifecycleScope.launch {
            TranslateService.Companion.getInstance().stopSpeak()
        }
    }


    override fun onBackPressed() {
        backToIsStartMark()
        viewModel.unregisterCall()
        super.onBackPressed()
    }

    override fun onDestroy() {
        viewModel.unregisterCall()
        mAudioManger?.abandonAudioFocus(afChangeListener)
        super.onDestroy()
    }


    // 返回
    fun backToIsStartMark() {
        val resultIntent = Intent()
        resultIntent.putExtra(Constant.IS_STAR_MARK, viewModel.isStarMark)
        setResult(Activity.RESULT_OK, resultIntent)
        lifecycleScope.launch {
            TranslateService.Companion.getInstance().stopSpeak()
        }
    }


}