package com.talpa.master.utils

import android.R
import android.app.Activity
import android.content.Context
import android.content.pm.PackageManager
import android.content.res.Configuration
import android.media.AudioFormat
import android.media.AudioRecord
import android.media.MediaRecorder
import android.telephony.TelephonyManager
import android.text.TextUtils
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.core.os.LocaleListCompat
import com.talpa.master.MoLContentProvider
import com.talpa.translate.face.common.getOrderedLanguageList
import java.util.*


/**
 * Create by kgxl on 2021/4/5
 */
object AppUtil {

    // 是否是暗黑模式
    fun isDarkTheme(context: Context): Boolean {
        val flag = context.resources.configuration.uiMode and Configuration.UI_MODE_NIGHT_MASK
        return flag == Configuration.UI_MODE_NIGHT_YES
    }


    fun getLocaleListCompat(vararg languages: String): LocaleListCompat {
        val supportList = StringBuilder()
            .also { builder ->
                languages.forEach {
                    builder.append(it)
                    builder.append(",")
                }
            }.toString()
        return LocaleListCompat.forLanguageTags(
            getOrderedLanguageList(
                Locale.getDefault().language,
                supportList
            )
        )

    }

    //根据包名判断是否安装
    fun checkApkExist(context: Context, packageName: String): Boolean {
        //  检查app是否有安装
        if (TextUtils.isEmpty(packageName))
            return false
        try {
            val info = context.packageManager
                .getApplicationInfo(
                    packageName,
                    PackageManager.GET_UNINSTALLED_PACKAGES
                )
            return true
        } catch (e: PackageManager.NameNotFoundException) {
            return false
        }

    }

    fun isNavigationBarShown(activity: Activity): Boolean {
        //虚拟键的view,为空或者不可见时是隐藏状态
        val view: View = activity.findViewById(R.id.navigationBarBackground) ?: return false
        val visible: Int = view.getVisibility()
        return if (visible == View.GONE || visible == View.INVISIBLE) {
            false
        } else {
            true
        }
    }

     fun validateMicAvailability(): Boolean {
        var available = true
        var recorder: AudioRecord? = AudioRecord(
            MediaRecorder.AudioSource.MIC, 44100,
            AudioFormat.CHANNEL_IN_MONO,
            AudioFormat.ENCODING_DEFAULT, 44100
        )
        try {
            if (recorder!!.recordingState != AudioRecord.RECORDSTATE_STOPPED) {
                available = false
            }
            recorder.startRecording()
            if (recorder.recordingState != AudioRecord.RECORDSTATE_RECORDING) {
                recorder.stop()
                available = false
            }
            recorder.stop()
        } finally {
            recorder!!.release()
            recorder = null
        }
        return available
    }

    /**
     * 是否正在通话
     */
     fun phoneIsInUses(): Boolean {

        val packageManager = MoLContentProvider.mApplicationContext.packageManager

        if (!packageManager.hasSystemFeature(PackageManager.FEATURE_TELEPHONY)) {
            return false
        }

        val mTelephonyManager = MoLContentProvider.mApplicationContext.getSystemService(AppCompatActivity.TELEPHONY_SERVICE) as TelephonyManager
        val state = mTelephonyManager.callState
        return state != TelephonyManager.CALL_STATE_IDLE
    }


    fun getOsType(): String? {
        var value: String? = null
        try {
            val cls = Class.forName("android.os.SystemProperties")
            val getMethod = cls.getMethod("get", String::class.java)
            value = getMethod.invoke(cls, "ro.tranos.type") as String
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return value
    }

    fun isHiOS():Boolean {
        val osType: String? = getOsType()
        return osType.equals("hios")
    }



}