package com.talpa.master.utils

import android.text.InputFilter
import android.text.Spanned

class MaxLengthFilter(maxLength: Int, private val callback: ILengthFilter? = null) :
    InputFilter.LengthFilter(maxLength) {
    override fun filter(
        source: CharSequence?,
        start: Int,
        end: Int,
        dest: Spanned?,
        dstart: Int,
        dend: Int
    ): CharSequence? {
        val result = super.filter(source, start, end, dest, dstart, dend)
        if (null != result) {
            callback?.onChange()
        }
        return result
    }
}

interface ILengthFilter {
    fun onChange()
}