package com.talpa.master.utils

import android.content.Context
import android.content.SharedPreferences
import com.talpa.master.MoLContentProvider

object SharedPreferenceHelper {
    const val IS_FIRST_OPEN = "is_first_open"       //第一次使用
    const val IS_CHANGE_LANGUAGE = "is_change_language"     //系统语言是否改变

    private fun getSharedPreferences(): SharedPreferences {
        return MoLContentProvider.mApplicationContext.getSharedPreferences(
            "com.talpa.master",
            Context.MODE_PRIVATE
        )
    }

    fun putIntValue(key: String, value: Int) {
        val sharedPreferences = getSharedPreferences()
        sharedPreferences.edit().putInt(key, value).apply()
    }

    fun getIntValue(key: String, defaultValue: Int): Int {
        val sharedPreferences = getSharedPreferences()
        return sharedPreferences.getInt(key, defaultValue)
    }

    fun getBooleanValue(key: String, defaultValue: Boolean): Boolean {
        val sharedPreferences = getSharedPreferences()
        return sharedPreferences.getBoolean(key, defaultValue)
    }

    fun putBooleanValue(key: String, value: Boolean) {
        val sharedPreferences = getSharedPreferences()
        sharedPreferences.edit().putBoolean(key, value).apply()
    }

    fun getStringValue(key: String, defaultValue: String): String {
        val sharedPreferences = getSharedPreferences()
        return sharedPreferences.getString(key, defaultValue)!!
    }

    fun putStringValue(key: String, value: String) {
        val sharedPreferences = getSharedPreferences()
        sharedPreferences.edit().putString(key, value).apply()
    }

    fun putLongValue(key: String, value: Long) {
        val sharedPreferences = getSharedPreferences()
        sharedPreferences.edit().putLong(key, value).apply()
    }

    fun getLongValue(key: String, defaultValue: Long): Long {
        val sharedPreferences = getSharedPreferences()
        return sharedPreferences.getLong(key, defaultValue)
    }


}