package com.talpa.master.utils

import android.graphics.Outline
import android.graphics.Rect
import android.view.View
import android.view.ViewOutlineProvider
import kotlin.math.ceil
import kotlin.math.floor

class ViewOutlineProviderImpl(private val mRadius: Float, private val mCurrentType: Int = DEFAULT) :
    ViewOutlineProvider() {
    companion object {
        private const val DEFAULT = 0
        private const val LEFT = 1
        private const val RIGHT = 2
        private const val TOP = 3
        private const val BOTTOM = 4
    }


    override fun getOutline(view: View, outline: Outline) {
        val rect = Rect()
        view.getGlobalVisibleRect(rect)
        val leftMargin = 0
        val topMargin = 0
        val width = view.measuredWidth
        val height = view.measuredHeight
        val selfRect: Rect = when (mCurrentType) {
            LEFT -> {
                Rect(
                    leftMargin, topMargin,
                    ceil((width + 2 * mRadius).toDouble()).toInt(),
                    height
                )
            }
            RIGHT -> {
                Rect(
                    floor((-2 * mRadius).toDouble()).toInt(), topMargin,
                    width,
                    height
                )
            }
            TOP -> {
                Rect(
                    0, topMargin,
                    width,
                    ceil((height + 2 * mRadius).toDouble()).toInt()
                )
            }
            BOTTOM -> {
                Rect(
                    0, floor((-2 * mRadius).toDouble()).toInt(),
                    width,
                    height
                )
            }
            else -> {
                Rect(
                    leftMargin, topMargin,
                    width,
                    height
                )
            }
        }
        outline.setRoundRect(selfRect, mRadius)
    }

}