package com.talpa.master.widget

import android.content.Context
import android.util.AttributeSet
import android.view.GestureDetector
import android.view.MotionEvent
import android.view.View
import androidx.appcompat.widget.AppCompatImageView
import com.talpa.translate.face.common.Logcat


/**
 * Create by kgxl on 2021/4/13
 * 长按与点击的处理
 */
class RecordImageView(context: Context, attrs: AttributeSet?) :
    AppCompatImageView(context, attrs), View.OnTouchListener {
    private var mDetector: GestureDetector
    private var mGesture: RecordGesture
    private lateinit var onRecordListener: OnRecordListener

    init {
        mGesture = RecordGesture()
        mDetector = GestureDetector(context, mGesture)
        setOnTouchListener(this)
    }

    fun setOnRecordListener(onRecordListener: OnRecordListener) {
        this.onRecordListener = onRecordListener
        mGesture?.setOnRecordListener(onRecordListener, this)
    }

    interface OnRecordListener {
        fun onRecordClick(v: View)
        fun onRecordLongClick(v: View)
        fun onEventUp(v: View)
    }

    class RecordGesture : GestureDetector.SimpleOnGestureListener() {
        private lateinit var mOnRecordListener: OnRecordListener
        private lateinit var v: View
        private var lastClickTime = 0L
        fun setOnRecordListener(onRecordListener: OnRecordListener, v: View) {
            this.mOnRecordListener = onRecordListener
            this.v = v
        }

        // 单击点击
        override fun onSingleTapUp(e: MotionEvent): Boolean {
            Logcat.d("TAG", "onSingleTapUp => "+e?.action)
            if (e != null) {
                when (e.action) {
                    MotionEvent.ACTION_UP -> {
                        if (lastClickTime == 0L) {
                            lastClickTime = e.downTime
                        } else {
                            if (e.downTime - lastClickTime < 1000) {
                                lastClickTime = e.downTime
                                Logcat.d("TAG", "小于1000")
                                return false
                            } else {
                                Logcat.d("TAG", "大于1000")
                                lastClickTime = e.downTime
                            }
                        }
                    }
                }
            }
            mOnRecordListener.onRecordClick(v)
            return super.onSingleTapUp(e)
        }

        // 长按
        override fun onLongPress(e: MotionEvent) {
            mOnRecordListener.onRecordLongClick(v)
        }
    }

    override fun onTouch(v: View, event: MotionEvent): Boolean {
        if (onRecordListener != null) {
            if (event.action == MotionEvent.ACTION_UP) {
                onRecordListener.onEventUp(v)
            }
        }
        mDetector.onTouchEvent(event)
        return false
    }
}