package com.cy.sts

import com.cy.sts.http.RequestHelper
import io.reactivex.Flowable
import okhttp3.FormBody
import okhttp3.Request
import okhttp3.ResponseBody

/**
 *
 * @author CY 2019/1/21
 */
abstract class AbstractFactory : Factory {

    /**
     * 参数
     */
    val formData: HashMap<String, String> = HashMap()


    fun get(baseUrl: String): Flowable<ResponseBody> {
        return RequestHelper.get(baseUrl = baseUrl, params = formData)
    }

    fun post(url: String, encoded: Boolean = false): Request {
        val formBodyBuilder = FormBody.Builder()
        for ((key, value) in formData) {
            if (encoded) {
                formBodyBuilder.addEncoded(key, value)
            } else {
                formBodyBuilder.add(key, value)
            }
        }
        return Request.Builder().url(url).post(formBodyBuilder.build()).build()
    }


    abstract fun execute(): Flowable<ResponseBody>
}