package com.cy.sts

import android.content.Context
import com.cy.sts.asr.impl.BaiduSTT
import com.cy.sts.asr.impl.GoogleSTT
import com.cy.sts.tts.impl.BaiduTTS
import com.cy.sts.tts.impl.GoogleTTS
import io.reactivex.Flowable

/**
 *
 * @author CY 2019/1/14
 */
interface Factory {

    companion object {

        var transMap = HashMap<String, Factory>()

        inline fun <reified T : Factory> createInstance(context: Context): Flowable<T> {

            val name = T::class.java.name
            when (name) {

                /*
                /*Translate START**/
                GoogleTranslate::class.java.name -> {

                    if (!transMap.containsKey(name)) {
                        transMap[name] = GoogleTranslate()
                    }
                    return Flowable.just(transMap[name] as T)
                }
                BaiduTranslate::class.java.name -> {
                    return Flowable.just(BaiduTranslate() as T)
                }
                IcibaTranslate::class.java.name -> {
                    return Flowable.just(IcibaTranslate() as T)
                }
                OmiTranslate::class.java.name -> {
                    return Flowable.just(OmiTranslate() as T)
                }
                TencentTranslate::class.java.name -> {
                    return Flowable.just(TencentTranslate() as T)
                }
                TrycanTranslate::class.java.name -> {
                    return Flowable.just(TrycanTranslate() as T)
                }
                YoudaoTranslate::class.java.name -> {
                    return Flowable.just(YoudaoTranslate() as T)
                }
                */
                /*Translate END**/

                /*STT START**/
                BaiduSTT::class.java.name -> {
                    return Flowable.just(BaiduSTT(context) as T)
                }
                GoogleSTT::class.java.name -> {
                    return Flowable.just(GoogleSTT() as T)
                }
                /*STT END**/

                /*TTS START**/
                BaiduTTS::class.java.name -> {
                    return Flowable.just(BaiduTTS(context) as T)
                }
                GoogleTTS::class.java.name -> {
                    return Flowable.just(GoogleTTS(context) as T)
                }
                /*TTS END**/

                else -> {
                    throw IllegalStateException("请添加初始化代码")
                }

            }

        }
    }
}