package com.cy.sts.asr

import com.cy.sts.AbstractFactory
import com.cy.sts.lang.RegionLang
import okhttp3.ResponseBody

/**
 *
 * @author CY 2019/1/13
 */
abstract class STTFactory : AbstractFactory() {


    /**
     * 支持的语言Map
     */
    val langMap: HashMap<RegionLang, String> = HashMap()

    init {
        this.setLangSupport(langMap)
    }

    /**
     * 设置支持的语言
     */
    protected abstract fun setLangSupport(langMap: HashMap<RegionLang, String>)

    /**
     * 是否支持该语言
     */
    fun isSupportLanguage(lang: RegionLang): Boolean = langMap.contains(lang)

    /**
     * 源语言
     */
    protected lateinit var speechSourceLanguage: RegionLang

    /**
     * 文件 byteArray
     */
    protected lateinit var bytes: ByteArray

    fun setRequestContent(bytes: ByteArray, speechSourceLanguage: RegionLang): STTFactory {
        this.speechSourceLanguage = speechSourceLanguage
        this.bytes = bytes
        return this
    }

    /**
     * 解析结果
     */
    abstract fun parses(responseBody: ResponseBody): String
}