package com.cy.sts.asr.impl


import android.content.Context
import com.cy.sts.asr.STTFactory
import com.cy.sts.common.Logcat
import com.cy.sts.http.RequestHelper
import com.cy.sts.lang.RegionLang
import com.google.gson.Gson
import com.google.gson.JsonObject
import io.reactivex.Flowable
import okhttp3.MediaType
import okhttp3.RequestBody
import okhttp3.ResponseBody
import java.net.URLEncoder

class BaiduSTT(val context: Context) : STTFactory() {

    // 文件格式
    private val format = "pcm"

    private val cuid = "1234567JAVA"

    // 采样率固定值
    private val rate = 16000

    private val url = "https://vop.baidu.com/server_api"

    override fun execute(): Flowable<ResponseBody> {
        return Flowable.fromCallable { BaiduToken.loadToken(BaiduToken.TTS_SCOPE, context) }
            .flatMap { token ->
                val devPid = langMap[speechSourceLanguage]
                val cuidEncode = URLEncoder.encode(cuid, "UTF-8")
                val baseUrl = "$url?cuid=$cuidEncode&dev_pid=$devPid&token=$token"
                val requestBody = RequestBody.create(MediaType.parse("audio/$format; rate=$rate"), bytes)
                RequestHelper.postBody(baseUrl = baseUrl, requestBody = requestBody)
            }
    }

    override fun parses(responseBody: ResponseBody): String {
        val text = responseBody.string()
        Logcat.d(msg = "识别结束：结果是 $text")

        //if (text == null) return null
        val jsonObject = Gson().fromJson<JsonObject>(text, JsonObject::class.java)
        if (jsonObject.has("result")) {
            return jsonObject.get("result").asString
        }

        return ""
        //return responseBody.string()
    }

    override fun setLangSupport(langMap: HashMap<RegionLang, String>) {

        langMap[RegionLang.EN_AU] = "1737"//英语（澳大利亚）   English (Australia)
        langMap[RegionLang.EN_AU] = "1737"//英语（澳大利亚）   English (Australia)
        langMap[RegionLang.EN_CA] = "1737"//英语（加拿大）   English (Canada)
        langMap[RegionLang.EN_GH] = "1737"//英语（加纳）   English (Ghana)
        langMap[RegionLang.EN_GB] = "1737"//英语（英国）   English (Great Britain)
        langMap[RegionLang.EN_IN] = "1737"//英语（印度）   English (India)
        langMap[RegionLang.EN_IE] = "1737"//英语（爱尔兰）   English (Ireland)
        langMap[RegionLang.EN_KE] = "1737"//英语（肯尼亚）   English (Kenya)
        langMap[RegionLang.EN_NZ] = "1737"//英语（新西兰）   English (New Zealand)
        langMap[RegionLang.EN_NG] = "1737"//英语（尼日利亚）   English (Nigeria)
        langMap[RegionLang.EN_PH] = "1737"//英语（菲律宾）   English (Philippines)
        langMap[RegionLang.EN_ZA] = "1737"//英语（南非）   English (South Africa)
        langMap[RegionLang.EN_TZ] = "1737"//英语（坦桑尼亚）   English (Tanzania)
        langMap[RegionLang.EN_US] = "1737"//英语（美国）   English (United States)

        langMap[RegionLang.CMN_HANT_TW] = "1536"//中文、普通话（台湾繁体）   國語 (台灣)
        langMap[RegionLang.YUE_HANT_HK] = "1637"//中文、粤语（香港繁体）   廣東話 (香港)
        langMap[RegionLang.CMN_HANS_HK] = "1536"//中文、普通话（香港简体）   普通話 (香港)
        langMap[RegionLang.CMN_HANS_CN] = "1537"//中文、普通话（中国简体）   普通话 (中国大陆)
    }


}