package com.cy.sts.asr.impl

import android.content.Context
import com.cy.sts.common.Logcat
import com.google.gson.Gson
import com.google.gson.JsonObject
import org.json.JSONObject

import java.io.IOException
import java.net.HttpURLConnection
import java.net.URL
import java.net.URLEncoder

/**
 * token的获取类
 * 将apiKey和secretKey换取token，注意有效期保存在expiresAt
 */
class BaiduToken
/**
 * @param apiKey    网页上申请语音识别应用获取的apiKey
 * @param secretKey 网页上申请语音识别应用获取的secretKey
 */
    (
    /**
     * 网页上申请语音识别应用获取的apiKey
     */
    private val apiKey: String,
    /**
     * 网页上申请语音识别应用获取的secretKey
     */
    private val secretKey: String,
    /**
     * asr的权限 scope 是  "audio_voice_assistant_get"
     * tts 的权限 scope 是 "audio_tts_post"
     */
    private val scope: String,
    /**
     * 上下文，存储token
     */
    private val context: Context
) {

    /**
     * 保存访问接口获取的token
     */
    /**
     * 获取token，refresh 方法后调用有效
     *
     * @return
     */
    var token: String? = null
        private set

    /**
     * 当前的时间戳，毫秒
     */
    /**
     * 获取过期时间，refresh 方法后调用有效
     *
     * @return
     */
    var expiresAt: Long = 0
        private set


    /**
     * 获取token
     *
     * @return
     * @throws IOException   http请求错误
     */
    fun resfresh() {
        val getTokenURL = (TOKEN_URL + "?grant_type=client_credentials"
                + "&client_id=" +
                URLEncoder.encode(apiKey, "UTF-8") +
                "&client_secret=" +
                URLEncoder.encode(secretKey, "UTF-8"))

        // 打印的url出来放到浏览器内可以复现
        Logcat.d(msg = "token url:$getTokenURL")

        val url = URL(getTokenURL)
        val conn = url.openConnection() as HttpURLConnection
        conn.connectTimeout = 6000
        conn.readTimeout = 6000
        conn.connect()
        val inputStream = conn.inputStream
        val result = String(inputStream.readBytes())
        inputStream.close()
        Logcat.d(msg = "Token result json:$result")
        parseJson(result)
    }

    /**
     * @param result token接口获得的result
     */
    private fun parseJson(result: String) {
        val jsonObject = Gson().fromJson<JsonObject>(result, JsonObject::class.java)
        val json = jsonObject//JSONObject(result)
        if (!json.has("access_token")) {
            // 返回没有access_token字段
            throw IllegalStateException("access_token not obtained, $result")
        }
        if (!json.has("scope")) {
            // 返回没有scope字段
            throw IllegalStateException("scopenot obtained, $result")
        }

        if (!json.get("scope").asString.contains(scope)) {
            throw IllegalStateException("scope not exist, $scope,$result")
        }
        token = json.get("access_token").asString
        expiresAt = System.currentTimeMillis() + json.get("expires_in").asLong * 1000
        Logcat.d(msg = "Baidu expiresAt=$expiresAt")
    }


    companion object {


        const val ASR_SCOPE = "audio_voice_assistant_get"

        const val TTS_SCOPE = "audio_tts_post"

        /**
         * url , Token的url，http可以改为https
         */
        private val TOKEN_URL = "https://openapi.baidu.com/oauth/2.0/token"


        /**
         * 加载Baidu Token
         */
        fun loadToken(scope: String, context: Context): String {

            val sp = context.getSharedPreferences("BaiDuToken", Context.MODE_PRIVATE)
            val tokenJsonString = sp.getString(scope, null)

            Logcat.d(msg = "tokenJsonString=$tokenJsonString")

            var token = ""
            var expiresAt: Long

            var needRefreshToken = false
            if (tokenJsonString == null) {
                needRefreshToken = true
            } else {
                val pair = parserToken(tokenJsonString)
                token = pair.first
                expiresAt = pair.second
                if (expiresAt <= System.currentTimeMillis()) {
                    needRefreshToken = true
                }
            }


            if (needRefreshToken) {
                val pair = refreshToken(scope, context)
                token = pair.first
                expiresAt = pair.second
                val jsonObject = JSONObject()
                jsonObject.put("token", token)
                jsonObject.put("expiresAt", expiresAt)
                sp.edit().putString(scope, jsonObject.toString()).apply()
            }

            return token

        }

        private fun refreshToken(scope: String, context: Context): Pair<String, Long> {
            val appKey = "HynlTrhrvcmpXD6kqRLBS4wG"

            val secretKey = "fqCQfKGGKCkh8T0XAzvGxHSFhBV2Bj50"
            val holder = BaiduToken(appKey, secretKey, scope, context)

            holder.resfresh()

            return (holder.token ?: "") to holder.expiresAt

        }

        private fun parserToken(tokenJsonString: String): Pair<String, Long> {
            val tokenJson = JSONObject(tokenJsonString)
            val token = tokenJson.getString("token")
            val expiresAt = tokenJson.getLong("expiresAt")
            return token to expiresAt
        }
    }
}
