package com.cy.sts.http

import io.reactivex.Flowable
import okhttp3.OkHttpClient
import okhttp3.RequestBody
import okhttp3.ResponseBody
import retrofit2.Retrofit
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory
import retrofit2.http.*
import java.util.concurrent.TimeUnit

/**
 * 网络请求
 * @author CY 2019/1/28
 */
internal object RequestHelper {

    private val map: HashMap<String, ApiService> = hashMapOf()

    private fun apiService(baseUrl: String): ApiService {

        if (map.containsKey(baseUrl)) {
            return map[baseUrl]!!
        }

        val okHttpClient = OkHttpClient
            .Builder()
            .callTimeout(6000, TimeUnit.MILLISECONDS)
            .connectTimeout(6000, TimeUnit.MILLISECONDS)
            .readTimeout(8000, TimeUnit.MILLISECONDS)
            //.addNetworkInterceptor(StethoInterceptor())
            .build()
        val retrofit = Retrofit
            .Builder()
            .baseUrl(baseUrl)
            .client(okHttpClient)
            .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
            .build()
        val apiService = retrofit.create(ApiService::class.java)

        map[baseUrl] = apiService

        return apiService
    }

    fun get(
        baseUrl: String,
        paths: String = "",
        headerMap: Map<String, String> = hashMapOf(),
        params: Map<String, String>
    ) = apiService(baseUrl).get(headerMap, paths, params)

    fun post(
        baseUrl: String,
        paths: String = "",
        headerMap: Map<String, String> = hashMapOf(),
        params: Map<String, String>
    ) = apiService(baseUrl).post(headerMap, paths, params)

    fun postBody(
        baseUrl: String,
        paths: String = "",
        headerMap: Map<String, String> = hashMapOf(),
        requestBody: RequestBody,
        params: Map<String, String> = hashMapOf()
    ): Flowable<ResponseBody> {
        //val requestBody = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), content)
        return apiService(baseUrl).postBody(headerMap, paths, requestBody, params)
    }

    interface ApiService {

        @GET
        fun get(@HeaderMap headerMap: Map<String, String> = hashMapOf(), @Url url: String, @QueryMap params: Map<String, String>): Flowable<ResponseBody>

        @FormUrlEncoded
        @POST
        fun post(@HeaderMap headerMap: Map<String, String> = hashMapOf(), @Url url: String = "", @FieldMap params: Map<String, String>): Flowable<ResponseBody>

        @POST
        fun postBody(@HeaderMap headerMap: Map<String, String> = hashMapOf(), @Url url: String = "", @Body requestBody: RequestBody, @QueryMap params: Map<String, String> = hashMapOf()): Flowable<ResponseBody>

    }

}