package com.cy.sts.lang

/**
 * 默认谷歌 STT Language
 * @author CY 2019/1/14
 */
enum class RegionLang(val language: String, var languageCode: String, name_cn: String) {

    AF_ZA("Afrikaans (Suid-Afrika)", "af-ZA", "南非荷兰语（南非）"),
    AM_ET("አማርኛ (ኢትዮጵያ)", "am-ET", "阿姆哈拉语（埃塞俄比亚）"),
    HY_AM("Հայ (Հայաստան)", "hy-AM", "亚美尼亚语（亚美尼亚）"),
    AZ_AZ("Azərbaycan (Azərbaycan)", "az-AZ", "阿塞拜疆语（阿塞拜疆）"),
    ID_ID("Bahasa Indonesia (Indonesia)", "id-ID", "印度尼西亚语（印度尼西亚）"),
    MS_MY("Bahasa Melayu (Malaysia)", "ms-MY", "马来语（马来西亚）"),
    BN_BD("বাংলা (বাংলাদেশ)", "bn-BD", "孟加拉语（孟加拉）"),
    BN_IN("বাংলা (ভারত)", "bn-IN", "孟加拉语（印度）"),
    CA_ES("Català (Espanya)", "ca-ES", "加泰罗尼亚语（西班牙）"),
    CS_CZ("Čeština (Česká republika)", "cs-CZ", "捷克语（捷克共和国）"),
    DA_DK("Dansk (Danmark)", "da-DK", "丹麦语（丹麦）"),
    DE_DE("Deutsch (Deutschland)", "de-DE", "德语（德国）"),
    EN_AU("English (Australia)", "en-AU", "英语（澳大利亚）"),
    EN_CA("English (Canada)", "en-CA", "英语（加拿大）"),
    EN_GH("English (Ghana)", "en-GH", "英语（加纳）"),
    EN_GB("English (Great Britain)", "en-GB", "英语（英国）"),
    EN_IN("English (India)", "en-IN", "英语（印度）"),
    EN_IE("English (Ireland)", "en-IE", "英语（爱尔兰）"),
    EN_KE("English (Kenya)", "en-KE", "英语（肯尼亚）"),
    EN_NZ("English (New Zealand)", "en-NZ", "英语（新西兰）"),
    EN_NG("English (Nigeria)", "en-NG", "英语（尼日利亚）"),
    EN_PH("English (Philippines)", "en-PH", "英语（菲律宾）"),
    EN_ZA("English (South Africa)", "en-ZA", "英语（南非）"),
    EN_TZ("English (Tanzania)", "en-TZ", "英语（坦桑尼亚）"),
    EN_US("English (United States)", "en-US", "英语（美国）"),
    ES_AR("Español (Argentina)", "es-AR", "西班牙语（阿根廷）"),
    ES_BO("Español (Bolivia)", "es-BO", "西班牙语（玻利维亚）"),
    ES_CL("Español (Chile)", "es-CL", "西班牙语（智利）"),
    ES_CO("Español (Colombia)", "es-CO", "西班牙语（哥伦比亚）"),
    ES_CR("Español (Costa Rica)", "es-CR", "西班牙语（哥斯达黎加）"),
    ES_EC("Español (Ecuador)", "es-EC", "西班牙语（厄瓜多尔）"),
    ES_SV("Español (El Salvador)", "es-SV", "西班牙语（萨尔瓦多）"),
    ES_ES("Español (España)", "es-ES", "西班牙语（西班牙）"),
    ES_US("Español (Estados Unidos)", "es-US", "西班牙语（美国）"),
    ES_GT("Español (Guatemala)", "es-GT", "西班牙语（危地马拉）"),
    ES_HN("Español (Honduras)", "es-HN", "西班牙语（洪都拉斯）"),
    ES_MX("Español (México)", "es-MX", "西班牙语（墨西哥）"),
    ES_NI("Español (Nicaragua)", "es-NI", "西班牙语（尼加拉瓜）"),
    ES_PA("Español (Panamá)", "es-PA", "西班牙语（巴拿马）"),
    ES_PY("Español (Paraguay)", "es-PY", "西班牙语（巴拉圭）"),
    ES_PE("Español (Perú)", "es-PE", "西班牙语（秘鲁）"),
    ES_PR("Español (Puerto Rico)", "es-PR", "西班牙语（波多黎各）"),
    ES_DO("Español (República Dominicana)", "es-DO", "西班牙语（多米尼加共和国）"),
    ES_UY("Español (Uruguay)", "es-UY", "西班牙语（乌拉圭）"),
    ES_VE("Español (Venezuela)", "es-VE", "西班牙语（委内瑞拉）"),
    EU_ES("Euskara (Espainia)", "eu-ES", "巴斯克语（西班牙）"),
    FIL_PH("Filipino (Pilipinas)", "fil-PH", "菲律宾语（菲律宾）"),
    FR_CA("Français (Canada)", "fr-CA", "法语（加拿大）"),
    FR_FR("Français (France)", "fr-FR", "法语（法国）"),
    GL_ES("Galego (España)", "gl-ES", "加利西亚语（西班牙）"),
    KA_GE("ქართული (საქართველო)", "ka-GE", "格鲁吉亚语（格鲁吉亚）"),
    GU_IN("ગુજરાતી (ભારત)", "gu-IN", "古吉拉特语（印度）"),
    HR_HR("Hrvatski (Hrvatska)", "hr-HR", "克罗地亚语（克罗地亚）"),
    ZU_ZA("IsiZulu (Ningizimu Afrika)", "zu-ZA", "祖鲁语（南非）"),
    IS_IS("Íslenska (Ísland)", "is-IS", "冰岛语（冰岛）"),
    IT_IT("Italiano (Italia)", "it-IT", "意大利语（意大利）"),
    JV_ID("Jawa (Indonesia)", "jv-ID", "爪哇语（印度尼西亚）"),
    KN_IN("ಕನ್ನಡ (ಭಾರತ)", "kn-IN", "卡纳达语（印度）"),
    KM_KH("ភាសាខ្មែរ (កម្ពុជា)", "km-KH", "高棉语（柬埔寨）"),
    LO_LA("ລາວ (ລາວ)", "lo-LA", "老挝语（老挝）"),
    LV_LV("Latviešu (latviešu)", "lv-LV", "拉脱维亚语（拉脱维亚）"),
    LT_LT("Lietuvių (Lietuva)", "lt-LT", "立陶宛语（立陶宛）"),
    HU_HU("Magyar (Magyarország)", "hu-HU", "匈牙利语（匈牙利）"),
    ML_IN("മലയാളം (ഇന്ത്യ)", "ml-IN", "马拉雅拉姆语（印度）"),
    MR_IN("मराठी (भारत)", "mr-IN", "马拉地语（印度）"),
    NL_NL("Nederlands (Nederland)", "nl-NL", "荷兰语（荷兰）"),
    NE_NP("नेपाली (नेपाल)", "ne-NP", "尼泊尔语（尼泊尔）"),
    NB_NO("Norsk bokmål (Norge)", "nb-NO", "博克马尔挪威语（挪威）"),
    PL_PL("Polski (Polska)", "pl-PL", "波兰语（波兰）"),
    PT_BR("Português (Brasil)", "pt-BR", "葡萄牙语（巴西）"),
    PT_PT("Português (Portugal)", "pt-PT", "葡萄牙语（葡萄牙）"),
    RO_RO("Română (România)", "ro-RO", "罗马尼亚语（罗马尼亚）"),
    SI_LK("සිංහල (ශ්රී ලංකාව)", "si-LK", "僧伽罗语（斯里兰卡）"),
    SK_SK("Slovenčina (Slovensko)", "sk-SK", "斯洛伐克语（斯洛伐克）"),
    SL_SI("Slovenščina (Slovenija)", "sl-SI", "斯洛文尼亚语（斯洛文尼亚）"),
    SU_ID("Urang (Indonesia)", "su-ID", "巽他语（印度尼西亚）"),
    SW_TZ("Swahili (Tanzania)", "sw-TZ", "斯瓦希里语（坦桑尼亚）"),
    SW_KE("Swahili (Kenya)", "sw-KE", "斯瓦希里语（肯尼亚）"),
    FI_FI("Suomi (Suomi)", "fi-FI", "芬兰语（芬兰）"),
    SV_SE("Svenska (Sverige)", "sv-SE", "瑞典语（瑞典）"),
    TA_IN("தமிழ் (இந்தியா)", "ta-IN", "泰米尔语（印度）"),
    TA_SG("தமிழ் (சிங்கப்பூர்)", "ta-SG", "泰米尔语（新加坡）"),
    TA_LK("தமிழ் (இலங்கை)", "ta-LK", "泰米尔语（斯里兰卡）"),
    TA_MY("தமிழ் (மலேசியா)", "ta-MY", "泰米尔语（马来西亚）"),
    TE_IN("తెలుగు (భారతదేశం)", "te-IN", "泰卢固语（印度）"),
    VI_VN("Tiếng Việt (Việt Nam)", "vi-VN", "越南语（越南）"),
    TR_TR("Türkçe (Türkiye)", "tr-TR", "土耳其语（土耳其）"),
    UR_PK("اردو (پاکستان)", "ur-PK", "乌尔都语（巴基斯坦）"),
    UR_IN("اردو (بھارت)", "ur-IN", "乌尔都语（印度）"),
    EL_GR("Ελληνικά (Ελλάδα)", "el-GR", "希腊语（希腊）"),
    BG_BG("Български (България)", "bg-BG", "保加利亚语（保加利亚）"),
    RU_RU("Русский (Россия)", "ru-RU", "俄语（俄罗斯）"),
    SR_RS("Српски (Србија)", "sr-RS", "塞尔维亚语（塞尔维亚）"),
    UK_UA("Українська (Україна)", "uk-UA", "乌克兰语（乌克兰）"),
    HE_IL("עברית (ישראל)", "he-IL", "希伯来语（以色列）"),
    AR_IL("العربية (إسرائيل)", "ar-IL", "阿拉伯语（以色列）"),
    AR_JO("العربية (الأردن)", "ar-JO", "阿拉伯语（约旦）"),
    AR_AE("العربية (الإمارات)", "ar-AE", "阿拉伯语（阿拉伯联合酋长国）"),
    AR_BH("العربية (البحرين)", "ar-BH", "阿拉伯语（巴林）"),
    AR_DZ("العربية (الجزائر)", "ar-DZ", "阿拉伯语（阿尔及利亚）"),
    AR_SA("العربية (السعودية)", "ar-SA", "阿拉伯语（沙特阿拉伯）"),
    AR_IQ("العربية (العراق)", "ar-IQ", "阿拉伯语（伊拉克）"),
    AR_KW("العربية (الكويت)", "ar-KW", "阿拉伯语（科威特）"),
    AR_MA("العربية (المغرب)", "ar-MA", "阿拉伯语（摩洛哥）"),
    AR_TN("العربية (تونس)", "ar-TN", "阿拉伯语（突尼斯）"),
    AR_OM("العربية (عُمان)", "ar-OM", "阿拉伯语（阿曼）"),
    AR_PS("العربية (فلسطين)", "ar-PS", "阿拉伯语（巴勒斯坦国）"),
    AR_QA("العربية (قطر)", "ar-QA", "阿拉伯语（卡塔尔）"),
    AR_LB("العربية (لبنان)", "ar-LB", "阿拉伯语（黎巴嫩）"),
    AR_EG("العربية (مصر)", "ar-EG", "阿拉伯语（埃及）"),
    FA_IR("فارسی (ایران)", "fa-IR", "波斯语（伊朗）"),
    HI_IN("हिन्दी (भारत)", "hi-IN", "印地语（印度）"),
    TH_TH("ไทย (ประเทศไทย)", "th-TH", "泰语（泰国）"),
    KO_KR("한국어 (대한민국)", "ko-KR", "韩语（韩国）"),
    CMN_HANT_TW("國語 (台灣)", "cmn-Hant-TW", "中文、普通话（台湾繁体）"),
    YUE_HANT_HK("廣東話 (香港)", "yue-Hant-HK", "中文、粤语（香港繁体）"),
    JA_JP("日本語（日本）", "ja-JP", "日语（日本）"),
    CMN_HANS_HK("普通話 (香港)", "cmn-Hans-HK", "中文、普通话（香港简体）"),
    CMN_HANS_CN("普通话 (中国大陆)", "cmn-Hans-CN", "中文、普通话（中国简体）"),

}


/* 代码生成代码

            val inputStream = assets.open("google_stt_support_language.json")
            val jsonArray = Gson().fromJson<JsonArray>(InputStreamReader(inputStream), JsonArray::class.java)

            val sb = StringBuilder()
            for (i in 0 until jsonArray.size()) {
                val jo = jsonArray[i].asJsonObject
                val language = jo["language"].asString
                val languageCode = jo["languageCode"].asString
                val name_cn = jo["name_cn"].asString
                val text =
                    "${languageCode.toUpperCase().replace('-', '_')}(\"$language\", \"$languageCode\", \"$name_cn\"),"
                sb.append(text).append('\n')
            }

            val fos = FileOutputStream(File(externalCacheDir, "google_stt_languages.txt"))

            fos.write(sb.toString().toByteArray())
            fos.flush()
            fos.close()
            Logcat.d(msg = "google_languages=$sb ")

 */