package com.cy.sts.stt

import android.content.Intent
import android.os.Bundle
import android.speech.RecognitionListener
import android.speech.RecognizerIntent
import android.speech.SpeechRecognizer
import com.cy.sts.STSEngine
import com.cy.sts.common.Logcat
import com.cy.sts.lang.RegionLang
import com.google.gson.Gson
import java.util.*

/**
 * @author CY 19-2-18
 */
class GoogleRecognitionHelper(stsEngine: STSEngine) : SpeechHelper(stsEngine), RecognitionListener {

    companion object {
        const val TAG = "GoogleRecognitionHelper"
    }

    override fun setLangSupport(langMap: HashMap<RegionLang, String>) {
        langMap[RegionLang.AF_ZA] = "af-ZA"
        langMap[RegionLang.AM_ET] = "am-ET"
        langMap[RegionLang.HY_AM] = "hy-AM"
        langMap[RegionLang.AZ_AZ] = "az-AZ"
        langMap[RegionLang.ID_ID] = "id-ID"
        langMap[RegionLang.MS_MY] = "ms-MY"
        langMap[RegionLang.BN_BD] = "bn-BD"
        langMap[RegionLang.BN_IN] = "bn-IN"
        langMap[RegionLang.CA_ES] = "ca-ES"
        langMap[RegionLang.CS_CZ] = "cs-CZ"
        langMap[RegionLang.DA_DK] = "da-DK"
        langMap[RegionLang.DE_DE] = "de-DE"
        langMap[RegionLang.EN_AU] = "en-AU"
        langMap[RegionLang.EN_CA] = "en-CA"
        langMap[RegionLang.EN_GH] = "en-GH"
        langMap[RegionLang.EN_GB] = "en-GB"
        langMap[RegionLang.EN_IN] = "en-IN"
        langMap[RegionLang.EN_IE] = "en-IE"
        langMap[RegionLang.EN_KE] = "en-KE"
        langMap[RegionLang.EN_NZ] = "en-NZ"
        langMap[RegionLang.EN_NG] = "en-NG"
        langMap[RegionLang.EN_PH] = "en-PH"
        langMap[RegionLang.EN_ZA] = "en-ZA"
        langMap[RegionLang.EN_TZ] = "en-TZ"
        langMap[RegionLang.EN_US] = "en-US"
        langMap[RegionLang.ES_AR] = "es-AR"
        langMap[RegionLang.ES_BO] = "es-BO"
        langMap[RegionLang.ES_CL] = "es-CL"
        langMap[RegionLang.ES_CO] = "es-CO"
        langMap[RegionLang.ES_CR] = "es-CR"
        langMap[RegionLang.ES_EC] = "es-EC"
        langMap[RegionLang.ES_SV] = "es-SV"
        langMap[RegionLang.ES_ES] = "es-ES"
        langMap[RegionLang.ES_US] = "es-US"
        langMap[RegionLang.ES_GT] = "es-GT"
        langMap[RegionLang.ES_HN] = "es-HN"
        langMap[RegionLang.ES_MX] = "es-MX"
        langMap[RegionLang.ES_NI] = "es-NI"
        langMap[RegionLang.ES_PA] = "es-PA"
        langMap[RegionLang.ES_PY] = "es-PY"
        langMap[RegionLang.ES_PE] = "es-PE"
        langMap[RegionLang.ES_PR] = "es-PR"
        langMap[RegionLang.ES_DO] = "es-DO"
        langMap[RegionLang.ES_UY] = "es-UY"
        langMap[RegionLang.ES_VE] = "es-VE"
        langMap[RegionLang.EU_ES] = "eu-ES"
        langMap[RegionLang.FIL_PH] = "fil-PH"
        langMap[RegionLang.FR_CA] = "fr-CA"
        langMap[RegionLang.FR_FR] = "fr-FR"
        langMap[RegionLang.GL_ES] = "gl-ES"
        langMap[RegionLang.KA_GE] = "ka-GE"
        langMap[RegionLang.GU_IN] = "gu-IN"
        langMap[RegionLang.HR_HR] = "hr-HR"
        langMap[RegionLang.ZU_ZA] = "zu-ZA"
        langMap[RegionLang.IS_IS] = "is-IS"
        langMap[RegionLang.IT_IT] = "it-IT"
        langMap[RegionLang.JV_ID] = "jv-ID"
        langMap[RegionLang.KN_IN] = "kn-IN"
        langMap[RegionLang.KM_KH] = "km-KH"
        langMap[RegionLang.LO_LA] = "lo-LA"
        langMap[RegionLang.LV_LV] = "lv-LV"
        langMap[RegionLang.LT_LT] = "lt-LT"
        langMap[RegionLang.HU_HU] = "hu-HU"
        langMap[RegionLang.ML_IN] = "ml-IN"
        langMap[RegionLang.MR_IN] = "mr-IN"
        langMap[RegionLang.NL_NL] = "nl-NL"
        langMap[RegionLang.NE_NP] = "ne-NP"
        langMap[RegionLang.NB_NO] = "nb-NO"
        langMap[RegionLang.PL_PL] = "pl-PL"
        langMap[RegionLang.PT_BR] = "pt-BR"
        langMap[RegionLang.PT_PT] = "pt-PT"
        langMap[RegionLang.RO_RO] = "ro-RO"
        langMap[RegionLang.SI_LK] = "si-LK"
        langMap[RegionLang.SK_SK] = "sk-SK"
        langMap[RegionLang.SL_SI] = "sl-SI"
        langMap[RegionLang.SU_ID] = "su-ID"
        langMap[RegionLang.SW_TZ] = "sw-TZ"
        langMap[RegionLang.SW_KE] = "sw-KE"
        langMap[RegionLang.FI_FI] = "fi-FI"
        langMap[RegionLang.SV_SE] = "sv-SE"
        langMap[RegionLang.TA_IN] = "ta-IN"
        langMap[RegionLang.TA_SG] = "ta-SG"
        langMap[RegionLang.TA_LK] = "ta-LK"
        langMap[RegionLang.TA_MY] = "ta-MY"
        langMap[RegionLang.TE_IN] = "te-IN"
        langMap[RegionLang.VI_VN] = "vi-VN"
        langMap[RegionLang.TR_TR] = "tr-TR"
        langMap[RegionLang.UR_PK] = "ur-PK"
        langMap[RegionLang.UR_IN] = "ur-IN"
        langMap[RegionLang.EL_GR] = "el-GR"
        langMap[RegionLang.BG_BG] = "bg-BG"
        langMap[RegionLang.RU_RU] = "ru-RU"
        langMap[RegionLang.SR_RS] = "sr-RS"
        langMap[RegionLang.UK_UA] = "uk-UA"
        langMap[RegionLang.HE_IL] = "he-IL"
        langMap[RegionLang.AR_IL] = "ar-IL"
        langMap[RegionLang.AR_JO] = "ar-JO"
        langMap[RegionLang.AR_AE] = "ar-AE"
        langMap[RegionLang.AR_BH] = "ar-BH"
        langMap[RegionLang.AR_DZ] = "ar-DZ"
        langMap[RegionLang.AR_SA] = "ar-SA"
        langMap[RegionLang.AR_IQ] = "ar-IQ"
        langMap[RegionLang.AR_KW] = "ar-KW"
        langMap[RegionLang.AR_MA] = "ar-MA"
        langMap[RegionLang.AR_TN] = "ar-TN"
        langMap[RegionLang.AR_OM] = "ar-OM"
        langMap[RegionLang.AR_PS] = "ar-PS"
        langMap[RegionLang.AR_QA] = "ar-QA"
        langMap[RegionLang.AR_LB] = "ar-LB"
        langMap[RegionLang.AR_EG] = "ar-EG"
        langMap[RegionLang.FA_IR] = "fa-IR"
        langMap[RegionLang.HI_IN] = "hi-IN"
        langMap[RegionLang.TH_TH] = "th-TH"
        langMap[RegionLang.KO_KR] = "ko-KR"
        langMap[RegionLang.CMN_HANT_TW] = "cmn-Hant-TW"
        langMap[RegionLang.YUE_HANT_HK] = "yue-Hant-HK"
        langMap[RegionLang.JA_JP] = "ja-JP"
        langMap[RegionLang.CMN_HANS_HK] = "cmn-Hans-HK"
        langMap[RegionLang.CMN_HANS_CN] = "cmn-Hans-CN"
    }

    private val recognizer: SpeechRecognizer by lazy {
        SpeechRecognizer.createSpeechRecognizer(context)
    }

    private fun promptSpeechInput() {
        //  mStartTime = System.currentTimeMillis()
        val intent = Intent(RecognizerIntent.ACTION_RECOGNIZE_SPEECH)
        intent.`package` = "com.google.android.googlequicksearchbox"
        intent.putExtra(
            RecognizerIntent.EXTRA_LANGUAGE_MODEL,
            RecognizerIntent.LANGUAGE_MODEL_WEB_SEARCH
        )
        //RecognizerIntent.EXTRA_ADDITIONAL_LANGUAGES
        //android.speech.extra.EXTRA_ADDITIONAL_LANGUAGES
        //android.speech.action.GET_LANGUAGE_DETAILS
        val local =
            langMap[stsEngine.builder.speechLanguage]//Locale.forLanguageTag(langMap[stsEngine.builder.speechLanguage])
        Logcat.d(tag = TAG, msg = "local=$local")
        intent.putExtra(RecognizerIntent.EXTRA_LANGUAGE, local)
        intent.putExtra(RecognizerIntent.EXTRA_PARTIAL_RESULTS, true)
        intent.putExtra("android.speech.extra.EXTRA_ADDITIONAL_LANGUAGES", arrayOf(local, "cmn-Hans-CN"))

        intent.putExtra(RecognizerIntent.EXTRA_LANGUAGE_MODEL, RecognizerIntent.LANGUAGE_MODEL_WEB_SEARCH)
        //intent.putExtra(RecognizerIntent.EXTRA_LANGUAGE_MODEL, "ar-SA")
        intent.putExtra(RecognizerIntent.EXTRA_LANGUAGE_PREFERENCE, local)
        intent.putExtra(RecognizerIntent.EXTRA_ONLY_RETURN_LANGUAGE_PREFERENCE, local)
        intent.putExtra(RecognizerIntent.EXTRA_CALLING_PACKAGE, context.packageName)

        recognizer.startListening(intent)

    }

    override fun startSpeech() {
        recognizer.stopListening()
        recognizer.cancel()
        recognizer.destroy()
        recognizer.setRecognitionListener(this)
        promptSpeechInput()
    }

    override fun stopSpeech() {
        recognizer.stopListening()
        //recognizer.cancel()
    }

    override fun cancelSpeech() {
        recognizer.cancel()
    }

    override fun release() {
        recognizer.destroy()
    }


    override fun onReadyForSpeech(params: Bundle?) {
        Logcat.d(tag = TAG, msg = "RecognitionListener#onReadyForSpeech")
        eventListener().onEvent(CALLBACK_STT_READY)
    }

    override fun onBeginningOfSpeech() {
        Logcat.d(tag = TAG, msg = "RecognitionListener#onBeginningOfSpeech")
        eventListener().onEvent(CALLBACK_STT_BEGIN)
    }

    override fun onRmsChanged(rmsdB: Float) {
        Logcat.d(tag = TAG, msg = "RecognitionListener#onRmsChanged  rmsdB=$rmsdB")
        eventListener().onEvent(CALLBACK_STT_VOLUME, bundle.apply {
            putFloat(EXTRA_STT_VOLUME, rmsdB)
            putInt(EXTRA_STT_VOLUME_PERCENT, rmsdB.toInt())//(rmsdB * 10).toInt()
        })
    }

    override fun onBufferReceived(buffer: ByteArray?) {
        Logcat.d(tag = TAG, msg = "RecognitionListener#onBufferReceived")
        eventListener().onEvent(CALLBACK_STT_AUDIO)
    }

    override fun onPartialResults(partialResults: Bundle?) {
        val texts = partialResults?.getStringArrayList(
            SpeechRecognizer.RESULTS_RECOGNITION
        )

        val text = if (texts?.isNotEmpty() == true) texts[0] else ""
        Logcat.d(
            tag = TAG,
            msg = "RecognitionListener#onPartialResults  partialResults=$text  partialResults=${Gson().toJson(
                partialResults
            )}"
        )
        //Logcat.d(tag = TAG, msg = "RecognitionListener#onPartialResults  partialResults=$text")
        eventListener().onEvent(
            CALLBACK_STT_PARTIAL,
            bundle.apply { putString(EXTRA_STT_PARTIAL, text) })

    }

    override fun onEvent(eventType: Int, params: Bundle?) {
        Logcat.d(tag = TAG, msg = "RecognitionListener#onEvent")
    }


    override fun onEndOfSpeech() {
        Logcat.d(tag = TAG, msg = "RecognitionListener#onEndOfSpeech")
        eventListener().onEvent(CALLBACK_STT_END)
    }

    override fun onError(error: Int) {
        Logcat.d(tag = TAG, msg = "RecognitionListener#onError  error=$error")
        eventListener().onEvent(CALLBACK_ERROR, bundle.apply { putInt(EXTRA_ERROR_CODE, error) })
    }

    override fun onResults(results: Bundle?) {

        val texts = results?.getStringArrayList(
            SpeechRecognizer.RESULTS_RECOGNITION
        )
        val text = if (texts?.isNotEmpty() == true) texts[0] else ""
        Logcat.d(
            tag = TAG, msg = "RecognitionListener#onResults  results=$text   results=${Gson().toJson(
                results
            )}"
        )
        eventListener().onEvent(CALLBACK_STT_FINISH, bundle.apply { putString(EXTRA_STT_PARTIAL, text) })
//        stsEngine.transWithSpeech(text)
    }

}