package com.cy.sts.stt

import android.content.Context
import com.cy.sts.lang.RegionLang
import java.util.*

/**
 * @author CY 19-2-13
 */
abstract class Recognition(context: Context) {

    /**
     * 支持的语言Map
     */
    val langMap: HashMap<RegionLang, String> = HashMap()

    /**
     * 识别的语言
     */
    var recognitionLang: RegionLang? = null

    init {
        this.setLangSupport(langMap)
    }

    /**
     * 设置支持的语言
     */
    protected abstract fun setLangSupport(langMap: HashMap<RegionLang, String>)

    /**
     * 是否支持该语言
     */
    fun isSupportLanguage(lang: RegionLang): Boolean = langMap.contains(lang)


}