package com.cy.sts.tts

import android.content.Context
import com.cy.sts.AbstractFactory
import com.talpa.tengine.lang.LANG
import io.reactivex.BackpressureStrategy
import io.reactivex.Flowable
import okhttp3.ResponseBody
import java.io.File
import java.io.FileOutputStream
import java.lang.Exception

/**
 *
 * @author CY 2019/1/21
 */
abstract class TTSFactory(val context: Context) : AbstractFactory() {


    /**
     * 支持的语言Map
     */
    val langMap: HashMap<LANG, String> = HashMap()

    init {
        this.setLangSupport(langMap)
    }

    /**
     * 设置支持的语言
     */
    protected abstract fun setLangSupport(langMap: HashMap<LANG, String>)

    /**
     * 是否支持该语言
     */
    fun isSupportLanguage(lang: LANG): Boolean = langMap.contains(lang)


    abstract fun setFormData(source: LANG, text: String)

    open fun parse(responseBody: ResponseBody): Flowable<File> {
        return Flowable.create<File>({ emitter ->

            try {
                val contentType: String =
                    responseBody.contentType()?.toString() ?: ""

                if (contentType.contains("audio/")) {
                    val bytes = responseBody.bytes()

                    val ttsDir = File(context.externalCacheDir, "tts")
                    if (!ttsDir.exists()) {
                        ttsDir.mkdirs()
                    }
                    val voiceFile = File(ttsDir, "${System.currentTimeMillis()}.mp3")
                    val fos = FileOutputStream(voiceFile)
                    fos.write(bytes)
                    fos.flush()
                    fos.close()
                    emitter.onNext(voiceFile)
                    emitter.onComplete()
                } else {
                    val content = responseBody.string()
                    emitter.onError(Exception(content))
                }
            } catch (e: Throwable) {
                emitter.onError(e)
            }


        }, BackpressureStrategy.BUFFER)

    }
}