package com.cy.sts.tts.impl

import android.content.Context
import com.cy.sts.asr.impl.BaiduToken
import com.cy.sts.http.RequestHelper
import com.talpa.tengine.lang.LANG
import com.cy.sts.tts.TTSFactory
import io.reactivex.Flowable
import okhttp3.ResponseBody
import java.net.URLEncoder


/**
 *
 * @author CY 2019/1/21
 */
class BaiduTTS(context: Context) : TTSFactory(context) {

    override fun setLangSupport(langMap: HashMap<LANG, String>) {
        langMap[LANG.ZH_CN] = "zh"
    }

    override fun setFormData(source: LANG, text: String) {
        if (!langMap.containsKey(source)) {
            throw IllegalStateException("不支持该语言 $source")
        }
        formData["tex"] = URLEncoder.encode(text, "UTF-8")
        formData["lan"] = langMap[source]!!
    }

    private fun form(token: String) {

        //val token = BaiduToken.loadToken(BaiduToken.TTS_SCOPE, context)
        // 发音人选择, 0为普通女声，1为普通男生，3为情感合成-度逍遥，4为情感合成-度丫丫，默认为普通女声
        val per = 0
        // 语速，取值0-15，默认为5中语速
        val spd = 5
        // 音调，取值0-15，默认为5中语调
        val pit = 5
        // 音量，取值0-9，默认为5中音量
        val vol = 5

        // 下载的文件格式, 3：mp3(default) 4： pcm-16k 5： pcm-8k 6. wav
        val aue = 6

        val cuid = "1234567JAVA"

        formData["per"] = per.toString()
        formData["spd"] = spd.toString()
        formData["pit"] = pit.toString()
        formData["vol"] = vol.toString()
        formData["cuid"] = cuid
        formData["tok"] = token
        formData["aue"] = aue.toString()
        formData["ctp"] = 1.toString()
    }

    override fun execute(): Flowable<ResponseBody> {
        return Flowable
            .fromCallable { BaiduToken.loadToken(BaiduToken.TTS_SCOPE, context) }
            .flatMap { token ->
                form(token)

                val paths = "text2audio"
                RequestHelper.post(baseUrl = URL, paths = paths, params = formData)
            }
    }

    companion object {
        private const val URL = "https://tsn.baidu.com/"
        //private const val URL = "https://tsn.baidu.com/text2audio"

    }
}


//fun main(args: Array<String>) {
//    //BaiduTTS().execute()
//}