package com.cy.sts.tts.impl

import android.content.Context
import com.cy.sts.http.RequestHelper
import com.talpa.tengine.lang.LANG
import com.cy.sts.tts.TTSFactory
import com.talpa.tengine.googleTk
import io.reactivex.Flowable
import okhttp3.ResponseBody
import java.io.Reader
import java.io.StringReader
import javax.script.Invocable
import javax.script.ScriptEngineManager


/**
 *
 * @author CY 2019/1/21
 */
class GoogleTTS(context: Context) : TTSFactory(context) {

    /**
     * Token 必须初始化才能使用
     */
    //lateinit var tkReader: Reader
    /**
     * Token 必须初始化才能使用
     */
    private val tkReader: Reader by lazy {
        val googleTk =
            googleTk(context)//Base64.decode(inputStream.readBytes(), Base64.NO_WRAP).toString(Charset.defaultCharset())
        StringReader(googleTk)
    }


    override fun setLangSupport(langMap: HashMap<LANG, String>) {

        langMap[LANG.EN] = "en"
        langMap[LANG.HI] = "hi"
        langMap[LANG.BN] = "bn"
        langMap[LANG.TE] = "te"
        langMap[LANG.MR] = "mr"
        langMap[LANG.TA] = "ta"
        langMap[LANG.UR] = "ur"
        langMap[LANG.KN] = "kn"
        langMap[LANG.GU] = "gu"
        langMap[LANG.ML] = "ml"
        langMap[LANG.PA] = "pa"
        langMap[LANG.ZH_CN] = "zh-CN"
        langMap[LANG.ES] = "es"
        langMap[LANG.AR] = "ar"
        langMap[LANG.MS] = "ms"
        langMap[LANG.PT] = "pt"
        langMap[LANG.RU] = "ru"
        langMap[LANG.FR] = "fr"
        langMap[LANG.DE] = "de"
        langMap[LANG.HA] = "ha"
        langMap[LANG.JA] = "ja"
        langMap[LANG.FA] = "fa"
        langMap[LANG.SW] = "sw"
        langMap[LANG.JW] = "jw"
        langMap[LANG.TH] = "th"
        langMap[LANG.IN] = "id"
        langMap[LANG.TR] = "tr"
        langMap[LANG.NE] = "ne"
        langMap[LANG.PT] = "tl"
        langMap[LANG.VI] = "vi"
        langMap[LANG.KO] = "ko"
        langMap[LANG.IT] = "it"
        langMap[LANG.AM] = "am"
        langMap[LANG.CS] = "cs"
        langMap[LANG.HR] = "hr"
        langMap[LANG.SV] = "sv"
        langMap[LANG.NL] = "nl"
        langMap[LANG.EL] = "el"
        langMap[LANG.RO] = "ro"
        langMap[LANG.PL] = "pl"
        langMap[LANG.FI] = "fi"
        langMap[LANG.HU] = "hu"
        langMap[LANG.IW] = "iw"
        langMap[LANG.KK] = "kk"
        langMap[LANG.KM] = "km"
        langMap[LANG.KY] = "ky"
        langMap[LANG.MY] = "my"
        langMap[LANG.SE] = "no"
        langMap[LANG.PS] = "ps"
        langMap[LANG.SI] = "si"
        langMap[LANG.SO] = "so"
        langMap[LANG.SQ] = "sq"
        langMap[LANG.UK] = "uk"

    }


    override fun setFormData(source: LANG, text: String) {
        formData["ie"] = "UTF-8"
        formData["q"] = text
        formData["tl"] = langMap[source]!!
        formData["total"] = 1.toString()
        formData["idx"] = 0.toString()
        formData["textlen"] = 11.toString()
        formData["tk"] = token(text)
        formData["client"] = "t"
    }

    private fun token(text: String): String {
        var tk = ""
        try {
            val engine = ScriptEngineManager().getEngineByName("rhino")
            engine.eval(tkReader)

            if (engine is Invocable) {
                val invoke = engine as Invocable
                tk = invoke.invokeFunction("token", text).toString()
            }
        } catch (e: Exception) {
            e.printStackTrace()
        } finally {
            tkReader.close()
        }

        return tk
    }

    override fun execute(): Flowable<ResponseBody> {
        return RequestHelper.get(baseUrl = BASE_URL, paths = PATHS, params = formData)
    }


    companion object {

        //const val GOOGLE_TTS_URL = "https://translate.google.cn/translate_tts"
        private const val BASE_URL = "https://translate.google.com/"//
        private const val PATHS = "translate_tts"
    }
}