package com.cy.sts.util


import java.io.UnsupportedEncodingException
import java.net.URLEncoder
import java.security.MessageDigest
import kotlin.experimental.and


private val hexDigits = charArrayOf('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f')

fun getUrlWithQueryString(url: String, params: Map<String, String>?): String {
    if (params == null) {
        return url
    }

    val builder = StringBuilder(url)
    if (url.contains("?")) {
        builder.append("&")
    } else {
        builder.append("?")
    }

    var index = 0
    for (key in params.keys) {
        val value = params[key] ?: continue
        if (index != 0) {
            builder.append("&")
        }
        index++
        builder.append(key)
        builder.append("=")
        builder.append(encode(value))
    }
    return builder.toString()
}

private fun encode(input: String?): String {
    if (input == null) {
        return ""
    }

    try {
        return URLEncoder.encode(input, "utf-8")
    } catch (e: UnsupportedEncodingException) {
        e.printStackTrace()
    }

    return input
}

fun md5(input: String?): String? {

    if (input == null) return null
    val messageDigest = MessageDigest.getInstance("MD5")
    val inputByteArray = input.toByteArray(charset("utf-8"))
    messageDigest.update(inputByteArray)
    val resultByteArray = messageDigest.digest()
    return byteArrayToHex(resultByteArray)
}

private fun byteArrayToHex(byteArray: ByteArray): String {
    val resultCharArray = CharArray(byteArray.size * 2)
    var index = 0
    for (b in byteArray) {
        resultCharArray[index++] = hexDigits[b.toInt().ushr(4) and 0xf]
        resultCharArray[index++] = hexDigits[(b and 0xf).toInt()]
    }
    return String(resultCharArray)
}

