/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.lib.language.util;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.window.layout.WindowMetrics;
import androidx.window.layout.WindowMetricsCalculator;
import com.talpa.lib.language.util.WindowSizeClass;
import java.lang.reflect.InvocationTargetException;

public final class FoldUtils {
    private FoldUtils() {
    }

    public static boolean isTabletType(Activity activity) {
        return FoldUtils.computeWindowSizeClasses(activity) != WindowSizeClass.COMPACT;
    }

    public static boolean isFreeformMode(@NonNull Context context) {
        try {
            return (Boolean)Configuration.class.getMethod("isThunderbackWindow", new Class[0]).invoke((Object)context.getResources().getConfiguration(), new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return false;
    }

    public static WindowSizeClass computeWindowSizeClasses(Activity activity) {
        WindowMetrics windowMetrics = WindowMetricsCalculator.getOrCreate().computeCurrentWindowMetrics(activity);
        float f = activity.getResources().getDisplayMetrics().density;
        float f2 = (float)windowMetrics.getBounds().width() / f;
        if (activity.getResources().getConfiguration().orientation == 2) {
            f2 = (float)windowMetrics.getBounds().height() / f;
        }
        return f2 < 600.0f ? WindowSizeClass.COMPACT : (f2 < 840.0f ? WindowSizeClass.MEDIUM : WindowSizeClass.EXPANDED);
    }

    @Nullable
    public static Activity getActivity(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            return FoldUtils.getActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }
}

